/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.handlers;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.stem.adapters.file.File;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.views.explorer.IdentifiableTreeNode;
import org.eclipse.stem.ui.widgets.RefactorWizard;
import org.eclipse.stem.ui.widgets.ShowReferencesDialog;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.stem.ui.wizards.STEMWizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class RefactorHandler
extends AbstractHandler
implements IHandler {
    private static String COPY_PREFIX = "CopyOf";

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        TreePath parent;
        Object parentSeg;
        TreeSelection ts;
        TreePath[] paths;
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)executionEvent);
        if (selection instanceof StructuredSelection) {
            for (Object obj : ((StructuredSelection)selection).toList()) {
                File file = (File)Platform.getAdapterManager().getAdapter(obj, File.class);
                if (file != null) {
                    this.doit(file, executionEvent);
                    continue;
                }
                Activator.logError("STEM Internal error rename command applied to \"" + obj.getClass().getName() + "\"", null);
            }
        }
        if (selection instanceof TreeSelection && (paths = (ts = (TreeSelection)selection).getPaths()).length > 0 && (parentSeg = (parent = paths[0].getParentPath()).getLastSegment()) != null) {
            IProject project = null;
            if (parentSeg instanceof IdentifiableTreeNode) {
                project = ((IdentifiableTreeNode)parentSeg).getProject();
            }
            if (parentSeg instanceof IProject) {
                project = (IProject)parentSeg;
            }
            try {
                project.refreshLocal(2, null);
            }
            catch (Exception e) {
                Activator.logError(e.getMessage(), e);
            }
        }
        return null;
    }

    abstract void doit(File var1, ExecutionEvent var2);

    public static class CopyHandler
    extends RefactorHandler {
        @Override
        protected void doit(File file, ExecutionEvent executionEvent) {
            String newname = String.valueOf(COPY_PREFIX) + file.getIdentifiable().getURI().lastSegment();
            if (newname != null) {
                XMIResource resource = file.getResource();
                URI oldURI = resource.getURI();
                URI oldIdURI = file.getIdentifiable().getURI();
                String s_newURI = oldURI.toString().substring(0, oldURI.toString().indexOf(oldURI.lastSegment()));
                String s_newIdURI = oldIdURI.toString().substring(0, oldIdURI.toString().indexOf(oldIdURI.lastSegment()));
                URI newURI = URI.createURI((String)(String.valueOf(s_newURI) + newname));
                URI newIDURI = URI.createURI((String)(String.valueOf(s_newIdURI) + newname));
                try {
                    ArrayList<Identifiable> newlist = new ArrayList<Identifiable>();
                    Identifiable e = (Identifiable)EcoreUtil.copy((EObject)file.getIdentifiable());
                    e.setURI(newIDURI);
                    newlist.add(e);
                    Utility.serializeIdentifiables(newlist, (URI)newURI);
                }
                catch (Exception e) {
                    Activator.logError(e.getMessage(), e);
                }
            }
        }
    }

    public static class RenameHandler
    extends RefactorHandler {
        @Override
        protected void doit(File file, ExecutionEvent executionEvent) {
            IWorkbenchWindow window = null;
            try {
                window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
            }
            catch (ExecutionException e1) {
                e1.printStackTrace();
            }
            RefactorWizard refWizard = new RefactorWizard(file.getIdentifiable(), file.getResource(), false);
            refWizard.init(window.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
            STEMWizardDialog wizardDialog = new STEMWizardDialog(window.getShell(), (IWizard)refWizard);
            wizardDialog.open();
        }
    }

    public static class ShowReferencesHandler
    extends RefactorHandler {
        @Override
        protected void doit(File file, ExecutionEvent executionEvent) {
            Display display = Activator.getDefault().getWorkbench().getDisplay();
            Shell shell = new Shell(display);
            IWorkbenchWindow window = null;
            try {
                window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
            }
            catch (ExecutionException e1) {
                e1.printStackTrace();
            }
            ShowReferencesDialog showRefDialog = new ShowReferencesDialog(shell, 0, file.getIdentifiable(), file.getResource(), Messages.getString("show.references.dialog.title"));
            showRefDialog.open();
        }
    }
}

