/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge.servlet;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.stem.ui.ge.Activator;
import org.eclipse.stem.ui.ge.GELog;

public class VerifyClient {
    public static String outputText = "VerifyClient 0.1.1";
    public static String expectedText = "VerifyServlet 0.1.1";
    private String error = "";

    public boolean verify(String urlstr) {
        boolean result = true;
        this.error = "";
        try {
            URL url = new URL(urlstr);
            URLConnection connect = url.openConnection();
            connect.setUseCaches(false);
            connect.setDoInput(true);
            connect.setDoOutput(true);
            connect.setRequestProperty("Content-type", "application/octet-stream");
            ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(byteOutput);
            String outputString = outputText;
            if (GELog.DEBUG) {
                outputString = String.valueOf(outputText) + " DEBUG ";
            }
            GELog.debug(this, "Sending: " + outputString);
            output.writeUTF(outputString);
            output.flush();
            byte[] buf = byteOutput.toByteArray();
            connect.setRequestProperty("Content-length", "" + buf.length);
            DataOutputStream dataOutput = new DataOutputStream(connect.getOutputStream());
            dataOutput.write(buf);
            dataOutput.flush();
            dataOutput.close();
            DataInputStream in = new DataInputStream(connect.getInputStream());
            String stringValue = in.readUTF();
            in.close();
            if (stringValue.equals(expectedText)) {
                String msg = "OK:  Received: " + stringValue;
                GELog.debug(this, msg);
            } else {
                this.error = "ERROR Expected: " + expectedText + " Received: " + stringValue;
                GELog.debug(this, this.error);
                result = false;
            }
        }
        catch (MalformedURLException e) {
            GELog.debug(e.getMessage());
            this.error = "ERROR Invalid URL " + urlstr;
            result = false;
        }
        catch (IOException e) {
            GELog.debug(e + ": " + e.getMessage());
            this.error = "EXCEPTION  " + e + ": " + e.getMessage();
            result = false;
        }
        Activator.logError(this.error, null);
        return result;
    }

    public String getError() {
        return this.error;
    }

    public static void main(String[] args) {
    }
}

