/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.definitions.functions;

import java.util.ArrayList;
import java.util.Calendar;
import org.eclipse.emf.common.util.EList;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.definitions.labels.AreaLabel;
import org.eclipse.stem.definitions.labels.EarthScienceLabel;

public class CTDLFunctions {
    private static String TYPE_TEMPERATURE = "temperature";
    private static String TYPE_NIGHTTEMPERATURE = "nighttemp";
    private static String TYPE_RAINFALL = "rainfall";
    private static String TYPE_NDVI = "vegetation";
    private static String TYPE_ELEVATION = "elevation";
    public static final double MISSING_DATA = 99999.0;

    public static double area(Node node) {
        EList labels = node.getLabels();
        int i = 0;
        while (i < labels.size()) {
            NodeLabel lab = (NodeLabel)labels.get(i);
            if (lab instanceof AreaLabel) {
                AreaLabel aLab = (AreaLabel)lab;
                return aLab.getCurrentAreaValue().getArea();
            }
            ++i;
        }
        return -1.0;
    }

    public static double temperature(Node node, STEMTime time, long timeDelta, double t) {
        return CTDLFunctions.getInterpolatedEarthScienceValue(node, time, timeDelta, t, TYPE_TEMPERATURE);
    }

    public static double nighttemp(Node node, STEMTime time, long timeDelta, double t) {
        return CTDLFunctions.getInterpolatedEarthScienceValue(node, time, timeDelta, t, TYPE_NIGHTTEMPERATURE);
    }

    public static double ndvi(Node node, STEMTime time, long timeDelta, double t) {
        return CTDLFunctions.getInterpolatedEarthScienceValue(node, time, timeDelta, t, TYPE_NDVI);
    }

    public static double precipitation(Node node, STEMTime time, long timeDelta, double t) {
        return CTDLFunctions.getInterpolatedEarthScienceValue(node, time, timeDelta, t, TYPE_RAINFALL);
    }

    public static double elevation(Node node, STEMTime time, long timeDelta, double t) {
        DateInfo dInfo = CTDLFunctions.getDateInfo(time, timeDelta, t);
        EarthScienceLabel lab = CTDLFunctions.getEarthScienceLabel(node, dInfo.year, TYPE_ELEVATION);
        if (lab == null) {
            return 99999.0;
        }
        return (Double)lab.getCurrentEarthScienceValue().getMean().get(0);
    }

    private static double getInterpolatedEarthScienceValue(Node node, STEMTime time, long timeDelta, double t, String type) {
        DateInfo dInfo = CTDLFunctions.getDateInfo(time, timeDelta, t);
        EarthScienceLabel lab1 = CTDLFunctions.getEarthScienceLabel(node, dInfo.year, type);
        if (lab1 == null) {
            return 99999.0;
        }
        EarthScienceLabel lab2 = dInfo.year != dInfo.next_month_year ? CTDLFunctions.getEarthScienceLabel(node, dInfo.year, type) : lab1;
        double v1 = (Double)lab1.getCurrentEarthScienceValue().getMean().get(dInfo.month);
        double v2 = (Double)lab2.getCurrentEarthScienceValue().getMean().get(dInfo.next_month);
        if (v1 == 99999.0) {
            return 99999.0;
        }
        if (v2 == 99999.0) {
            return 99999.0;
        }
        return dInfo.fraction * v2 + (1.0 - dInfo.fraction) * v1;
    }

    private static EarthScienceLabel getEarthScienceLabel(Node node, int year, String type) {
        EList labels = node.getLabels();
        ArrayList<EarthScienceLabel> allLabels = new ArrayList<EarthScienceLabel>();
        ArrayList<Integer> allYears = new ArrayList<Integer>();
        ArrayList<Integer> allTwoDigYears = new ArrayList<Integer>();
        int i = 0;
        while (i < labels.size()) {
            NodeLabel lab = (NodeLabel)labels.get(i);
            if (lab instanceof EarthScienceLabel && ((EarthScienceLabel)lab).getCurrentEarthScienceValue().getDataType().equals(type)) {
                EarthScienceLabel eLab = (EarthScienceLabel)lab;
                if (type.equals(TYPE_ELEVATION)) {
                    return eLab;
                }
                allLabels.add(eLab);
                int esYear = eLab.getCurrentEarthScienceValue().getValidYear();
                allYears.add(esYear);
                int twoDigYear = esYear - esYear / 100 * 100;
                allTwoDigYears.add(twoDigYear);
            }
            ++i;
        }
        if (allLabels.size() == 0) {
            return null;
        }
        if (allLabels.size() == 1) {
            return (EarthScienceLabel)allLabels.get(0);
        }
        if (allYears.indexOf(year) != -1) {
            return (EarthScienceLabel)allLabels.get(allYears.indexOf(year));
        }
        int twoDigYear = year - year / 100 * 100;
        if (allTwoDigYears.indexOf(twoDigYear) != -1) {
            return (EarthScienceLabel)allLabels.get(allTwoDigYears.indexOf(twoDigYear));
        }
        return (EarthScienceLabel)allLabels.get(0);
    }

    private static DateInfo getDateInfo(STEMTime time, long timeDelta, double t) {
        int year;
        Calendar c = Calendar.getInstance();
        long iPart = (long)t;
        double fPart = t - (double)iPart;
        long fracMillis = (long)((double)timeDelta * fPart);
        STEMTime actualTime = time.addIncrement(fracMillis);
        c.setTime(actualTime.getTime());
        int month = c.get(2);
        int nextMonth = month + 1;
        int nextMonthYear = year = c.get(1);
        if (nextMonth > 11) {
            nextMonth = 0;
            nextMonthYear = year + 1;
        }
        double dayOfMonth = c.get(5);
        double hourOfDay = c.get(11);
        double minOfHour = c.get(12);
        double secondOfMinute = c.get(13);
        double daysInMonth = c.getActualMaximum(5);
        double preciseDayInMonth = dayOfMonth + hourOfDay / 24.0 + minOfHour / 1440.0 + secondOfMinute / 86400.0;
        double fraction = (preciseDayInMonth -= 1.0) / daysInMonth;
        DateInfo dInfo = new DateInfo();
        dInfo.year = year;
        dInfo.next_month_year = nextMonthYear;
        dInfo.month = month;
        dInfo.next_month = nextMonth;
        dInfo.fraction = fraction;
        return dInfo;
    }

    private static class DateInfo {
        public int year;
        public int next_month_year;
        public int month;
        public int next_month;
        public double fraction;

        private DateInfo() {
        }
    }
}

