/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.toc;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.internal.ua.core.toc.text.TocObject;
import org.eclipse.pde.internal.ua.ui.editor.toc.TocTreeSection;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;

public class TocDragAdapter
implements DragSourceListener {
    private TocTreeSection fSection;
    private ArrayList<TocObject> fDraggedItems;

    public TocDragAdapter(TocTreeSection section) {
        this.fSection = section;
    }

    public void dragStart(DragSourceEvent event) {
        if (event.doit) {
            event.doit = !this.fSection.getSelection().isEmpty();
        }
    }

    public void dragSetData(DragSourceEvent event) {
        if (event.doit) {
            IStructuredSelection sel = (IStructuredSelection)this.fSection.getSelection();
            if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                StringWriter sw = new StringWriter();
                PrintWriter writer = new PrintWriter(sw);
                for (Object obj : sel) {
                    if (!(obj instanceof TocObject)) continue;
                    ((TocObject)obj).write("", writer);
                }
                event.data = sw.toString();
                this.fDraggedItems = null;
            } else if (ModelDataTransfer.getInstance().isSupportedType(event.dataType)) {
                this.fDraggedItems = this.getSelectedObjects(sel);
                TocObject[] selectedObjects = this.fDraggedItems.toArray(new TocObject[this.fDraggedItems.size()]);
                if (selectedObjects.length == 0) {
                    event.doit = false;
                } else {
                    event.data = selectedObjects;
                }
            }
        }
    }

    private ArrayList<TocObject> getSelectedObjects(IStructuredSelection selection) {
        ArrayList<TocObject> objects = new ArrayList<TocObject>();
        for (Object obj : selection) {
            if (obj instanceof TocObject && ((TocObject)obj).canBeRemoved()) {
                objects.add((TocObject)obj);
                continue;
            }
            return new ArrayList<TocObject>();
        }
        return objects;
    }

    public void dragFinished(DragSourceEvent event) {
        if (event.detail == 2 && this.fDraggedItems != null) {
            this.fSection.handleDrag(this.fDraggedItems);
        }
        this.fDraggedItems = null;
    }

    public ArrayList<TocObject> getDraggedElements() {
        return this.fDraggedItems;
    }
}

