/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.console.JavaStackTraceConsole;
import org.eclipse.jdt.internal.debug.ui.console.JavaStackTraceConsoleFactory;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenFromClipboardAction
implements IWorkbenchWindowActionDelegate {
    private static final String SIMPLE_NAME_PATTERN = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final String QUALIFIED_NAME_PATTERN = "(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final String STRICT_QUALIFIED_NAME_PATTERN = "(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)+\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final String WS = "\\s*";
    private static final String JAVA_FILE_PATTERN = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.java";
    private static final String JAVA_FILE_LINE_PATTERN = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.java\\s*:\\s*\\d+";
    private static final String TYPE_LINE_PATTERN = "(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\s*:\\s*\\d+";
    private static final String STACK_TRACE_LINE_PATTERN = ".*\\(\\s*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.java\\s*:\\s*\\d+\\s*\\)";
    private static final String METHOD_PATTERN = "(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\(.*\\)";
    private static final String STACK_PATTERN = "(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\(.*\\).*\\d+";
    private static final String MEMBER_PATTERN = "(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*#\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final String METHOD_JAVADOC_REFERENCE_PATTERN = "(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*#\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\(.*\\)";
    private static final int INVALID = 0;
    private static final int QUALIFIED_NAME = 1;
    private static final int JAVA_FILE = 2;
    private static final int JAVA_FILE_LINE = 3;
    private static final int TYPE_LINE = 4;
    private static final int STACK_TRACE_LINE = 5;
    private static final int METHOD = 6;
    private static final int STACK = 7;
    private static final int MEMBER = 8;
    private static final int METHOD_JAVADOC_REFERENCE = 9;
    private static final String TASK_NAME = ActionMessages.OpenFromClipboardAction_OpeningFromClipboard;

    public void run(IAction action) {
        TextTransfer textTransfer;
        Clipboard clipboard = new Clipboard(Display.getDefault());
        String inputText = (String)clipboard.getContents((Transfer)(textTransfer = TextTransfer.getInstance()));
        if (inputText == null || inputText.length() == 0) {
            OpenFromClipboardAction.openInputEditDialog("");
            return;
        }
        if (OpenFromClipboardAction.isSingleLineInput(inputText)) {
            OpenFromClipboardAction.handleSingleLineInput(inputText);
            return;
        }
        OpenFromClipboardAction.handleMultipleLineInput(inputText);
    }

    private static JavaStackTraceConsole getJavaStackTraceConsole() {
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] consoles = consoleManager.getConsoles();
        int i = 0;
        while (i < consoles.length) {
            if (consoles[i] instanceof JavaStackTraceConsole) {
                return (JavaStackTraceConsole)consoles[i];
            }
            ++i;
        }
        return null;
    }

    private static void handleMultipleLineInput(String inputText) {
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        JavaStackTraceConsole console = OpenFromClipboardAction.getJavaStackTraceConsole();
        if (console != null) {
            console.getDocument().set(inputText);
            consoleManager.showConsoleView((IConsole)console);
        } else {
            JavaStackTraceConsoleFactory javaStackTraceConsoleFactory = new JavaStackTraceConsoleFactory();
            javaStackTraceConsoleFactory.openConsole(inputText);
            console = OpenFromClipboardAction.getJavaStackTraceConsole();
        }
        IPreferenceStore preferenceStore = JDIDebugUIPlugin.getDefault().getPreferenceStore();
        if (preferenceStore.getBoolean(IJDIPreferencesConstants.PREF_AUTO_FORMAT_JSTCONSOLE)) {
            console.format();
        }
    }

    private static boolean isSingleLineInput(String inputText) {
        String lineDelimiter = System.getProperty("line.separator");
        String s = inputText.trim();
        return s.indexOf(lineDelimiter) == -1;
    }

    private static int getMatchingPattern(String s) {
        if (s.matches(JAVA_FILE_LINE_PATTERN)) {
            return 3;
        }
        if (s.matches(JAVA_FILE_PATTERN)) {
            return 2;
        }
        if (s.matches(TYPE_LINE_PATTERN)) {
            return 4;
        }
        if (s.matches(STACK_TRACE_LINE_PATTERN)) {
            return 5;
        }
        if (s.matches(METHOD_PATTERN)) {
            return 6;
        }
        if (s.matches(STACK_PATTERN)) {
            return 7;
        }
        if (s.matches(MEMBER_PATTERN)) {
            return 8;
        }
        if (s.matches(METHOD_JAVADOC_REFERENCE_PATTERN)) {
            return 9;
        }
        if (s.matches(QUALIFIED_NAME_PATTERN)) {
            return 1;
        }
        return 0;
    }

    private static void handleSingleLineInput(String inputText) {
        ArrayList<Object> matches = new ArrayList<Object>();
        try {
            int line = OpenFromClipboardAction.getJavaElementMatches(inputText, matches);
            OpenFromClipboardAction.handleMatches(matches, line, inputText);
        }
        catch (InterruptedException interruptedException) {}
    }

    private static int getJavaElementMatches(String inputText, List<Object> matches) throws InterruptedException {
        String s = inputText.trim();
        switch (OpenFromClipboardAction.getMatchingPattern(s)) {
            case 3: {
                int index = s.indexOf(58);
                String typeName = s.substring(0, index);
                typeName = s.substring(0, typeName.indexOf(".java"));
                String lineNumber = s.substring(index + 1, s.length());
                lineNumber = lineNumber.trim();
                int line = Integer.valueOf(lineNumber);
                OpenFromClipboardAction.getTypeMatches(typeName, matches);
                return line;
            }
            case 2: {
                String typeName = s.substring(0, s.indexOf(".java"));
                OpenFromClipboardAction.getTypeMatches(typeName, matches);
                return -1;
            }
            case 4: {
                int index = s.indexOf(58);
                String typeName = s.substring(0, index);
                typeName = typeName.trim();
                String lineNumber = s.substring(index + 1, s.length());
                lineNumber = lineNumber.trim();
                int line = Integer.valueOf(lineNumber);
                OpenFromClipboardAction.getTypeMatches(typeName, matches);
                return line;
            }
            case 5: {
                int index1 = s.indexOf(40);
                int index2 = s.indexOf(41);
                String typeLine = s.substring(index1 + 1, index2).trim();
                int index = typeLine.indexOf(58);
                String lineNumber = typeLine.substring(index + 1, typeLine.length()).trim();
                int line = Integer.valueOf(lineNumber);
                Pattern pattern = Pattern.compile("(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)+\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\s*\\(");
                Matcher matcher = pattern.matcher(s);
                if (matcher.find()) {
                    String qualifiedName = matcher.group();
                    index = qualifiedName.lastIndexOf(46);
                    qualifiedName = qualifiedName.substring(0, index);
                    OpenFromClipboardAction.getTypeMatches(qualifiedName, matches);
                } else {
                    String typeName = typeLine.substring(0, index);
                    typeName = typeLine.substring(0, typeName.indexOf(".java"));
                    OpenFromClipboardAction.getTypeMatches(typeName, matches);
                }
                return line;
            }
            case 6: {
                OpenFromClipboardAction.getMethodMatches(s, matches);
                return -1;
            }
            case 7: {
                int index = s.indexOf(41);
                String method = s.substring(0, index + 1);
                index = s.indexOf(58);
                String lineNumber = s.substring(index + 1).trim();
                int line = Integer.valueOf(lineNumber);
                OpenFromClipboardAction.getMethodMatches(method, matches);
                return line;
            }
            case 8: {
                OpenFromClipboardAction.getMemberMatches(s.replace('#', '.'), matches);
                return -1;
            }
            case 9: {
                OpenFromClipboardAction.getMethodMatches(s.replace('#', '.'), matches);
                return -1;
            }
            case 1: {
                OpenFromClipboardAction.getNameMatches(s, matches);
                return -1;
            }
        }
        return -1;
    }

    private static void getTypeMatches(final String typeName, final List<Object> matches) throws InterruptedException {
        OpenFromClipboardAction.executeRunnable(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                OpenFromClipboardAction.doTypeSearch(typeName, matches, monitor);
            }
        });
    }

    private static void getMethodMatches(final String s, final List<Object> matches) throws InterruptedException {
        OpenFromClipboardAction.executeRunnable(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                OpenFromClipboardAction.doMemberSearch(s, matches, true, true, false, monitor, 100);
            }
        });
    }

    private static void getMemberMatches(final String s, final List<Object> matches) throws InterruptedException {
        OpenFromClipboardAction.executeRunnable(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                OpenFromClipboardAction.doMemberSearch(s, matches, true, true, true, monitor, 100);
            }
        });
    }

    private static void getNameMatches(final String s, final List<Object> matches) throws InterruptedException {
        OpenFromClipboardAction.executeRunnable(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                progress.beginTask(TASK_NAME, 100);
                OpenFromClipboardAction.doTypeSearch(s, matches, (IProgressMonitor)progress.newChild(34));
                OpenFromClipboardAction.doMemberSearch(s, matches, true, false, true, (IProgressMonitor)progress.newChild(34), 66);
            }
        });
    }

    private static void executeRunnable(IRunnableWithProgress runnableWithProgress) throws InterruptedException {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnableWithProgress);
        }
        catch (InvocationTargetException e) {
            JDIDebugUIPlugin.log(e);
        }
    }

    private static void handleMatches(List<Object> matches, int line, String inputText) throws InterruptedException {
        if (matches.size() > 1) {
            int flags = JavaElementLabelProvider.SHOW_DEFAULT | 0x400 | 0x40;
            IWorkbenchWindow window = JDIDebugUIPlugin.getActiveWorkbenchWindow();
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(window.getShell(), (ILabelProvider)new JavaElementLabelProvider(flags));
            dialog.setTitle(ActionMessages.OpenFromClipboardAction_OpenFromClipboard);
            dialog.setMessage(ActionMessages.OpenFromClipboardAction_SelectOrEnterTheElementToOpen);
            dialog.setElements(matches.toArray());
            dialog.setMultipleSelection(true);
            int result = dialog.open();
            if (result != 0) {
                return;
            }
            Object[] elements = dialog.getResult();
            if (elements != null && elements.length > 0) {
                OpenFromClipboardAction.openJavaElements(elements, line);
            }
        } else if (matches.size() == 1) {
            OpenFromClipboardAction.openJavaElements(matches.toArray(), line);
        } else if (matches.size() == 0) {
            OpenFromClipboardAction.openInputEditDialog(inputText);
        }
    }

    private static void openJavaElements(Object[] elements, int line) {
        int i = 0;
        while (i < elements.length) {
            Object ob = elements[i];
            if (ob instanceof IJavaElement) {
                IJavaElement element = (IJavaElement)ob;
                try {
                    IEditorPart editorPart = JavaUI.openInEditor((IJavaElement)element);
                    OpenFromClipboardAction.gotoLine(editorPart, line, element);
                }
                catch (PartInitException e) {
                    JDIDebugUIPlugin.log(e);
                }
                catch (JavaModelException e) {
                    JDIDebugUIPlugin.log(e);
                }
            }
            ++i;
        }
    }

    private static void gotoLine(IEditorPart editorPart, int line, IJavaElement element) throws JavaModelException {
        if (line <= 0) {
            return;
        }
        ITextEditor editor = (ITextEditor)editorPart;
        IDocumentProvider provider = editor.getDocumentProvider();
        IDocument document = provider.getDocument((Object)editor.getEditorInput());
        try {
            if (element instanceof IMethod) {
                ISourceRange sourceRange = ((IMethod)element).getSourceRange();
                int start = sourceRange.getOffset();
                int end = start + sourceRange.getLength();
                start = document.getLineOfOffset(start);
                end = document.getLineOfOffset(end);
                if (start > line || end < line) {
                    return;
                }
            }
            int start = document.getLineOffset(line - 1);
            editor.selectAndReveal(start, 0);
            IWorkbenchPage page = editor.getSite().getPage();
            page.activate((IWorkbenchPart)editor);
        }
        catch (BadLocationException badLocationException) {}
    }

    private static void openInputEditDialog(String inputText) {
        IWorkbenchWindow window = JDIDebugUIPlugin.getActiveWorkbenchWindow();
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                return newText.length() == 0 ? "" : null;
            }
        };
        InputDialog dialog = new InputDialog(window.getShell(), ActionMessages.OpenFromClipboardAction_OpenFromClipboard, ActionMessages.OpenFromClipboardAction_ElementToOpen, inputText, validator);
        int result = dialog.open();
        if (result != 0) {
            return;
        }
        inputText = dialog.getValue();
        OpenFromClipboardAction.handleSingleLineInput(inputText);
    }

    private static SearchPattern createSearchPattern(String s, int searchFor) {
        return SearchPattern.createPattern((String)s, (int)searchFor, (int)0, (int)OpenFromClipboardAction.getSearchFlags());
    }

    private static int getSearchFlags() {
        return 24;
    }

    private static SearchRequestor createSearchRequestor(final List<Object> matches) {
        return new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) {
                if (match.getAccuracy() == 0) {
                    matches.add(match.getElement());
                }
            }
        };
    }

    private static SearchParticipant[] createSearchParticipant() {
        return new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
    }

    private static void doTypeSearch(String typeName, final List<Object> matches, IProgressMonitor monitor) {
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        SearchEngine searchEngine = new SearchEngine();
        String packageName = null;
        int index = typeName.lastIndexOf(46);
        if (index != -1) {
            packageName = typeName.substring(0, index);
            typeName = typeName.substring(index + 1);
        }
        try {
            searchEngine.searchAllTypeNames(packageName == null ? null : packageName.toCharArray(), packageName == null ? 0 : OpenFromClipboardAction.getSearchFlags(), typeName.toCharArray(), OpenFromClipboardAction.getSearchFlags(), 0, scope, new TypeNameMatchRequestor(){

                public void acceptTypeNameMatch(TypeNameMatch match) {
                    matches.add(match.getType());
                }
            }, 3, monitor);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
    }

    private static void doMemberSearch(String memberName, List<Object> matches, boolean searchForMethods, boolean searchForConstructors, boolean searchForFields, IProgressMonitor monitor, int work) {
        int noOfSearches = 0;
        noOfSearches = searchForMethods ? noOfSearches + 1 : noOfSearches;
        noOfSearches = searchForConstructors ? noOfSearches + 1 : noOfSearches;
        int n = noOfSearches = searchForFields ? noOfSearches + 1 : noOfSearches;
        if (noOfSearches == 0) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.beginTask(TASK_NAME, work);
        IJavaSearchScope scope = null;
        SearchRequestor requestor = OpenFromClipboardAction.createSearchRequestor(matches);
        SearchEngine searchEngine = new SearchEngine();
        String typeName = null;
        int index = memberName.lastIndexOf(46);
        if (index != -1) {
            typeName = memberName.substring(0, index);
            memberName = memberName.substring(index + 1);
            ArrayList<Object> typeMatches = new ArrayList<Object>();
            OpenFromClipboardAction.doTypeSearch(typeName, typeMatches, (IProgressMonitor)progress.newChild(work / ++noOfSearches));
            IType[] types = new IType[typeMatches.size()];
            int i = 0;
            while (i < typeMatches.size()) {
                types[i] = (IType)typeMatches.get(i);
                ++i;
            }
            scope = SearchEngine.createJavaSearchScope((IJavaElement[])types);
        } else {
            scope = SearchEngine.createWorkspaceScope();
        }
        try {
            int workPerSearch = work / noOfSearches;
            if (searchForMethods) {
                OpenFromClipboardAction.doMemberSearch(searchEngine, memberName, 1, scope, requestor, progress.newChild(workPerSearch));
            }
            if (searchForConstructors) {
                OpenFromClipboardAction.doMemberSearch(searchEngine, memberName, 3, scope, requestor, progress.newChild(workPerSearch));
            }
            if (searchForFields) {
                OpenFromClipboardAction.doMemberSearch(searchEngine, memberName, 4, scope, requestor, progress.newChild(workPerSearch));
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
    }

    private static void doMemberSearch(SearchEngine searchEngine, String memberName, int searchFor, IJavaSearchScope scope, SearchRequestor requestor, SubMonitor progressMonitor) throws CoreException {
        SearchPattern pattern = OpenFromClipboardAction.createSearchPattern(memberName, searchFor);
        if (pattern != null) {
            searchEngine.search(pattern, OpenFromClipboardAction.createSearchParticipant(), scope, requestor, (IProgressMonitor)progressMonitor);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

