/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.InstructionPointerContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class InstructionPointerManager {
    private static InstructionPointerManager fgDefault;
    private Set fIPCSet = new HashSet();
    private Map fEditorMap = new HashMap();
    private IPartListener2 fPartListener;
    private IPageListener fPageListener;

    private InstructionPointerManager() {
    }

    public static InstructionPointerManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new InstructionPointerManager();
        }
        return fgDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotation(ITextEditor textEditor, IStackFrame frame, Annotation annotation) {
        IEditorInput editorInput;
        IDocumentProvider docProvider = textEditor.getDocumentProvider();
        IAnnotationModel annModel = docProvider.getAnnotationModel((Object)(editorInput = textEditor.getEditorInput()));
        if (annModel == null) {
            return;
        }
        Position position = null;
        int charStart = -1;
        int length = -1;
        try {
            charStart = frame.getCharStart();
            length = frame.getCharEnd() - charStart;
        }
        catch (DebugException debugException) {}
        if (charStart < 0) {
            IDocument doc = docProvider.getDocument((Object)editorInput);
            if (doc == null) {
                return;
            }
            try {
                int lineNumber = frame.getLineNumber() - 1;
                IRegion region = doc.getLineInformation(lineNumber);
                charStart = region.getOffset();
                length = region.getLength();
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            catch (DebugException debugException) {
                return;
            }
        }
        if (charStart < 0) {
            return;
        }
        position = new Position(charStart, length);
        if (frame.isTerminated()) {
            return;
        }
        Set set = this.fIPCSet;
        synchronized (set) {
            annModel.removeAnnotation(annotation);
            annModel.addAnnotation(annotation, position);
            InstructionPointerContext ipc = new InstructionPointerContext(frame.getDebugTarget(), frame.getThread(), textEditor, annotation);
            HashSet<InstructionPointerContext> editorIPCs = (HashSet<InstructionPointerContext>)this.fEditorMap.get(textEditor);
            if (editorIPCs == null) {
                editorIPCs = new HashSet<InstructionPointerContext>();
                this.fEditorMap.put(textEditor, editorIPCs);
            } else {
                editorIPCs.remove(ipc);
            }
            editorIPCs.add(ipc);
            this.fIPCSet.remove(ipc);
            this.fIPCSet.add(ipc);
            textEditor.getSite().getPage().addPartListener(this.getPartListener());
            textEditor.getSite().getPage().getWorkbenchWindow().addPageListener(this.getPageListener());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotations(IDebugTarget debugTarget) {
        Set set = this.fIPCSet;
        synchronized (set) {
            Iterator ipcIter = this.fIPCSet.iterator();
            while (ipcIter.hasNext()) {
                InstructionPointerContext currentIPC = (InstructionPointerContext)ipcIter.next();
                if (!currentIPC.getDebugTarget().equals(debugTarget)) continue;
                this.removeAnnotationFromModel(currentIPC);
                ipcIter.remove();
                this.removeAnnotationFromEditorMapping(currentIPC);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotations(IThread thread) {
        Set set = this.fIPCSet;
        synchronized (set) {
            Iterator ipcIter = this.fIPCSet.iterator();
            while (ipcIter.hasNext()) {
                InstructionPointerContext currentIPC = (InstructionPointerContext)ipcIter.next();
                if (!currentIPC.getThread().equals(thread)) continue;
                this.removeAnnotationFromModel(currentIPC);
                ipcIter.remove();
                this.removeAnnotationFromEditorMapping(currentIPC);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotations(ITextEditor editor) {
        Set set = this.fIPCSet;
        synchronized (set) {
            Set editorIPCs = (Set)this.fEditorMap.get(editor);
            if (editorIPCs != null) {
                Iterator ipcIter = editorIPCs.iterator();
                while (ipcIter.hasNext()) {
                    InstructionPointerContext currentIPC = (InstructionPointerContext)ipcIter.next();
                    this.removeAnnotationFromModel(currentIPC);
                    this.fIPCSet.remove(currentIPC);
                }
                this.fEditorMap.remove(editor);
            }
        }
    }

    private void removeAnnotationFromEditorMapping(InstructionPointerContext ipc) {
        Set editorIPCs = (Set)this.fEditorMap.get(ipc.getEditor());
        if (editorIPCs != null) {
            editorIPCs.remove(ipc);
            if (editorIPCs.isEmpty()) {
                this.fEditorMap.remove(ipc.getEditor());
            }
        }
    }

    private void removeAnnotationFromModel(InstructionPointerContext ipc) {
        IAnnotationModel annotationModel;
        IDocumentProvider docProvider = ipc.getEditor().getDocumentProvider();
        if (docProvider != null && (annotationModel = docProvider.getAnnotationModel((Object)ipc.getEditor().getEditorInput())) != null) {
            annotationModel.removeAnnotation(ipc.getAnnotation());
        }
    }

    public int getInstructionPointerCount() {
        return this.fIPCSet.size();
    }

    public int getEditorMappingCount() {
        return this.fEditorMap.size();
    }

    private IPageListener getPageListener() {
        if (this.fPageListener == null) {
            this.fPageListener = new PageListener();
        }
        return this.fPageListener;
    }

    private IPartListener2 getPartListener() {
        if (this.fPartListener == null) {
            this.fPartListener = new PartListener();
        }
        return this.fPartListener;
    }

    class PageListener
    implements IPageListener {
        PageListener() {
        }

        public void pageActivated(IWorkbenchPage page) {
        }

        public void pageOpened(IWorkbenchPage page) {
        }

        public void pageClosed(IWorkbenchPage page) {
            page.removePartListener(InstructionPointerManager.this.getPartListener());
            page.getWorkbenchWindow().removePageListener(InstructionPointerManager.this.getPageListener());
        }
    }

    class PartListener
    implements IPartListener2 {
        PartListener() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part instanceof ITextEditor) {
                InstructionPointerManager.this.removeAnnotations((ITextEditor)part);
            }
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part instanceof ITextEditor) {
                InstructionPointerManager.this.removeAnnotations((ITextEditor)part);
            }
        }
    }
}

