/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.propertiesfileeditor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.FindBrokenNLSKeysAction;
import org.eclipse.jdt.internal.ui.javaeditor.ToggleCommentAction;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.OpenAction;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileEditorMessages;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.texteditor.ITextEditor;

public class PropertiesFileEditor
extends TextEditor {
    protected OpenAction fOpenAction;
    private IPropertyChangeListener fPropertyChangeListener;
    private Map<IEditorInput, IType> fAccessorTypes = new HashMap<IEditorInput, IType>();
    private Job fJob;
    private IFile fFile;

    protected void initializeEditor() {
        this.setDocumentProvider(JavaPlugin.getDefault().getPropertiesFileDocumentProvider());
        IPreferenceStore store = JavaPlugin.getDefault().getCombinedPreferenceStore();
        this.setPreferenceStore(store);
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new PropertiesFileSourceViewerConfiguration(textTools.getColorManager(), store, (ITextEditor)this, "___pf_partitioning"));
        this.setEditorContextMenuId("#TextEditorContext");
        this.setRulerContextMenuId("#TextRulerContext");
        this.setHelpContextId("org.eclipse.ui.text_editor_context");
        this.configureInsertMode(SMART_INSERT, false);
        this.setInsertMode(INSERT);
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("spacesForTabs".equals(event.getProperty())) {
                    PropertiesFileEditor.this.handlePreferenceStoreChanged(event);
                }
            }
        };
        EditorsUI.getPreferenceStore().addPropertyChangeListener(this.fPropertyChangeListener);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        if (this.fJob != null) {
            this.fJob.cancel();
        }
        this.fFile = (IFile)this.getEditorInput().getAdapter(IFile.class);
        if (this.fFile == null) {
            return;
        }
        if (this.fJob == null) {
            this.fJob = new Job(PropertiesFileEditorMessages.PropertiesFileEditor_find_accessor_type){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        PropertiesFileEditor.this.fAccessorTypes.put(PropertiesFileEditor.this.getEditorInput(), PropertiesFileEditor.this.findAccessorType(monitor));
                    }
                    catch (JavaModelException e) {
                        JavaPlugin.log(e);
                    }
                    return Status.OK_STATUS;
                }
            };
            this.fJob.setSystem(true);
        }
        this.fJob.schedule();
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.jdt.ui.propertiesEditorScope"});
    }

    protected void createActions() {
        super.createActions();
        ToggleCommentAction action = new ToggleCommentAction(PropertiesFileEditorMessages.getBundleForConstructedKeys(), "ToggleComment.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.toggle.comment");
        this.setAction("org.eclipse.jdt.ui.edit.text.java.toggle.comment", (IAction)action);
        this.markAsStateDependentAction("org.eclipse.jdt.ui.edit.text.java.toggle.comment", true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.eclipse.jdt.ui.toggle_comment_action");
        this.configureToggleCommentAction();
        this.fOpenAction = new OpenAction(this);
        this.fOpenAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.editor");
        this.setAction("org.eclipse.jdt.ui.actions.Open", (IAction)this.fOpenAction);
    }

    private void configureToggleCommentAction() {
        IAction action = this.getAction("org.eclipse.jdt.ui.edit.text.java.toggle.comment");
        if (action instanceof ToggleCommentAction) {
            ISourceViewer sourceViewer = this.getSourceViewer();
            SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
            ((ToggleCommentAction)action).configure(sourceViewer, configuration);
        }
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        try {
            ISourceViewer sourceViewer = this.getSourceViewer();
            if (sourceViewer == null) {
                return;
            }
            ((PropertiesFileSourceViewerConfiguration)this.getSourceViewerConfiguration()).handlePropertyChangeEvent(event);
        }
        finally {
            super.handlePreferenceStoreChanged(event);
        }
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        return ((PropertiesFileSourceViewerConfiguration)this.getSourceViewerConfiguration()).affectsTextPresentation(event) || super.affectsTextPresentation(event);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IShowInTargetList.class) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.jdt.ui.PackageExplorer", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        return super.getAdapter(adapter);
    }

    public int getOrientation() {
        return 0x2000000;
    }

    protected void updateStatusField(String category) {
        super.updateStatusField(category);
        if (this.getEditorSite() != null) {
            this.getEditorSite().getActionBars().getStatusLineManager().setMessage(null);
            this.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(null);
        }
    }

    ISourceViewer internalGetSourceViewer() {
        return this.getSourceViewer();
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] ids = super.collectContextMenuPreferencePages();
        String[] more = new String[ids.length + 1];
        more[0] = "org.eclipse.jdt.ui.preferences.PropertiesFileEditorPreferencePage";
        System.arraycopy(ids, 0, more, 1, ids.length);
        return more;
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addAction(menu, "group.edit", "org.eclipse.jdt.ui.edit.text.java.toggle.comment");
    }

    protected boolean isTabsToSpacesConversionEnabled() {
        return EditorsUI.getPreferenceStore().getBoolean("spacesForTabs");
    }

    public void dispose() {
        EditorsUI.getPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
        if (this.fJob != null) {
            this.fJob.cancel();
        }
        super.dispose();
    }

    public IType getAccessorType() {
        return this.fAccessorTypes.get(this.getEditorInput());
    }

    private IType findAccessorType(IProgressMonitor pm) throws JavaModelException {
        IType accessorType = FindBrokenNLSKeysAction.getAccessorType(this.fFile);
        if (accessorType != null) {
            return accessorType;
        }
        if (pm != null && pm.isCanceled()) {
            return null;
        }
        IContainer parent = this.fFile.getParent();
        IJavaElement javaElement = JavaCore.create((IResource)parent);
        if (!(javaElement instanceof IPackageFragment)) {
            return null;
        }
        ICompilationUnit[] compilationUnits = ((IPackageFragment)javaElement).getCompilationUnits();
        int i = 0;
        while (i < compilationUnits.length) {
            if (this.evaluateCU(compilationUnits[i], this.fFile)) {
                return compilationUnits[i].getTypes()[0];
            }
            if (pm != null && pm.isCanceled()) {
                return null;
            }
            ++i;
        }
        return null;
    }

    private boolean evaluateCU(ICompilationUnit compilationUnit, IFile file) throws JavaModelException {
        IStorage bundle = FindBrokenNLSKeysAction.getResourceBundle(compilationUnit);
        if (!(bundle instanceof IFile)) {
            return false;
        }
        return file.equals((Object)bundle);
    }
}

