/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.dialogs;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.DialogsMessages;
import org.eclipse.jdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class SortMembersMessageDialog
extends OptionalMessageDialog {
    private static final String OPTIONAL_ID = "SortMembersMessageDialog.optionalDialog.id";
    private static final String DIALOG_SETTINGS_SORT_ALL = "SortMembers.sort_all";
    private SelectionButtonDialogField fNotSortAllRadio;
    private SelectionButtonDialogField fSortAllRadio;
    private final IDialogSettings fDialogSettings = JavaPlugin.getDefault().getDialogSettings();

    public SortMembersMessageDialog(Shell parentShell) {
        super(OPTIONAL_ID, parentShell, DialogsMessages.SortMembersMessageDialog_dialog_title, null, new String(), 2, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        boolean isSortAll = this.fDialogSettings.getBoolean(DIALOG_SETTINGS_SORT_ALL);
        this.fNotSortAllRadio = new SelectionButtonDialogField(16);
        this.fNotSortAllRadio.setLabelText(DialogsMessages.SortMembersMessageDialog_do_not_sort_fields_label);
        this.fNotSortAllRadio.setSelection(!isSortAll);
        this.fSortAllRadio = new SelectionButtonDialogField(16);
        this.fSortAllRadio.setLabelText(DialogsMessages.SortMembersMessageDialog_sort_all_label);
        this.fSortAllRadio.setSelection(isSortAll);
    }

    protected boolean isResizable() {
        return true;
    }

    private Control createLinkControl(Composite composite) {
        Link link = new Link(composite, 131136);
        link.setText(DialogsMessages.SortMembersMessageDialog_description);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SortMembersMessageDialog.this.openMembersSortOrderPage();
            }
        });
        link.setToolTipText(DialogsMessages.SortMembersMessageDialog_link_tooltip);
        GridData gridData = new GridData(4, 2, true, false);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(300);
        link.setLayoutData((Object)gridData);
        link.setFont(composite.getFont());
        return link;
    }

    protected void openMembersSortOrderPage() {
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)"org.eclipse.jdt.ui.preferences.MembersOrderPreferencePage", null, null).open();
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.jdt.ui.sort_members_dialog_context");
        return contents;
    }

    protected Control createMessageArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite messageComposite = new Composite(parent, 0);
        messageComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        messageComposite.setLayout((Layout)layout);
        messageComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createLinkControl(messageComposite);
        int indent = this.convertWidthInCharsToPixels(3);
        this.fNotSortAllRadio.doFillIntoGrid(messageComposite, 1);
        LayoutUtil.setHorizontalIndent((Control)this.fNotSortAllRadio.getSelectionButton(null), indent);
        this.fSortAllRadio.doFillIntoGrid(messageComposite, 1);
        LayoutUtil.setHorizontalIndent((Control)this.fSortAllRadio.getSelectionButton(null), indent);
        Composite warningComposite = new Composite(messageComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        warningComposite.setLayout((Layout)layout);
        warningComposite.setLayoutData((Object)new GridData(4, 2, true, false));
        warningComposite.setFont(messageComposite.getFont());
        Image image = Dialog.getImage((String)"dialog_messasge_warning_image");
        final Label imageLabel1 = new Label(warningComposite, 16448);
        imageLabel1.setImage(image);
        imageLabel1.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        final Label label = new Label(warningComposite, 64);
        label.setText(DialogsMessages.SortMembersMessageDialog_sort_warning_label);
        GridData gridData = new GridData(4, 2, true, false, 1, 1);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)gridData);
        label.setFont(warningComposite.getFont());
        this.fNotSortAllRadio.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                imageLabel1.setEnabled(!SortMembersMessageDialog.this.fNotSortAllRadio.isSelected());
                label.setEnabled(!SortMembersMessageDialog.this.fNotSortAllRadio.isSelected());
            }
        });
        imageLabel1.setEnabled(!this.fNotSortAllRadio.isSelected());
        label.setEnabled(!this.fNotSortAllRadio.isSelected());
        return messageComposite;
    }

    public int open() {
        if (SortMembersMessageDialog.isDialogEnabled(OPTIONAL_ID)) {
            return super.open();
        }
        return 0;
    }

    public boolean close() {
        this.fDialogSettings.put(DIALOG_SETTINGS_SORT_ALL, this.fSortAllRadio.isSelected());
        return super.close();
    }

    public boolean isNotSortingFieldsEnabled() {
        return this.fNotSortAllRadio.isSelected();
    }
}

