/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.core.text;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.search.internal.ui.SearchMessages;

public class PatternConstructor {
    private PatternConstructor() {
    }

    public static Pattern createPattern(String pattern, boolean isCaseSensitive, boolean isRegex) throws PatternSyntaxException {
        return PatternConstructor.createPattern(pattern, isRegex, true, isCaseSensitive, false);
    }

    public static Pattern createPattern(String pattern, boolean isRegex, boolean isStringMatcher, boolean isCaseSensitive, boolean isWholeWord) throws PatternSyntaxException {
        if (isRegex) {
            pattern = PatternConstructor.substituteLinebreak(pattern);
            if (isWholeWord) {
                StringBuffer buffer = new StringBuffer(pattern.length() + 10);
                buffer.append("\\b(?:").append(pattern).append(")\\b");
                pattern = buffer.toString();
            }
        } else {
            int len = pattern.length();
            StringBuffer buffer = new StringBuffer(len + 10);
            if (isWholeWord && len > 0 && PatternConstructor.isWordChar(pattern.charAt(0))) {
                buffer.append("\\b");
            }
            PatternConstructor.appendAsRegEx(isStringMatcher, pattern, buffer);
            if (isWholeWord && len > 0 && PatternConstructor.isWordChar(pattern.charAt(len - 1))) {
                buffer.append("\\b");
            }
            pattern = buffer.toString();
        }
        int regexOptions = 8;
        if (!isCaseSensitive) {
            regexOptions |= 0x42;
        }
        return Pattern.compile(pattern, regexOptions);
    }

    private static String substituteLinebreak(String findString) throws PatternSyntaxException {
        int length = findString.length();
        StringBuffer buf = new StringBuffer(length);
        int inCharGroup = 0;
        int inBraces = 0;
        boolean inQuote = false;
        int i = 0;
        while (i < length) {
            char ch = findString.charAt(i);
            switch (ch) {
                case '[': {
                    buf.append(ch);
                    if (inQuote) break;
                    ++inCharGroup;
                    break;
                }
                case ']': {
                    buf.append(ch);
                    if (inQuote) break;
                    --inCharGroup;
                    break;
                }
                case '{': {
                    buf.append(ch);
                    if (inQuote || inCharGroup != 0) break;
                    ++inBraces;
                    break;
                }
                case '}': {
                    buf.append(ch);
                    if (inQuote || inCharGroup != 0) break;
                    --inBraces;
                    break;
                }
                case '\\': {
                    if (i + 1 < length) {
                        char ch1 = findString.charAt(i + 1);
                        if (inQuote) {
                            if (ch1 == 'E') {
                                inQuote = false;
                            }
                            buf.append(ch).append(ch1);
                            ++i;
                            break;
                        }
                        if (ch1 == 'R') {
                            if (inCharGroup > 0 || inBraces > 0) {
                                String msg = SearchMessages.PatternConstructor_error_line_delim_position;
                                throw new PatternSyntaxException(msg, findString, i);
                            }
                            buf.append("(?>\\r\\n?|\\n)");
                            ++i;
                            break;
                        }
                        if (ch1 == 'Q') {
                            inQuote = true;
                        }
                        buf.append(ch).append(ch1);
                        ++i;
                        break;
                    }
                    buf.append(ch);
                    break;
                }
                default: {
                    buf.append(ch);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    private static boolean isWordChar(char c) {
        return Character.isLetterOrDigit(c);
    }

    public static Pattern createPattern(String[] patterns, boolean isCaseSensitive) throws PatternSyntaxException {
        StringBuffer pattern = new StringBuffer();
        int i = 0;
        while (i < patterns.length) {
            if (i > 0) {
                pattern.append('|');
            }
            PatternConstructor.appendAsRegEx(true, patterns[i], pattern);
            ++i;
        }
        return PatternConstructor.createPattern(pattern.toString(), true, true, isCaseSensitive, false);
    }

    public static StringBuffer appendAsRegEx(boolean isStringMatcher, String pattern, StringBuffer buffer) {
        boolean isEscaped = false;
        int i = 0;
        while (i < pattern.length()) {
            char c = pattern.charAt(i);
            switch (c) {
                case '\\': {
                    if (isStringMatcher && !isEscaped) {
                        isEscaped = true;
                        break;
                    }
                    buffer.append("\\\\");
                    isEscaped = false;
                    break;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '[': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    if (isEscaped) {
                        buffer.append("\\\\");
                        isEscaped = false;
                    }
                    buffer.append('\\');
                    buffer.append(c);
                    break;
                }
                case '?': {
                    if (isStringMatcher && !isEscaped) {
                        buffer.append('.');
                        break;
                    }
                    buffer.append('\\');
                    buffer.append(c);
                    isEscaped = false;
                    break;
                }
                case '*': {
                    if (isStringMatcher && !isEscaped) {
                        buffer.append(".*");
                        break;
                    }
                    buffer.append('\\');
                    buffer.append(c);
                    isEscaped = false;
                    break;
                }
                default: {
                    if (isEscaped) {
                        buffer.append("\\\\");
                        isEscaped = false;
                    }
                    buffer.append(c);
                }
            }
            ++i;
        }
        if (isEscaped) {
            buffer.append("\\\\");
            isEscaped = false;
        }
        return buffer;
    }

    public static String interpretReplaceEscapes(String replaceText, String foundText, String lineDelim) {
        return new ReplaceStringConstructor(lineDelim).interpretReplaceEscapes(replaceText, foundText);
    }

    private static class ReplaceStringConstructor {
        private static final int RC_MIXED = 0;
        private static final int RC_UPPER = 1;
        private static final int RC_LOWER = 2;
        private static final int RC_FIRSTUPPER = 3;
        private int fRetainCaseMode;
        private final String fLineDelim;

        public ReplaceStringConstructor(String lineDelim) {
            this.fLineDelim = lineDelim;
        }

        private String interpretReplaceEscapes(String replaceText, String foundText) {
            int length = replaceText.length();
            boolean inEscape = false;
            StringBuffer buf = new StringBuffer(length);
            this.fRetainCaseMode = 0;
            int i = 0;
            while (i < length) {
                char ch = replaceText.charAt(i);
                if (inEscape) {
                    i = this.interpretReplaceEscape(ch, i, buf, replaceText, foundText);
                    inEscape = false;
                } else if (ch == '\\') {
                    inEscape = true;
                } else if (ch == '$') {
                    buf.append(ch);
                    if (i + 2 < length) {
                        char ch1 = replaceText.charAt(i + 1);
                        char ch2 = replaceText.charAt(i + 2);
                        if (ch1 == '0' && '0' <= ch2 && ch2 <= '9') {
                            buf.append("0\\");
                            ++i;
                        }
                    }
                } else {
                    this.interpretRetainCase(buf, ch);
                }
                ++i;
            }
            if (inEscape) {
                buf.append('\\');
            }
            return buf.toString();
        }

        private int interpretReplaceEscape(char ch, int i, StringBuffer buf, String replaceText, String foundText) {
            int length = replaceText.length();
            switch (ch) {
                case 'r': {
                    buf.append('\r');
                    break;
                }
                case 'n': {
                    buf.append('\n');
                    break;
                }
                case 't': {
                    buf.append('\t');
                    break;
                }
                case 'f': {
                    buf.append('\f');
                    break;
                }
                case 'a': {
                    buf.append('\u0007');
                    break;
                }
                case 'e': {
                    buf.append('\u001b');
                    break;
                }
                case 'R': {
                    buf.append(this.fLineDelim);
                    break;
                }
                case '0': {
                    char ch1;
                    buf.append('$').append(ch);
                    if (i + 1 >= length || '0' > (ch1 = replaceText.charAt(i + 1)) || ch1 > '9') break;
                    buf.append('\\');
                    break;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    buf.append('$').append(ch);
                    break;
                }
                case 'c': {
                    if (i + 1 < length) {
                        char ch1 = replaceText.charAt(i + 1);
                        this.interpretRetainCase(buf, (char)(ch1 ^ 0x40));
                        ++i;
                        break;
                    }
                    String msg = SearchMessages.PatternConstructor_error_escape_sequence;
                    throw new PatternSyntaxException(msg, replaceText, i);
                }
                case 'x': {
                    if (i + 2 < length) {
                        int parsedInt;
                        try {
                            parsedInt = Integer.parseInt(replaceText.substring(i + 1, i + 3), 16);
                            if (parsedInt < 0) {
                                throw new NumberFormatException();
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            String msg = SearchMessages.PatternConstructor_error_hex_escape_sequence;
                            throw new PatternSyntaxException(msg, replaceText, i);
                        }
                        this.interpretRetainCase(buf, (char)parsedInt);
                        i += 2;
                        break;
                    }
                    String msg = SearchMessages.PatternConstructor_error_hex_escape_sequence;
                    throw new PatternSyntaxException(msg, replaceText, i);
                }
                case 'u': {
                    if (i + 4 < length) {
                        int parsedInt;
                        try {
                            parsedInt = Integer.parseInt(replaceText.substring(i + 1, i + 5), 16);
                            if (parsedInt < 0) {
                                throw new NumberFormatException();
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            String msg = SearchMessages.PatternConstructor_error_unicode_escape_sequence;
                            throw new PatternSyntaxException(msg, replaceText, i);
                        }
                        this.interpretRetainCase(buf, (char)parsedInt);
                        i += 4;
                        break;
                    }
                    String msg = SearchMessages.PatternConstructor_error_unicode_escape_sequence;
                    throw new PatternSyntaxException(msg, replaceText, i);
                }
                case 'C': {
                    if (foundText.toUpperCase().equals(foundText)) {
                        this.fRetainCaseMode = 1;
                        break;
                    }
                    if (foundText.toLowerCase().equals(foundText)) {
                        this.fRetainCaseMode = 2;
                        break;
                    }
                    if (Character.isUpperCase(foundText.charAt(0))) {
                        this.fRetainCaseMode = 3;
                        break;
                    }
                    this.fRetainCaseMode = 0;
                    break;
                }
                default: {
                    buf.append('\\').append(ch);
                }
            }
            return i;
        }

        private void interpretRetainCase(StringBuffer buf, char ch) {
            if (this.fRetainCaseMode == 1) {
                buf.append(Character.toUpperCase(ch));
            } else if (this.fRetainCaseMode == 2) {
                buf.append(Character.toLowerCase(ch));
            } else if (this.fRetainCaseMode == 3) {
                buf.append(Character.toUpperCase(ch));
                this.fRetainCaseMode = 0;
            } else {
                buf.append(ch);
            }
        }
    }
}

