/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmMultiTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.util.AbstractTypeReferenceVisitor;
import org.eclipse.xtext.common.types.util.TypeReferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class Primitives {
    @Inject
    private TypeReferences typeReferences;

    public Primitive primitiveKind(JvmPrimitiveType primitiveType) {
        String name = primitiveType.getIdentifier();
        if (Boolean.TYPE.getName().equals(name)) {
            return Primitive.Boolean;
        }
        if (Integer.TYPE.getName().equals(name)) {
            return Primitive.Int;
        }
        if (Byte.TYPE.getName().equals(name)) {
            return Primitive.Byte;
        }
        if (Short.TYPE.getName().equals(name)) {
            return Primitive.Short;
        }
        if (Character.TYPE.getName().equals(name)) {
            return Primitive.Char;
        }
        if (Long.TYPE.getName().equals(name)) {
            return Primitive.Long;
        }
        if (Float.TYPE.getName().equals(name)) {
            return Primitive.Float;
        }
        if (Double.TYPE.getName().equals(name)) {
            return Primitive.Double;
        }
        if (Void.TYPE.getName().equals(name)) {
            return Primitive.Void;
        }
        throw new IllegalArgumentException("Unkown primitive " + name);
    }

    public JvmTypeReference asWrapperTypeIfPrimitive(JvmTypeReference primitive) {
        if (primitive == null || !this.isPrimitive(primitive)) {
            return primitive;
        }
        JvmType wrapperType = this.getWrapperType((JvmPrimitiveType)primitive.getType());
        if (wrapperType == null) {
            return primitive;
        }
        return this.typeReferences.createTypeRef(wrapperType, new JvmTypeReference[0]);
    }

    public JvmType getWrapperType(JvmPrimitiveType primitive) {
        switch (this.primitiveKind(primitive)) {
            case Byte: {
                return this.getType(Byte.class, (Notifier)primitive);
            }
            case Short: {
                return this.getType(Short.class, (Notifier)primitive);
            }
            case Char: {
                return this.getType(Character.class, (Notifier)primitive);
            }
            case Int: {
                return this.getType(Integer.class, (Notifier)primitive);
            }
            case Long: {
                return this.getType(Long.class, (Notifier)primitive);
            }
            case Float: {
                return this.getType(Float.class, (Notifier)primitive);
            }
            case Double: {
                return this.getType(Double.class, (Notifier)primitive);
            }
            case Boolean: {
                return this.getType(Boolean.class, (Notifier)primitive);
            }
            case Void: {
                return this.getType(Void.class, (Notifier)primitive);
            }
        }
        throw new IllegalArgumentException("Not a primitive : " + primitive);
    }

    protected JvmType getType(Class<?> class1, Notifier context) {
        return this.typeReferences.findDeclaredType(class1, context);
    }

    public boolean isPrimitive(JvmTypeReference type) {
        return type != null && type.getType() instanceof JvmPrimitiveType && !type.getType().eIsProxy();
    }

    public boolean isWrapperType(JvmTypeReference type) {
        JvmTypeReference result = this.asPrimitiveIfWrapperType(type);
        return result != type && result != null;
    }

    public JvmTypeReference asPrimitiveIfWrapperType(JvmTypeReference type) {
        return (JvmTypeReference)new AbstractTypeReferenceVisitor.InheritanceAware<JvmTypeReference>(){

            @Override
            public JvmTypeReference doVisitMultiTypeReference(JvmMultiTypeReference reference) {
                for (JvmTypeReference ref : reference.getReferences()) {
                    JvmTypeReference refAsPrimitiveIfWrapper = (JvmTypeReference)this.visit(ref);
                    if (refAsPrimitiveIfWrapper == ref) continue;
                    return refAsPrimitiveIfWrapper;
                }
                return reference;
            }

            @Override
            public JvmTypeReference doVisitParameterizedTypeReference(JvmParameterizedTypeReference type) {
                if (type.getType() instanceof JvmTypeParameter) {
                    EList constraints = ((JvmTypeParameter)type.getType()).getConstraints();
                    for (JvmUpperBound upperBound : Iterables.filter((Iterable)constraints, JvmUpperBound.class)) {
                        JvmTypeReference upperBoundType = upperBound.getTypeReference();
                        JvmTypeReference asPrimitive = (JvmTypeReference)this.visit(upperBoundType);
                        if (asPrimitive == upperBoundType) continue;
                        return asPrimitive;
                    }
                    return type;
                }
                if (Primitives.this.typeReferences.is(type, Byte.class)) {
                    return Primitives.this.typeReferences.getTypeForName(Byte.TYPE, (Notifier)type.getType(), new JvmTypeReference[0]);
                }
                if (Primitives.this.typeReferences.is(type, Short.class)) {
                    return Primitives.this.typeReferences.getTypeForName(Short.TYPE, (Notifier)type.getType(), new JvmTypeReference[0]);
                }
                if (Primitives.this.typeReferences.is(type, Character.class)) {
                    return Primitives.this.typeReferences.getTypeForName(Character.TYPE, (Notifier)type.getType(), new JvmTypeReference[0]);
                }
                if (Primitives.this.typeReferences.is(type, Integer.class)) {
                    return Primitives.this.typeReferences.getTypeForName(Integer.TYPE, (Notifier)type.getType(), new JvmTypeReference[0]);
                }
                if (Primitives.this.typeReferences.is(type, Long.class)) {
                    return Primitives.this.typeReferences.getTypeForName(Long.TYPE, (Notifier)type.getType(), new JvmTypeReference[0]);
                }
                if (Primitives.this.typeReferences.is(type, Float.class)) {
                    return Primitives.this.typeReferences.getTypeForName(Float.TYPE, (Notifier)type.getType(), new JvmTypeReference[0]);
                }
                if (Primitives.this.typeReferences.is(type, Double.class)) {
                    return Primitives.this.typeReferences.getTypeForName(Double.TYPE, (Notifier)type.getType(), new JvmTypeReference[0]);
                }
                if (Primitives.this.typeReferences.is(type, Boolean.class)) {
                    return Primitives.this.typeReferences.getTypeForName(Boolean.TYPE, (Notifier)type.getType(), new JvmTypeReference[0]);
                }
                if (Primitives.this.typeReferences.is(type, Void.class)) {
                    return Primitives.this.typeReferences.getTypeForName(Void.TYPE, (Notifier)type.getType(), new JvmTypeReference[0]);
                }
                return type;
            }

            @Override
            public JvmTypeReference doVisitTypeReference(JvmTypeReference reference) {
                return reference;
            }

            @Override
            protected JvmTypeReference handleNullReference() {
                return null;
            }
        }.visit(type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Primitive {
        Byte,
        Short,
        Char,
        Int,
        Long,
        Float,
        Double,
        Void,
        Boolean;

    }
}

