/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit4.runner;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.Test;
import org.eclipse.jdt.internal.junit.runner.ITestLoader;
import org.eclipse.jdt.internal.junit.runner.ITestReference;
import org.eclipse.jdt.internal.junit.runner.RemoteTestRunner;
import org.eclipse.jdt.internal.junit.runner.junit3.JUnit3TestLoader;
import org.eclipse.jdt.internal.junit.runner.junit3.JUnit3TestReference;
import org.eclipse.jdt.internal.junit4.runner.JUnit4TestClassReference;
import org.eclipse.jdt.internal.junit4.runner.JUnit4TestMethodReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnit4TestLoader
implements ITestLoader {
    public ITestReference[] loadTests(Class[] testClasses, String testName, String[] failureNames, RemoteTestRunner listener) {
        ITestReference[] refs = new ITestReference[testClasses.length];
        int i = 0;
        while (i < testClasses.length) {
            ITestReference ref;
            Class clazz = testClasses[i];
            refs[i] = ref = this.createTest(clazz, testName, failureNames, listener);
            ++i;
        }
        return refs;
    }

    private ITestReference createTest(Class<?> clazz, String testName, String[] failureNames, RemoteTestRunner listener) {
        if (clazz == null) {
            return null;
        }
        if (testName == null) {
            return new JUnit4TestClassReference(clazz, failureNames);
        }
        if (this.isJUnit3SetUpTest(clazz, testName)) {
            JUnit3TestLoader jUnit3TestLoader = new JUnit3TestLoader();
            Test test = jUnit3TestLoader.getTest(clazz, testName, listener);
            return new JUnit3TestReference(test);
        }
        return new JUnit4TestMethodReference(clazz, testName, failureNames);
    }

    private boolean isJUnit3SetUpTest(Class<?> clazz, String testName) {
        block6: {
            if (!Test.class.isAssignableFrom(clazz)) {
                return false;
            }
            Method testMethod = clazz.getMethod(testName, new Class[0]);
            if (testMethod.getAnnotation(org.junit.Test.class) == null) break block6;
            return false;
        }
        try {
            Method setup = clazz.getMethod("setUpTest", Test.class);
            int modifiers = setup.getModifiers();
            if (setup.getReturnType() == Test.class && Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers)) {
                return true;
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return false;
    }
}

