/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.trigger.Trigger;
import org.eclipse.stem.core.trigger.TriggerFactory;
import org.eclipse.stem.ui.wizards.DublinCorePage;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.stem.ui.wizards.NewIdentifiablePage;
import org.eclipse.stem.ui.wizards.NewIdentifiableWizard;
import org.eclipse.stem.ui.wizards.STEMWizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewTriggerWizard
extends NewIdentifiableWizard {
    @Override
    protected String getWizardTitle() {
        return Messages.getString("NTriggerWiz.wizard_title");
    }

    @Override
    protected NewIdentifiablePage createNewIdentifiablePage() {
        this.setHelpContextId("org.eclipse.stem.doc.newtrigger_contextid");
        return new NewTriggerPage();
    }

    @Override
    protected DublinCorePage createDublinCorePage() {
        return new DublinCorePage(){

            @Override
            protected void initializeDCAttributes() {
                super.initializeDCAttributes();
                this.format.setText("http:///org/eclipse/stem/core/trigger.ecore");
                this.format.setEnabled(false);
                this.type.setText(STEMURI.TRIGGER_TYPE_URI.toString());
                this.type.setEnabled(false);
                this.titleTextField.setText(Messages.getString("dc_title_trig"));
                this.source.setText(Messages.getString("dc_source_trig"));
                this.descriptionTextField.setText(Messages.getString("dc_desc_trig"));
            }
        };
    }

    @Override
    protected Identifiable createIdentifiable() {
        Trigger retValue = TriggerFactory.eINSTANCE.createTrigger();
        retValue.setDublinCore(this.newDublinCorePage.createDublinCore());
        return retValue;
    }

    @Override
    protected String getSerializationFolderName() {
        return "triggers";
    }

    @Override
    protected String getSerializationFileNameExtension() {
        return "trigger";
    }

    protected static class NewTriggerPage
    extends NewIdentifiablePage {
        protected NewTriggerPage() {
            super(Messages.getString("NTriggerWiz.page_title"));
            this.setTitle(Messages.getString("NTriggerWiz.page_title"));
            this.setDescription(Messages.getString("NTriggerWiz.page_description"));
        }

        @Override
        protected Composite createSpecificComposite(Composite parent) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.stem.doc.newtrigger_contextid");
            return new Composite(parent, 0);
        }
    }

    public static class NewTriggerWizardCommandHandler
    extends AbstractHandler
    implements IHandler {
        public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
            NewTriggerWizard wizard = new NewTriggerWizard();
            wizard.init(window.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
            STEMWizardDialog wizardDialog = new STEMWizardDialog(window.getShell(), (IWizard)wizard);
            wizardDialog.open();
            return null;
        }
    }
}

