/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stem.jobs.batch.BatchManager;
import org.eclipse.stem.jobs.batch.BatchManagerEvent;
import org.eclipse.stem.jobs.batch.IBatch;
import org.eclipse.stem.jobs.batch.IBatchManagerListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public class ActiveBatchesView
extends ViewPart {
    public static final String ID_ACTIVE_BATCHES_VIEW = "org.eclipse.stem.ui.views.activebatches";
    private ListViewer lv = null;

    public void createPartControl(Composite parent) {
        this.lv = new ListViewer(parent);
        this.lv.setContentProvider((IContentProvider)new ActiveBatchesContentProvider());
        this.lv.setLabelProvider((IBaseLabelProvider)new ActiveBatchesLabelProvider());
        this.lv.setInput((Object)BatchManager.INSTANCE);
        this.getSite().setSelectionProvider((ISelectionProvider)this.lv);
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        this.getSite().setSelectionProvider(null);
        this.lv = null;
    }

    protected static class ActiveBatchesContentProvider
    implements IStructuredContentProvider,
    IBatchManagerListener {
        private ListViewer viewer = null;
        private BatchManager batchManager = null;

        protected ActiveBatchesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((BatchManager)inputElement).getActiveBatches().toArray();
        }

        public void dispose() {
            this.viewer = null;
            this.batchManager = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.viewer = (ListViewer)viewer;
            if (this.batchManager != null) {
                this.batchManager.removeListener((IBatchManagerListener)this);
            }
            this.batchManager = (BatchManager)newInput;
            if (this.batchManager != null) {
                this.batchManager.addBatchManagerListener((IBatchManagerListener)this);
            }
        }

        public void batchesChanged(BatchManagerEvent event) {
            this.viewer.getList().setRedraw(false);
            try {
                this.viewer.remove((Object[])event.getBatchesRemoved());
                this.viewer.add((Object[])event.getBatchesAdded());
            }
            finally {
                this.viewer.getList().setRedraw(true);
            }
        }
    }

    protected static class ActiveBatchesLabelProvider
    implements ILabelProvider {
        protected ActiveBatchesLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            IBatch batch = (IBatch)element;
            return batch.getNameWithSequenceNumber();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

