/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.graphsynchronizer.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.GraphFactory;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.definitions.labels.RelativePhysicalRelationshipLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.graphsynchronizer.Activator;
import org.eclipse.stem.graphsynchronizer.Messenger;
import org.eclipse.stem.graphsynchronizer.MessengerException;
import org.eclipse.stem.graphsynchronizer.SynchGraphPartitioner;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListenerSync;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.jobs.simulation.SimulationManager;
import org.eclipse.stem.jobs.simulation.SimulationState;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabel;

public class SimulationGraphSynchronizer
implements ISimulationListenerSync {
    public static final long RETRY_WAIT = 1000L;
    public static final int MAX_SEND_RETRIES = 60;
    private static final Map<String, Object> EMF_SERIALIZATION_OPTIONS = new HashMap<String, Object>();
    public static Messenger messenger;
    private static Graph[] mySharedGraphs;
    private static Graph[] remoteSharedGraphs;
    public static boolean BINARYSERIALIZATION;
    public static boolean ZIPMESSAGES;
    private long totalSendTime = 0L;
    private long totalRecvTime = 0L;
    private long totalTime = 0L;
    private ISimulation simulation;
    boolean busy = false;
    int cycle = 0;

    static {
        EMF_SERIALIZATION_OPTIONS.put("ZIP", Boolean.FALSE);
    }

    public SimulationGraphSynchronizer(ISimulation sim) {
        this.simulation = sim;
        SynchGraphPartitioner sgp = (SynchGraphPartitioner)SimulationManager.getManager().getGraphPartitioner();
        mySharedGraphs = new Graph[sgp.getNumNodes() - 1];
        remoteSharedGraphs = new Graph[sgp.getNumNodes() - 1];
        if (ZIPMESSAGES) {
            EMF_SERIALIZATION_OPTIONS.put("ZIP", Boolean.TRUE);
        } else {
            EMF_SERIALIZATION_OPTIONS.put("ZIP", Boolean.FALSE);
        }
        if (!BINARYSERIALIZATION) {
            EMF_SERIALIZATION_OPTIONS.put("ENCODING", "UTF-8");
        }
    }

    public void simulationChangedSync(SimulationEvent event) {
        ((SynchGraphPartitioner)SimulationManager.getManager().getGraphPartitioner()).initialize(this.getSimulation());
        event.getSimulationState().equals((Object)SimulationState.RUNNING);
        if (event.getSimulationState().equals((Object)SimulationState.COMPLETED_CYCLE)) {
            if (this.cycle == 1) {
                this.totalTime = System.currentTimeMillis();
                this.totalSendTime = 0L;
                this.totalRecvTime = 0L;
            }
            ++this.cycle;
            if (((SynchGraphPartitioner)SimulationManager.getManager().getGraphPartitioner()).getNumNodes() == 1) {
                return;
            }
            if (this.busy) {
                Activator.logError("Error received re-entrant callback in graph synchronizer", new Exception());
                this.busy = false;
                return;
            }
            this.busy = true;
            EList el = this.simulation.getScenario().getCanonicalGraph().getDecorators();
            BasicEList idecorators = new BasicEList();
            for (Decorator d : el) {
                if (!(d instanceof IntegrationDecorator)) continue;
                idecorators.add((Object)d);
            }
            if (mySharedGraphs[0] == null) {
                this.initSharedGraph((EList<Decorator>)idecorators);
            }
            Graph[] graphArray = mySharedGraphs;
            int n = mySharedGraphs.length;
            int n2 = 0;
            while (n2 < n) {
                Graph graph = graphArray[n2];
                for (Map.Entry entry : graph.getNodeLabels().entrySet()) {
                    URI uri = (URI)entry.getKey();
                    NodeLabel latestVal = (NodeLabel)this.simulation.getScenario().getCanonicalGraph().getNodeLabels().get((Object)uri);
                    if (latestVal == null) {
                        Activator.logError("Cannot find node label with URI " + uri, new Exception());
                        continue;
                    }
                    ((IntegrationLabelValue)((NodeLabel)entry.getValue()).getCurrentValue()).set((IntegrationLabelValue)latestVal.getCurrentValue());
                }
                ++n2;
            }
            long now = System.currentTimeMillis();
            int n3 = 0;
            while (n3 < mySharedGraphs.length) {
                this.sendGraph(mySharedGraphs[n3], n3);
                ++n3;
            }
            long then = System.currentTimeMillis();
            this.totalSendTime += then - now;
            now = System.currentTimeMillis();
            int n4 = 0;
            while (n4 < mySharedGraphs.length) {
                SimulationGraphSynchronizer.remoteSharedGraphs[n4] = this.receiveGraph(n4);
                ++n4;
            }
            then = System.currentTimeMillis();
            this.totalRecvTime += then - now;
            Graph[] graphArray2 = remoteSharedGraphs;
            int n5 = remoteSharedGraphs.length;
            int n6 = 0;
            while (n6 < n5) {
                Graph graph = graphArray2[n6];
                if (graph != null) {
                    for (Map.Entry entry : graph.getNodeLabels().entrySet()) {
                        URI uri = (URI)entry.getKey();
                        NodeLabel latestVal = (NodeLabel)this.simulation.getScenario().getCanonicalGraph().getNodeLabels().get((Object)uri);
                        if (latestVal == null) {
                            Activator.logError("Cannot find node label with URI " + uri, new Exception());
                            continue;
                        }
                        ((IntegrationLabelValue)latestVal.getCurrentValue()).set((IntegrationLabelValue)((NodeLabel)entry.getValue()).getCurrentValue());
                        ((IntegrationLabel)latestVal).getTempValue().set((IntegrationLabelValue)((NodeLabel)entry.getValue()).getCurrentValue());
                    }
                    ++n6;
                    continue;
                }
                break;
            }
        } else if (event.getSimulationState().equals((Object)SimulationState.STOPPED)) {
            try {
                messenger.wakeupBlockedRecv();
            }
            catch (MessengerException me) {
                Activator.logError("Cannot wake up blocked recv", me);
            }
        } else if (event.getSimulationState().equals((Object)SimulationState.PAUSED)) {
            this.totalTime = System.currentTimeMillis() - this.totalTime;
            Activator.logInformation("Total send time:" + this.totalSendTime);
            Activator.logInformation("Total recv time:" + this.totalRecvTime);
            Activator.logInformation("Total simulation time:" + this.totalTime);
        }
        this.busy = false;
    }

    public ISimulation getSimulation() {
        return this.simulation;
    }

    private void initSharedGraph(EList<Decorator> idecorators) {
        SynchGraphPartitioner gp = (SynchGraphPartitioner)SimulationManager.getManager().getGraphPartitioner();
        int i = 0;
        while (i < gp.getNumNodes() - 1) {
            SimulationGraphSynchronizer.mySharedGraphs[i] = GraphFactory.eINSTANCE.createGraph();
            mySharedGraphs[i].setDublinCore(null);
            mySharedGraphs[i].setTime(null);
            mySharedGraphs[i].setURI(null);
            mySharedGraphs[i].setTypeURI(null);
            ++i;
        }
        for (Decorator d : idecorators) {
            EList myLabels = gp.partitionDecoratorLabels(d);
            for (DynamicLabel dl : myLabels) {
                if (!(dl.getIdentifiable() instanceof Node)) continue;
                Node n = (Node)dl.getIdentifiable();
                EList edges = n.getEdges();
                for (Edge e : edges) {
                    if (e.getLabel() instanceof RelativePhysicalRelationshipLabel) continue;
                    Node otherNode = null;
                    if (gp.getNodeRank() != gp.getIdentifiableRank((Identifiable)e.getB())) {
                        otherNode = e.getB();
                    }
                    if (gp.getNodeRank() != gp.getIdentifiableRank((Identifiable)e.getA())) {
                        otherNode = e.getA();
                    }
                    if (otherNode == null) continue;
                    int otherRank = gp.getIdentifiableRank((Identifiable)otherNode);
                    DynamicLabel cloneLabel = (DynamicLabel)EcoreUtil.copy((EObject)dl);
                    ((Node)cloneLabel.getIdentifiable()).getLabels().remove((Object)cloneLabel);
                    if (cloneLabel instanceof IntegrationLabel) {
                        cloneLabel.setDublinCore(null);
                        ((IntegrationLabel)cloneLabel).setDeltaValue(null);
                        ((IntegrationLabel)cloneLabel).setTempValue(null);
                        ((IntegrationLabel)cloneLabel).setProbeValue(null);
                        ((IntegrationLabel)cloneLabel).setErrorScale(null);
                        ((IntegrationLabel)cloneLabel).setNextValue(null);
                        cloneLabel.setDecorator(null);
                        cloneLabel.setIdentifiable(null);
                        cloneLabel.setTypeURI(null);
                        cloneLabel.setURIOfIdentifiableToBeLabeled(null);
                        if (cloneLabel instanceof StandardPopulationModelLabel) {
                            ((StandardPopulationModelLabel)cloneLabel).setPopulationIdentifier(null);
                            ((StandardPopulationModelLabel)cloneLabel).setPopulationLabel(null);
                        }
                        if (cloneLabel instanceof DiseaseModelLabel) {
                            ((DiseaseModelLabel)cloneLabel).setPopulationModelLabel(null);
                            ((DiseaseModelLabel)cloneLabel).setPopulationLabel(null);
                        }
                    }
                    int index = otherRank >= mySharedGraphs.length ? otherRank - 1 : otherRank;
                    mySharedGraphs[index].getNodeLabels().put((Object)cloneLabel.getURI(), (Object)((NodeLabel)cloneLabel));
                }
            }
        }
        i = 0;
        while (i < gp.getNumNodes() - 1) {
            Activator.logInformation("Shared graph " + i + " is size " + mySharedGraphs[i].getNodeLabels().keySet().size());
            ++i;
        }
    }

    private void sendGraph(Graph g, int nodeRank) {
        try {
            URI tmpFileURI = URI.createURI((String)"platform:/tmp.xmi");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Utility.serializeIdentifiableToStream((Identifiable)g, (URI)tmpFileURI, (OutputStream)baos, EMF_SERIALIZATION_OPTIONS, (boolean)BINARYSERIALIZATION);
            int retries = 0;
            while (true) {
                try {
                    messenger.sendMsg(baos.toByteArray(), nodeRank);
                }
                catch (MessengerException messengerException) {
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (retries++ < 60) continue;
                }
                break;
            }
            if (retries >= 60) {
                throw new MessengerException("Unable to send message to node " + nodeRank + ", retried " + 60 + " times", new Exception());
            }
        }
        catch (MessengerException me) {
            Activator.logError("Exception caught sending message to node " + nodeRank, me);
        }
        catch (IOException io) {
            Activator.logError("Exception caught seralizing message", io);
        }
    }

    private Graph receiveGraph(int nodeRank) {
        byte[] xmi = null;
        try {
            xmi = messenger.recvMsg(nodeRank);
        }
        catch (MessengerException me) {
            Activator.logError("Exception caught receiving data from node " + nodeRank, me);
            return null;
        }
        if (xmi == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(xmi);
        URI tmpFileURI = URI.createURI((String)"platform:/tmp.xmi");
        Graph g = (Graph)Utility.getIdentifiableFromStream((URI)tmpFileURI, (InputStream)bais, EMF_SERIALIZATION_OPTIONS, (boolean)BINARYSERIALIZATION);
        if (g == null) {
            Activator.logError("Recieved null graph from " + nodeRank, new Exception());
        }
        return g;
    }
}

