/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.viewsupport.HistoryListAction;
import org.eclipse.jdt.internal.ui.viewsupport.ViewHistory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HistoryDropDownAction<E>
extends Action {
    public static final int RESULTS_IN_DROP_DOWN = 10;
    private ViewHistory<E> fHistory;
    private Menu fMenu;

    public HistoryDropDownAction(ViewHistory<E> history) {
        this.fHistory = history;
        this.fMenu = null;
        this.setMenuCreator(new HistoryMenuCreator());
        this.fHistory.configureHistoryDropDownAction((IAction)this);
    }

    public void run() {
        new HistoryListAction<E>(this.fHistory).run();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HistoryAction
    extends Action {
        private final E fElement;

        public HistoryAction(E element, int accelerator) {
            super("", 8);
            Assert.isNotNull(element);
            this.fElement = element;
            String label = HistoryDropDownAction.this.fHistory.getText(element);
            if (accelerator < 10) {
                label = new StringBuffer().append('&').append(accelerator).append(' ').append(label).toString();
            }
            this.setText(label);
            this.setImageDescriptor(HistoryDropDownAction.this.fHistory.getImageDescriptor(element));
        }

        public void run() {
            if (this.isChecked()) {
                HistoryDropDownAction.this.fHistory.setActiveEntry(this.fElement);
            }
        }
    }

    private class HistoryMenuCreator
    implements IMenuCreator {
        private HistoryMenuCreator() {
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public Menu getMenu(Control parent) {
            if (HistoryDropDownAction.this.fMenu != null) {
                HistoryDropDownAction.this.fMenu.dispose();
            }
            final MenuManager manager = new MenuManager();
            manager.setRemoveAllWhenShown(true);
            manager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager2) {
                    List entries = HistoryDropDownAction.this.fHistory.getHistoryEntries();
                    boolean checkOthers = this.addEntryMenuItems(manager2, entries);
                    manager2.add((IContributionItem)new Separator());
                    HistoryListAction others = new HistoryListAction(HistoryDropDownAction.this.fHistory);
                    others.setChecked(checkOthers);
                    manager2.add(others);
                    Action clearAction = HistoryDropDownAction.this.fHistory.getClearAction();
                    if (clearAction != null) {
                        manager2.add((IAction)clearAction);
                    }
                    manager2.add((IContributionItem)new Separator("additions"));
                    HistoryDropDownAction.this.fHistory.addMenuEntries(manager);
                }

                private boolean addEntryMenuItems(IMenuManager manager2, List<E> entries) {
                    if (entries.isEmpty()) {
                        return false;
                    }
                    boolean checkOthers = true;
                    int min = Math.min(entries.size(), 10);
                    int i = 0;
                    while (i < min) {
                        Object entry = entries.get(i);
                        HistoryAction action = new HistoryAction(entry, i + 1);
                        boolean check = entry.equals(HistoryDropDownAction.this.fHistory.getCurrentEntry());
                        action.setChecked(check);
                        if (check) {
                            checkOthers = false;
                        }
                        manager2.add((IAction)action);
                        ++i;
                    }
                    return checkOthers;
                }
            });
            HistoryDropDownAction.this.fMenu = manager.createContextMenu(parent);
            final Display display = parent.getDisplay();
            HistoryDropDownAction.this.fMenu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuHidden(MenuEvent e) {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            manager.removeAll();
                            if (HistoryDropDownAction.this.fMenu != null) {
                                HistoryDropDownAction.this.fMenu.dispose();
                                HistoryDropDownAction.this.fMenu = null;
                            }
                        }
                    });
                }
            });
            return HistoryDropDownAction.this.fMenu;
        }

        public void dispose() {
            HistoryDropDownAction.this.fHistory = null;
            if (HistoryDropDownAction.this.fMenu != null) {
                HistoryDropDownAction.this.fMenu.dispose();
                HistoryDropDownAction.this.fMenu = null;
            }
        }
    }
}

