/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class JavaSearchEditorOpener {
    private IEditorReference fReusedEditor;

    public IEditorPart openElement(Object element) throws PartInitException {
        IWorkbenchPage wbPage = JavaPlugin.getActivePage();
        IEditorPart editor = NewSearchUI.reuseEditor() ? this.showWithReuse(element, wbPage) : this.showWithoutReuse(element);
        if (element instanceof IJavaElement) {
            EditorUtility.revealInEditor(editor, (IJavaElement)element);
        }
        return editor;
    }

    public IEditorPart openMatch(Match match) throws PartInitException {
        Object element = this.getElementToOpen(match);
        return this.openElement(element);
    }

    protected Object getElementToOpen(Match match) {
        return match.getElement();
    }

    private IEditorPart showWithoutReuse(Object element) throws PartInitException {
        try {
            return EditorUtility.openInEditor(element, false);
        }
        catch (PartInitException e) {
            if (e.getStatus().getCode() != 10008) {
                throw e;
            }
            return null;
        }
    }

    private IEditorPart showWithReuse(Object element, IWorkbenchPage wbPage) throws PartInitException {
        IEditorInput input = EditorUtility.getEditorInput(element);
        if (input == null) {
            return null;
        }
        String editorID = EditorUtility.getEditorID(input);
        return this.showInEditor(wbPage, input, editorID);
    }

    private IEditorPart showInEditor(IWorkbenchPage page, IEditorInput input, String editorId) {
        IEditorPart editor = page.findEditor(input);
        if (editor != null) {
            page.bringToTop((IWorkbenchPart)editor);
            return editor;
        }
        IEditorReference reusedEditorRef = this.fReusedEditor;
        if (reusedEditorRef != null) {
            boolean canBeReused;
            boolean isOpen = reusedEditorRef.getEditor(false) != null;
            boolean bl = canBeReused = isOpen && !reusedEditorRef.isDirty() && !reusedEditorRef.isPinned();
            if (canBeReused) {
                boolean showsSameInputType = reusedEditorRef.getId().equals(editorId);
                if (!showsSameInputType) {
                    page.closeEditors(new IEditorReference[]{reusedEditorRef}, false);
                    this.fReusedEditor = null;
                } else {
                    editor = reusedEditorRef.getEditor(true);
                    if (editor instanceof IReusableEditor) {
                        ((IReusableEditor)editor).setInput(input);
                        page.bringToTop((IWorkbenchPart)editor);
                        return editor;
                    }
                }
            }
        }
        try {
            IEditorReference reference;
            editor = page.openEditor(input, editorId, false);
            this.fReusedEditor = editor instanceof IReusableEditor ? (reference = (IEditorReference)page.getReference((IWorkbenchPart)editor)) : null;
            return editor;
        }
        catch (PartInitException partInitException) {
            MessageDialog.openError((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)SearchMessages.Search_Error_openEditor_title, (String)SearchMessages.Search_Error_openEditor_message);
            return null;
        }
    }
}

