/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.genmodel.presentation;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenAnnotation;
import org.eclipse.emf.codegen.ecore.genmodel.GenBase;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.presentation.GenModelEditor;
import org.eclipse.emf.codegen.ecore.genmodel.presentation.GeneratorUIUtil;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenModelEditPlugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.ui.action.ViewerFilterAction;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.CommandActionHandler;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class GenModelActionBarContributor
extends EditingDomainActionBarContributor
implements ISelectionChangedListener {
    protected IEditorPart activeEditorPart;
    protected ISelectionProvider selectionProvider;
    protected IAction showPropertiesViewAction = new Action(GenModelEditPlugin.INSTANCE.getString("_UI_ShowPropertiesView_menu_item")){

        public void run() {
            try {
                GenModelActionBarContributor.this.getPage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException exception) {
                GenModelEditPlugin.INSTANCE.log((Object)exception);
            }
        }
    };
    protected IAction refreshViewerAction = new Action(GenModelEditPlugin.INSTANCE.getString("_UI_RefreshViewer_menu_item")){

        public boolean isEnabled() {
            return GenModelActionBarContributor.this.activeEditorPart instanceof IViewerProvider;
        }

        public void run() {
            Viewer viewer;
            if (GenModelActionBarContributor.this.activeEditorPart instanceof IViewerProvider && (viewer = ((IViewerProvider)GenModelActionBarContributor.this.activeEditorPart).getViewer()) != null) {
                viewer.refresh();
            }
        }
    };
    protected IMenuManager generateMenuManager;
    protected IAction generateModelAction = new GenerateAction("org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", CodeGenEcorePlugin.INSTANCE.getString("_UI_ModelProject_name"), GenModelEditPlugin.INSTANCE.getString("_UI_GenerateModel_menu_item"));
    protected IAction generateEditAction = new GenerateAction("org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject", CodeGenEcorePlugin.INSTANCE.getString("_UI_EditProject_name"), GenModelEditPlugin.INSTANCE.getString("_UI_GenerateEdit_menu_item"));
    protected IAction generateEditorAction = new GenerateAction("org.eclipse.emf.codegen.ecore.genmodel.generator.EditorProject", CodeGenEcorePlugin.INSTANCE.getString("_UI_EditorProject_name"), GenModelEditPlugin.INSTANCE.getString("_UI_GenerateEditor_menu_item"));
    protected IAction generateTestsAction = new GenerateAction("org.eclipse.emf.codegen.ecore.genmodel.generator.TestsProject", CodeGenEcorePlugin.INSTANCE.getString("_UI_TestsProject_name"), GenModelEditPlugin.INSTANCE.getString("_UI_GenerateTests_menu_item"));
    protected IAction generateAllAction = new GenerateAction(new ProjectType[]{new ProjectType("org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", CodeGenEcorePlugin.INSTANCE.getString("_UI_ModelProject_name")), new ProjectType("org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject", CodeGenEcorePlugin.INSTANCE.getString("_UI_EditProject_name")), new ProjectType("org.eclipse.emf.codegen.ecore.genmodel.generator.EditorProject", CodeGenEcorePlugin.INSTANCE.getString("_UI_EditorProject_name")), new ProjectType("org.eclipse.emf.codegen.ecore.genmodel.generator.TestsProject", CodeGenEcorePlugin.INSTANCE.getString("_UI_TestsProject_name"))}, GenModelEditPlugin.INSTANCE.getString("_UI_GenerateAll_menu_item"));
    protected ViewerFilterAction showGenAnnotationsAction = new ViewerFilterAction(GenModelEditPlugin.INSTANCE.getString("_UI_ShowGenAnnotation_menu_item"), 2){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !(element instanceof GenAnnotation) || this.isChecked();
        }
    };
    protected CreateAction annotateAction = new CreateAction(GenModelEditPlugin.INSTANCE.getString("_UI_Annotate_menu_item"), GenModelEditPlugin.INSTANCE.getString("_UI_Annotate_text")){

        protected Command doCreateCommand(GenBase selectedObject) {
            return AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)selectedObject, (Object)GenModelPackage.Literals.GEN_BASE__GEN_ANNOTATIONS, (Object)selectedObject.getGenModel().createGenAnnotation());
        }
    };
    protected CreateAction addDetailAction = new CreateAction(GenModelEditPlugin.INSTANCE.getString("_UI_AddDetail_menu_item"), GenModelEditPlugin.INSTANCE.getString("_UI_AddDetail_text")){

        protected Command doCreateCommand(GenBase selectedObject) {
            return AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)selectedObject, (Object)GenModelPackage.Literals.GEN_ANNOTATION__DETAILS, (Object)EcoreUtil.create((EClass)EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY));
        }
    };
    protected OpenEObjectEditorAction openEcoreAction = new OpenEObjectEditorAction(GenModelEditPlugin.INSTANCE.getString("_UI_OpenEcore_menu_item")){

        protected EObject getEObject(Object element) {
            return element instanceof GenBase ? ((GenBase)element).getEcoreModelElement() : null;
        }
    };
    protected OpenEObjectEditorAction openGenModelAction = new OpenEObjectEditorAction(GenModelEditPlugin.INSTANCE.getString("_UI_OpenGenModel_menu_item")){

        protected EObject getEObject(Object element) {
            if (GenModelActionBarContributor.this.activeEditorPart instanceof IEditingDomainProvider && element instanceof EObject) {
                EObject eObject = (EObject)element;
                EditingDomain editingDomain = ((IEditingDomainProvider)GenModelActionBarContributor.this.activeEditorPart).getEditingDomain();
                if (editingDomain.getResourceSet().getResources().indexOf((Object)eObject.eResource()) != 0) {
                    return eObject;
                }
            }
            return null;
        }
    };

    protected ISelection getActiveEditorSelection() {
        return this.activeEditorPart == null ? null : ((GenModelEditor)this.activeEditorPart).getSelection();
    }

    public GenModelActionBarContributor() {
        super(1);
        this.showGenAnnotationsAction.setChecked(Boolean.parseBoolean(GenModelEditPlugin.getPlugin().getDialogSettings().get("showGenAnnotationsAction")));
    }

    public void dispose() {
        GenModelEditPlugin.getPlugin().getDialogSettings().put("showGenAnnotationsAction", Boolean.toString(this.showGenAnnotationsAction.isChecked()));
        this.showGenAnnotationsAction.dispose();
        this.annotateAction.dispose();
        this.addDetailAction.dispose();
        this.openEcoreAction.dispose();
        this.openGenModelAction.dispose();
        super.dispose();
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        this.generateMenuManager = new MenuManager(GenModelEditPlugin.INSTANCE.getString("_UI_Generate_menu"), "org.eclipse.emf.codegen.ecore.genmodelMenuID");
        menuManager.insertAfter("additions", (IContributionItem)this.generateMenuManager);
        this.generateMenuManager.add(this.generateModelAction);
        this.generateMenuManager.add(this.generateEditAction);
        this.generateMenuManager.add(this.generateEditorAction);
        this.generateMenuManager.add(this.generateTestsAction);
        this.generateMenuManager.add(this.generateAllAction);
        this.generateMenuManager.add((IContributionItem)new Separator("annotation-actions"));
        this.generateMenuManager.add((IAction)this.showGenAnnotationsAction);
        this.generateMenuManager.add((IContributionItem)new Separator("global-actions"));
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator("genmodel-settings"));
        toolBarManager.add((IContributionItem)new Separator("genmodel-additions"));
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        if (part instanceof GenModelEditor) {
            this.showGenAnnotationsAction.addViewer(((GenModelEditor)part).getViewer());
            this.showGenAnnotationsAction.setEnabled(true);
        } else {
            this.showGenAnnotationsAction.setEnabled(false);
        }
        this.activeEditorPart = part;
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IContributionItem[] items = this.generateMenuManager.getItems();
        int i = 0;
        int len = items.length;
        while (i < len) {
            items[i].update();
            ++i;
        }
        this.annotateAction.selectionChanged(event);
        this.addDetailAction.selectionChanged(event);
        this.openEcoreAction.selectionChanged(event);
        this.openGenModelAction.selectionChanged(event);
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        this.generateAllAction.setEnabled(this.generateAllAction.isEnabled());
        this.generateTestsAction.setEnabled(this.generateTestsAction.isEnabled());
        this.generateEditorAction.setEnabled(this.generateEditorAction.isEnabled());
        this.generateEditAction.setEnabled(this.generateEditAction.isEnabled());
        this.generateModelAction.setEnabled(this.generateModelAction.isEnabled());
        this.refreshViewerAction.setEnabled(this.refreshViewerAction.isEnabled());
        super.menuAboutToShow(menuManager);
        menuManager.insertBefore("edit", (IContributionItem)new Separator("generate-actions"));
        menuManager.insertAfter("generate-actions", this.generateAllAction);
        menuManager.insertAfter("generate-actions", this.generateTestsAction);
        menuManager.insertAfter("generate-actions", this.generateEditorAction);
        menuManager.insertAfter("generate-actions", this.generateEditAction);
        menuManager.insertAfter("generate-actions", this.generateModelAction);
        menuManager.insertBefore("edit", (IContributionItem)new Separator("open-actions"));
        menuManager.insertAfter("open-actions", (IAction)this.openGenModelAction);
        menuManager.insertAfter("open-actions", (IAction)this.openEcoreAction);
        if (this.showGenAnnotationsAction.isChecked()) {
            menuManager.insertBefore("edit", (IContributionItem)new Separator("annotation-actions"));
            if (this.addDetailAction.isEnabled()) {
                menuManager.insertAfter("annotation-actions", (IAction)this.addDetailAction);
            }
            if (this.annotateAction.isEnabled()) {
                menuManager.insertAfter("annotation-actions", (IAction)this.annotateAction);
            }
        }
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        menuManager.insertAfter("additions-end", (IContributionItem)new Separator("ui-actions"));
        menuManager.insertAfter("ui-actions", this.showPropertiesViewAction);
        this.refreshViewerAction.setEnabled(this.refreshViewerAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.refreshViewerAction);
        super.addGlobalActions(menuManager);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class CreateAction
    extends CommandActionHandler {
        protected String label;

        public CreateAction(String text, String label) {
            super(null, text);
            this.label = label;
        }

        public void dispose() {
            this.setEditingDomain(null);
        }

        public Command createCommand(Collection<?> selection) {
            Object selectedObject;
            if (GenModelActionBarContributor.this.activeEditorPart instanceof IEditingDomainProvider) {
                this.setEditingDomain(((IEditingDomainProvider)GenModelActionBarContributor.this.activeEditorPart).getEditingDomain());
            }
            if (this.getEditingDomain() != null && selection.size() == 1 && (selectedObject = selection.iterator().next()) instanceof GenBase) {
                Command command = this.doCreateCommand((GenBase)selectedObject);
                if (command != null) {
                    command = new CommandWrapper(this.label, null, command);
                }
                return command;
            }
            return UnexecutableCommand.INSTANCE;
        }

        protected abstract Command doCreateCommand(GenBase var1);
    }

    protected class GenerateAction
    extends Action {
        ProjectType[] projectTypes;
        Generator generator;

        public GenerateAction(Object projectType, String projectTypeName, String text) {
            super(text);
            this.projectTypes = new ProjectType[]{new ProjectType(projectType, projectTypeName)};
        }

        public GenerateAction(ProjectType[] projectTypes, String text) {
            super(text);
            this.projectTypes = projectTypes;
        }

        public boolean isEnabled() {
            if (GenModelActionBarContributor.this.activeEditorPart instanceof GenModelEditor) {
                this.generator = ((GenModelEditor)GenModelActionBarContributor.this.activeEditorPart).getGenerator();
            }
            if (this.generator == null) {
                return false;
            }
            ISelection s = GenModelActionBarContributor.this.getActiveEditorSelection();
            if (!(s instanceof IStructuredSelection)) {
                return false;
            }
            IStructuredSelection ss = (IStructuredSelection)s;
            if (ss.size() == 0) {
                return false;
            }
            for (Object object : ss.toList()) {
                boolean canGenerateObject = false;
                int i = 0;
                while (i < this.projectTypes.length) {
                    if (this.generator.canGenerate(object, this.projectTypes[i].getType())) {
                        canGenerateObject = true;
                    }
                    ++i;
                }
                if (canGenerateObject) continue;
                return false;
            }
            return true;
        }

        public void run() {
            GeneratorUIUtil.GeneratorOperation operation = new GeneratorUIUtil.GeneratorOperation(GenModelActionBarContributor.this.activeEditorPart.getSite().getShell());
            operation.setRootDiagnosticMessage(this.getText());
            List selection = ((IStructuredSelection)GenModelActionBarContributor.this.getActiveEditorSelection()).toList();
            for (Object object : selection) {
                int i = 0;
                while (i < this.projectTypes.length) {
                    operation.addGeneratorAndArguments(this.generator, object, this.projectTypes[i].getType(), this.projectTypes[i].getName());
                    ++i;
                }
            }
            try {
                new ProgressMonitorDialog(GenModelActionBarContributor.this.activeEditorPart.getSite().getShell()).run(true, true, (IRunnableWithProgress)operation);
            }
            catch (Exception exception) {
                GenModelEditPlugin.INSTANCE.log(exception);
            }
        }
    }

    protected static abstract class OpenEObjectEditorAction
    extends BaseSelectionListenerAction {
        protected EObject eObject;

        public OpenEObjectEditorAction(String text) {
            super(text);
        }

        public void dispose() {
            this.eObject = null;
            this.clearCache();
        }

        public void run() {
            if (this.eObject != null) {
                try {
                    EditUIUtil.openEditor((EObject)this.eObject);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        }

        protected boolean updateSelection(IStructuredSelection selection) {
            if (selection.size() == 1) {
                Object element = selection.getFirstElement();
                this.eObject = this.getEObject(element);
                return this.eObject != null;
            }
            return false;
        }

        protected abstract EObject getEObject(Object var1);
    }

    protected static class ProjectType {
        protected Object type;
        protected String name;

        public ProjectType(Object type, String name) {
            this.type = type;
            this.name = name;
        }

        public Object getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }
    }
}

