/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.impl;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.DialChart;
import org.eclipse.birt.chart.model.ModelFactory;
import org.eclipse.birt.chart.model.ModelPackage;
import org.eclipse.birt.chart.model.impl.ChartImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.impl.ChartWithoutAxesImpl;
import org.eclipse.birt.chart.model.impl.DialChartImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;

public class ModelFactoryImpl
extends EFactoryImpl
implements ModelFactory {
    public static ModelFactory init() {
        try {
            ModelFactory theModelFactory = (ModelFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.birt.eclipse.org/ChartModel");
            if (theModelFactory != null) {
                return theModelFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ModelFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createChart();
            }
            case 1: {
                return this.createChartWithAxes();
            }
            case 2: {
                return this.createChartWithoutAxes();
            }
            case 3: {
                return this.createDialChart();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 4: {
                return this.createCoverageTypeFromString(eDataType, initialValue);
            }
            case 5: {
                return this.createCoverageTypeObjectFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 4: {
                return this.convertCoverageTypeToString(eDataType, instanceValue);
            }
            case 5: {
                return this.convertCoverageTypeObjectToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public Chart createChart() {
        ChartImpl chart = new ChartImpl();
        return chart;
    }

    public ChartWithAxes createChartWithAxes() {
        ChartWithAxesImpl chartWithAxes = new ChartWithAxesImpl();
        return chartWithAxes;
    }

    public ChartWithoutAxes createChartWithoutAxes() {
        ChartWithoutAxesImpl chartWithoutAxes = new ChartWithoutAxesImpl();
        return chartWithoutAxes;
    }

    public DialChart createDialChart() {
        DialChartImpl dialChart = new DialChartImpl();
        return dialChart;
    }

    public Double createCoverageTypeFromString(EDataType eDataType, String initialValue) {
        return (Double)XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.DOUBLE, initialValue);
    }

    public String convertCoverageTypeToString(EDataType eDataType, Object instanceValue) {
        return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.DOUBLE, instanceValue);
    }

    public Double createCoverageTypeObjectFromString(EDataType eDataType, String initialValue) {
        return this.createCoverageTypeFromString(ModelPackage.Literals.COVERAGE_TYPE, initialValue);
    }

    public String convertCoverageTypeObjectToString(EDataType eDataType, Object instanceValue) {
        return this.convertCoverageTypeToString(ModelPackage.Literals.COVERAGE_TYPE, instanceValue);
    }

    public ModelPackage getModelPackage() {
        return (ModelPackage)this.getEPackage();
    }

    @Deprecated
    public static ModelPackage getPackage() {
        return ModelPackage.eINSTANCE;
    }
}

