/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import java.util.ArrayList;
import org.eclipse.birt.chart.computation.withaxes.AllAxes;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.AxesAdjuster;
import org.eclipse.birt.chart.computation.withaxes.HorizontalAxisAdjuster;
import org.eclipse.birt.chart.computation.withaxes.IAxisAdjuster;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.computation.withaxes.PlotWithAxes;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.component.Label;

public class HorizontalAxesAdjuster
implements IAxisAdjuster {
    private OneAxis[] fHorizontalAxes;
    private OneAxis fVerticalAxis;
    private PlotWithAxes fPlotWithAxes;
    private Bounds fPlotBounds;

    public HorizontalAxesAdjuster(OneAxis[] horizontalAxes, OneAxis verticalAxis, PlotWithAxes plotWithAxes, Bounds boPlot) {
        this.fHorizontalAxes = horizontalAxes;
        this.fVerticalAxis = verticalAxis;
        this.fPlotWithAxes = plotWithAxes;
        this.fPlotBounds = boPlot;
    }

    public void adjust() throws ChartException {
        this.adjust(true);
    }

    public void adjust(boolean checkAxisLabel) throws ChartException {
        HorizontalAxisAdjuster haa;
        AutoScale scY = this.fVerticalAxis.getScale();
        boolean isForward = scY.getDirection() == 1;
        ArrayList<HorizontalAxisAdjuster> values = new ArrayList<HorizontalAxisAdjuster>();
        ArrayList<HorizontalAxisAdjuster> min = new ArrayList<HorizontalAxisAdjuster>();
        ArrayList<HorizontalAxisAdjuster> max = new ArrayList<HorizontalAxisAdjuster>();
        OneAxis[] oneAxisArray = this.fHorizontalAxes;
        int n = this.fHorizontalAxes.length;
        int n2 = 0;
        while (n2 < n) {
            OneAxis oa = oneAxisArray[n2];
            HorizontalAxisAdjuster vaa = new HorizontalAxisAdjuster(oa, this.fVerticalAxis, this.fPlotWithAxes, this.fPlotBounds);
            int iv = oa.getIntersectionValue().getType();
            switch (iv) {
                case 2: {
                    min.add(vaa);
                    break;
                }
                case 1: {
                    max.add(vaa);
                    break;
                }
                default: {
                    values.add(vaa);
                }
            }
            ++n2;
        }
        boolean onlyValueOrigin = values.size() > 0 && min.size() == 0 && max.size() == 0;
        double y = Double.NaN;
        double bottom = Double.NaN;
        double top = Double.NaN;
        double[] endPoints = scY.getEndPoints();
        scY.resetShifts();
        int i = 0;
        while (i < values.size()) {
            scY.setEndPoints(endPoints[0], endPoints[1]);
            haa = (HorizontalAxisAdjuster)values.get(i);
            haa.adjust();
            double locationDelta = AxesAdjuster.getLocationDelta(scY, haa.getHorizontalAxis().getIntersectionValue());
            if (locationDelta >= 0.0 || haa.getAxisBottomEdge() >= endPoints[0]) {
                min.add(haa);
            } else if (haa.getAxisTopEdge() <= endPoints[1]) {
                max.add(haa);
            }
            ++i;
        }
        scY.resetShifts();
        i = 0;
        while (i < min.size()) {
            boolean isMinOrigin;
            scY.setEndPoints(endPoints[0], endPoints[1]);
            haa = (HorizontalAxisAdjuster)min.get(i);
            haa.adjust();
            boolean bl = isMinOrigin = haa.getHorizontalAxis().getIntersectionValue().getType() == 2;
            if (Double.isNaN(y)) {
                if (isMinOrigin) {
                    y = haa.getAxisY();
                    bottom = haa.getAxisBottomEdge();
                    top = haa.getAxisTopEdge();
                } else {
                    y = haa.getAxisBottomEdge() >= scY.getStart() ? haa.getAxisY() : scY.getStart();
                    bottom = haa.getAxisBottomEdge() > y ? haa.getAxisBottomEdge() : y;
                    top = y;
                }
            } else {
                double deltaY1 = bottom - y;
                double deltaY2 = y - top;
                if (isMinOrigin) {
                    if (haa.getAxisY() < y) {
                        y = haa.getAxisY();
                    }
                    bottom = y + Math.max(deltaY1, haa.getAxisBottomEdge() - haa.getAxisY());
                    top = y - Math.max(deltaY2, haa.getAxisY() - haa.getAxisTopEdge());
                } else {
                    if (scY.getEndPoints()[0] < haa.getAxisY()) {
                        y = scY.getEndPoints()[0];
                    }
                    bottom = y + Math.max(deltaY1, haa.getAxisBottomEdge() - scY.getEndPoints()[0]);
                    top = y - deltaY2;
                }
            }
            ++i;
        }
        if (!Double.isNaN(y)) {
            scY.setEndPoints(endPoints[0], endPoints[1]);
            scY.resetShifts();
            double[] positions = this.adjustAcrossAxis(onlyValueOrigin ? 3 : 2, this.fVerticalAxis, y, bottom, top, checkAxisLabel);
            y = positions[0];
            top = positions[1];
            bottom = positions[2];
        }
        i = 0;
        while (i < min.size()) {
            haa = (HorizontalAxisAdjuster)min.get(i);
            OneAxis oa = haa.getHorizontalAxis();
            oa.setAxisCoordinate(y);
            oa.setTitleCoordinate(haa.getTitleCoordinate(y));
            ++i;
        }
        y = Double.NaN;
        bottom = Double.NaN;
        top = Double.NaN;
        endPoints = scY.getEndPoints();
        scY.resetShifts();
        i = 0;
        while (i < max.size()) {
            scY.setEndPoints(endPoints[0], endPoints[1]);
            haa = (HorizontalAxisAdjuster)max.get(i);
            haa.adjust();
            if (Double.isNaN(y)) {
                y = haa.getAxisY();
                bottom = haa.getAxisBottomEdge();
                top = haa.getAxisTopEdge();
            } else {
                double deltaY1 = bottom - y;
                double deltaY2 = y - top;
                if (haa.getAxisY() > y) {
                    y = haa.getAxisY();
                    bottom = y + Math.max(deltaY1, haa.getAxisBottomEdge() - y);
                    top = y - Math.max(deltaY2, y - haa.getAxisTopEdge());
                }
            }
            ++i;
        }
        if (!Double.isNaN(y)) {
            scY.setEndPoints(endPoints[0], endPoints[1]);
            double[] positions = this.adjustAcrossAxis(onlyValueOrigin ? 3 : 1, this.fVerticalAxis, y, bottom, top, checkAxisLabel);
            y = positions[0];
            top = positions[1];
            bottom = positions[2];
        }
        i = 0;
        while (i < max.size()) {
            haa = (HorizontalAxisAdjuster)max.get(i);
            OneAxis oa = haa.getHorizontalAxis();
            oa.setAxisCoordinate(y);
            oa.setTitleCoordinate(haa.getTitleCoordinate(y));
            ++i;
        }
        i = 0;
        while (i < values.size()) {
            haa = (HorizontalAxisAdjuster)values.get(i);
            OneAxis oa = haa.getHorizontalAxis();
            double axisCoordinate = 0.0;
            double locationDelta = AxesAdjuster.getLocationDelta(scY, haa.getHorizontalAxis().getIntersectionValue());
            axisCoordinate = !isForward ? scY.getEndPoints()[0] + locationDelta : scY.getEndPoints()[1] + locationDelta;
            oa.setAxisCoordinate(axisCoordinate);
            oa.setTitleCoordinate(haa.getTitleCoordinate(axisCoordinate));
            ++i;
        }
        scY.computeTicks(this.fPlotWithAxes.getDisplayServer(), this.fVerticalAxis.getLabel(), this.fVerticalAxis.getLabelPosition(), 1, scY.getStart(), scY.getEnd(), false, this.fPlotWithAxes.getAxes());
        scY.resetShifts();
    }

    double[] adjustAcrossAxis(int iv, OneAxis orthogonalAxis, double dY, double dBottom, double dTop, boolean checkAxisLabel) throws ChartException {
        IDisplayServer ids = this.fPlotWithAxes.getDisplayServer();
        AutoScale scY = orthogonalAxis.getScale();
        AllAxes aax = this.fPlotWithAxes.getAxes();
        Label laYAxisLabels = orthogonalAxis.getLabel();
        int iYLabelLocation = orthogonalAxis.getLabelPosition();
        boolean bForwardScale = scY.getDirection() == 1;
        double dXAxisThickness = dBottom - dTop;
        double dDeltaY1 = dY - dTop;
        double dDeltaY2 = dBottom - dY;
        boolean startEndChanged = false;
        if (bForwardScale && iv == 2 || !bForwardScale && iv == 1) {
            if (bForwardScale && dXAxisThickness > scY.getStartShift() || !bForwardScale && dXAxisThickness > scY.getEndShift()) {
                double dStart = scY.getStart();
                double dEnd = dBottom - scY.getEndShift();
                if (bForwardScale) {
                    dStart = dBottom - scY.getStartShift();
                    dEnd = scY.getEnd();
                }
                scY.resetShifts();
                scY.setEndPoints(dStart, dEnd);
                scY.computeTicks(ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, startEndChanged && checkAxisLabel, aax);
                if (!scY.isStepFixed()) {
                    Object[] oaMinMax = scY.getMinMax();
                    while (!scY.checkFit(ids, laYAxisLabels, iYLabelLocation)) {
                        if (!scY.zoomOut()) break;
                        scY.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                        int tickCount = scY.computeTicks(ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, startEndChanged && checkAxisLabel, aax);
                        if (scY.getUnit() != null && PlotWithAxes.asInteger(scY.getUnit()) == 1 && tickCount <= 3 || this.fPlotWithAxes.isSharedScale()) break;
                    }
                }
            }
            dTop = (dY -= this.fPlotWithAxes.getPlotInsets().getTop()) - dDeltaY1;
            dBottom = dY + dDeltaY2;
        } else if (bForwardScale && iv == 1 || !bForwardScale && iv == 2) {
            if (bForwardScale && dXAxisThickness > scY.getEndShift() || !bForwardScale && dXAxisThickness > scY.getStartShift()) {
                double dStart = dTop + scY.getStartShift();
                double dEnd = scY.getEnd();
                if (bForwardScale) {
                    dStart = scY.getStart();
                    dEnd = dTop + scY.getEndShift();
                }
                scY.resetShifts();
                if (dStart < dEnd + 1.0) {
                    dStart = dEnd + 1.0;
                    startEndChanged = true;
                }
                scY.setEndPoints(dStart, dEnd);
                scY.computeTicks(ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, startEndChanged && checkAxisLabel, false, aax);
                if (!scY.isStepFixed()) {
                    Object[] oaMinMax = scY.getMinMax();
                    while (!scY.checkFit(ids, laYAxisLabels, iYLabelLocation)) {
                        if (!scY.zoomOut()) break;
                        double dOldStep = ((Number)scY.getStep()).doubleValue();
                        scY.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                        int tickCount = scY.computeTicks(ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, startEndChanged && checkAxisLabel, false, aax);
                        double dNewStep = ((Number)scY.getStep()).doubleValue();
                        if (dNewStep < dOldStep || scY.getUnit() != null && PlotWithAxes.asInteger(scY.getUnit()) == 1 && tickCount <= 3 || this.fPlotWithAxes.isSharedScale()) break;
                    }
                }
            }
            dTop = (dY += this.fPlotWithAxes.getPlotInsets().getBottom()) - dDeltaY1;
            dBottom = dY + dDeltaY2;
        } else {
            if (bForwardScale && dXAxisThickness > scY.getEndShift() || !bForwardScale && dXAxisThickness > scY.getStartShift()) {
                double dStart = scY.getStart();
                double dEnd = scY.getEnd();
                if (dBottom >= scY.getStart()) {
                    dStart = dY;
                    startEndChanged = true;
                } else if (dY <= scY.getEnd()) {
                    dEnd = dY;
                    startEndChanged = true;
                }
                if (bForwardScale) {
                    dStart = scY.getStart();
                    dEnd = dTop + scY.getEndShift();
                    startEndChanged = true;
                }
                scY.resetShifts();
                if (dStart < dEnd + 1.0) {
                    dStart = dEnd + 1.0;
                    startEndChanged = true;
                }
                scY.setEndPoints(dStart, dEnd);
                scY.computeTicks(ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, startEndChanged, false, aax);
                if (!scY.isStepFixed()) {
                    Object[] oaMinMax = scY.getMinMax();
                    while (!scY.checkFit(ids, laYAxisLabels, iYLabelLocation)) {
                        if (!scY.zoomOut()) break;
                        double dOldStep = ((Number)scY.getStep()).doubleValue();
                        scY.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                        int tickCount = scY.computeTicks(ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, startEndChanged, false, aax);
                        double dNewStep = ((Number)scY.getStep()).doubleValue();
                        if (dNewStep < dOldStep || scY.getUnit() != null && PlotWithAxes.asInteger(scY.getUnit()) == 1 && tickCount <= 3 || this.fPlotWithAxes.isSharedScale()) break;
                    }
                }
            }
            dTop = (dY += this.fPlotWithAxes.getPlotInsets().getBottom()) - dDeltaY1;
            dBottom = dY + dDeltaY2;
        }
        return new double[]{dY, dTop, dBottom};
    }
}

