/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.pde.api.tools.internal.builder.AbstractTypeLeakDetector;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiField;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;

public class LeakFieldProblemDetector
extends AbstractTypeLeakDetector {
    public LeakFieldProblemDetector(Set nonApiPackageNames) {
        super(nonApiPackageNames);
    }

    protected boolean isApplicable(IApiAnnotations annotations) {
        return super.isApplicable(annotations) && !RestrictionModifiers.isReferenceRestriction(annotations.getRestrictions());
    }

    public int getReferenceKinds() {
        return 4;
    }

    protected int getElementType(IReference reference) {
        return 5;
    }

    protected String getSeverityKey() {
        return "LEAK_FIELD_DECL";
    }

    protected int getProblemFlags(IReference reference) {
        return 3;
    }

    protected boolean isProblem(IReference reference) {
        if (super.isProblem(reference)) {
            IApiField field = (IApiField)reference.getMember();
            if ((4 & field.getModifiers()) > 0) {
                try {
                    IApiDescription description = field.getApiComponent().getApiDescription();
                    IApiAnnotations annotations = description.resolveAnnotations(field.getHandle().getEnclosingType());
                    if (annotations == null || RestrictionModifiers.isExtendRestriction(annotations.getRestrictions())) {
                        return false;
                    }
                }
                catch (CoreException e) {
                    ApiPlugin.log(e);
                }
            }
            return true;
        }
        return false;
    }

    protected String[] getMessageArgs(IReference reference) throws CoreException {
        IApiField field = (IApiField)reference.getMember();
        IApiType type = (IApiType)reference.getResolvedReference();
        return new String[]{this.getSimpleTypeName(type), this.getSimpleTypeName(field), field.getName()};
    }

    protected String[] getQualifiedMessageArgs(IReference reference) throws CoreException {
        IApiField field = (IApiField)reference.getMember();
        IApiType type = (IApiType)reference.getResolvedReference();
        return new String[]{this.getQualifiedTypeName(type), this.getQualifiedTypeName(field), field.getName()};
    }

    protected Position getSourceRange(IType type, IDocument doc, IReference reference) throws CoreException, BadLocationException {
        ISourceRange range;
        IApiField field = (IApiField)reference.getMember();
        IField javaField = type.getField(field.getName());
        Position pos = null;
        if (javaField.exists() && (range = javaField.getNameRange()) != null) {
            pos = new Position(range.getOffset(), range.getLength());
        }
        if (pos == null) {
            return this.defaultSourcePosition(type, reference);
        }
        return pos;
    }
}

