/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.widgets;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.populationmodels.standard.PopulationModel;
import org.eclipse.stem.ui.views.geographic.map.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PropertySelector
extends Composite {
    private final List<PropertySelectionListener> propertySelectionListeners = new CopyOnWriteArrayList<PropertySelectionListener>();
    private ISimulation simulation = null;
    private String initialPropertyName;
    private final Label displayLabel;
    Combo decoratorsCombo;
    Combo propertiesCombo;
    Combo popIdsCombo;
    List<Decorator> decorators;
    Decorator selectedDecorator;
    List<ItemPropertyDescriptor> properties;
    ItemPropertyDescriptor selectedProperty;
    String selectedId;
    private DecoratorFilter decoratorFilter = new DecoratorFilter(){

        @Override
        public boolean accept(Decorator decorator) {
            return true;
        }
    };
    private PropertySieve propertySieve = new PropertySieve(){

        @Override
        public List<ItemPropertyDescriptor> sieve(DynamicLabel dynamicLabel) {
            ArrayList<ItemPropertyDescriptor> retValue = new ArrayList<ItemPropertyDescriptor>();
            RelativeValueProviderAdapter rvp = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt((Notifier)dynamicLabel, RelativeValueProvider.class);
            if (rvp != null) {
                rvp.setTarget((Notifier)dynamicLabel);
                for (Object element : rvp.getProperties()) {
                    ItemPropertyDescriptor property = (ItemPropertyDescriptor)element;
                    retValue.add(property);
                }
            }
            return retValue;
        }
    };

    public PropertySelector(Composite parent, int style, boolean allowPropertySelection) {
        super(parent, style);
        FormLayout retValueLayout = new FormLayout();
        this.setLayout((Layout)retValueLayout);
        this.displayLabel = new Label((Composite)this, 0x1000000);
        this.displayLabel.setText(String.valueOf(Messages.getString("IMView.MProp")) + " :");
        this.decoratorsCombo = new Combo((Composite)this, 0x100000C);
        this.propertiesCombo = new Combo((Composite)this, 0x100000C);
        this.popIdsCombo = new Combo((Composite)this, 0x100000C);
        FormData decoratorsComboFormData = new FormData();
        decoratorsComboFormData.top = new FormAttachment((Control)this.displayLabel, 0);
        decoratorsComboFormData.left = new FormAttachment(0, 0);
        decoratorsComboFormData.right = new FormAttachment(100, 0);
        this.decoratorsCombo.setLayoutData((Object)decoratorsComboFormData);
        FormData propertiesComboFormData = new FormData();
        propertiesComboFormData.top = new FormAttachment((Control)this.decoratorsCombo, 0);
        propertiesComboFormData.left = new FormAttachment(0, 0);
        propertiesComboFormData.right = new FormAttachment(100, 0);
        this.propertiesCombo.setLayoutData((Object)propertiesComboFormData);
        FormData popIdsComboFormData = new FormData();
        popIdsComboFormData.top = new FormAttachment((Control)this.propertiesCombo, 0);
        popIdsComboFormData.left = new FormAttachment(0, 0);
        popIdsComboFormData.right = new FormAttachment(100, 0);
        this.popIdsCombo.setLayoutData((Object)popIdsComboFormData);
        this.pack();
        this.decoratorsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Decorator tempDecorator;
                if (!PropertySelector.this.decorators.isEmpty() && PropertySelector.this.selectedDecorator != (tempDecorator = PropertySelector.this.decorators.get(PropertySelector.this.decoratorsCombo.getSelectionIndex()))) {
                    PropertySelector.this.selectedDecorator = tempDecorator;
                    List<String> ids = PropertySelector.this.getIdsToDisplay(PropertySelector.this.selectedDecorator);
                    PropertySelector.this.selectedId = ids.get(0);
                    PropertySelector.this.properties = PropertySelector.this.getPropertiesToDisplay(PropertySelector.this.selectedDecorator, PropertySelector.this.selectedId);
                    PropertySelector.this.selectedProperty = PropertySelector.this.selectCurrentDecoratorProperty(PropertySelector.this.properties);
                    PropertySelector.this.initializeCombo(PropertySelector.this.propertiesCombo, PropertySelector.this.getPropertyNames(PropertySelector.this.properties), PropertySelector.this.getPropertyIndex(PropertySelector.this.selectedProperty, PropertySelector.this.properties));
                    String[] propIds = ids.toArray(new String[0]);
                    PropertySelector.this.initializeCombo(PropertySelector.this.popIdsCombo, propIds, 0);
                    PropertySelector.this.notifyPropertySelection(PropertySelector.this.selectedProperty, PropertySelector.this.selectedId);
                }
            }
        });
        this.propertiesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ItemPropertyDescriptor temp;
                if (!PropertySelector.this.properties.isEmpty() && PropertySelector.this.selectedProperty != (temp = PropertySelector.this.properties.get(PropertySelector.this.propertiesCombo.getSelectionIndex()))) {
                    PropertySelector.this.selectedProperty = temp;
                    PropertySelector.this.notifyPropertySelection(PropertySelector.this.selectedProperty, PropertySelector.this.selectedId);
                }
            }
        });
        this.popIdsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<String> ids = PropertySelector.this.getIdsToDisplay(PropertySelector.this.selectedDecorator);
                String temp = ids.get(PropertySelector.this.popIdsCombo.getSelectionIndex());
                if (!PropertySelector.this.selectedId.equals(temp)) {
                    PropertySelector.this.selectedId = temp;
                    PropertySelector.this.properties = PropertySelector.this.getPropertiesToDisplay(PropertySelector.this.selectedDecorator, PropertySelector.this.selectedId);
                    PropertySelector.this.selectedProperty = PropertySelector.this.selectCurrentDecoratorProperty(PropertySelector.this.properties);
                    PropertySelector.this.initializeCombo(PropertySelector.this.propertiesCombo, PropertySelector.this.getPropertyNames(PropertySelector.this.properties), PropertySelector.this.getPropertyIndex(PropertySelector.this.selectedProperty, PropertySelector.this.properties));
                    PropertySelector.this.notifyPropertySelection(PropertySelector.this.selectedProperty, PropertySelector.this.selectedId);
                }
            }
        });
        if (!allowPropertySelection) {
            this.propertiesCombo.setEnabled(false);
        }
        this.setSimulation(null);
    }

    void notifyPropertySelection(ItemPropertyDescriptor selectedProperty, String popid) {
        if (selectedProperty != null) {
            this.firePropertySelectionEvent(new PropertySelectionEvent(this.selectedDecorator, selectedProperty, (Object)this, popid));
        }
    }

    public boolean isInitialized() {
        return this.decorators != null && !this.decorators.isEmpty();
    }

    public void setDecorators(List<Decorator> decorators) {
        this.decorators = decorators;
        this.selectedDecorator = decorators.isEmpty() ? null : decorators.get(0);
        this.initializeCombo(this.decoratorsCombo, this.getDecoratorNames(decorators), this.getDecoratorIndex(this.selectedDecorator, decorators));
        List<String> ids = this.getIdsToDisplay(this.selectedDecorator);
        if (ids != null) {
            String[] propIds = ids.toArray(new String[0]);
            this.initializeCombo(this.popIdsCombo, propIds, 0);
        }
        this.selectedId = ids == null ? null : ids.get(0);
        this.properties = this.getPropertiesToDisplay(this.selectedDecorator, this.selectedId);
        this.selectedProperty = this.selectCurrentDecoratorProperty(this.properties);
        this.initializeCombo(this.propertiesCombo, this.getPropertyNames(this.properties), this.getPropertyIndex(this.selectedProperty, this.properties));
        this.notifyPropertySelection(this.selectedProperty, this.selectedId);
    }

    public void setSimulation(ISimulation simulation) {
        this.simulation = simulation;
        this.setDecorators(this.getDecoratorsToDisplay(simulation));
    }

    public final ISimulation getSimulation() {
        return this.simulation;
    }

    public void setDecoratorFilter(DecoratorFilter decoratorFilter) {
        this.decoratorFilter = decoratorFilter;
    }

    public void setPropertySieve(PropertySieve propertySieve) {
        this.propertySieve = propertySieve;
    }

    private List<Decorator> getDecoratorsToDisplay(ISimulation simulation) {
        Graph canonicalGraph;
        ArrayList<Decorator> retValue = new ArrayList<Decorator>();
        if (simulation != null && (canonicalGraph = simulation.getScenario().getCanonicalGraph()) != null) {
            for (Object element : canonicalGraph.getDecorators()) {
                Decorator decorator = (Decorator)element;
                if (!this.decoratorFilter.accept(decorator)) continue;
                retValue.add(decorator);
            }
        }
        return retValue;
    }

    List<ItemPropertyDescriptor> getPropertiesToDisplay(Decorator decorator, String populationIdentifier) {
        ArrayList<ItemPropertyDescriptor> retValue = new ArrayList<ItemPropertyDescriptor>();
        if (decorator != null && !decorator.getLabelsToUpdate().isEmpty()) {
            if (decorator instanceof DiseaseModel) {
                retValue.addAll(this.propertySieve.sieve((DynamicLabel)((DiseaseModel)decorator).createDiseaseModelLabel(populationIdentifier)));
            } else {
                retValue.addAll(this.propertySieve.sieve((DynamicLabel)decorator.getLabelsToUpdate().get(0)));
            }
        }
        return retValue;
    }

    List<String> getIdsToDisplay(Decorator decorator) {
        if (decorator instanceof DiseaseModel) {
            return ((DiseaseModel)decorator).getAllLabelIdentifiers();
        }
        if (decorator instanceof PopulationModel) {
            return ((PopulationModel)decorator).getAllLabelIdentifiers();
        }
        return null;
    }

    ItemPropertyDescriptor selectCurrentDecoratorProperty(List<ItemPropertyDescriptor> decoratorProperties) {
        for (ItemPropertyDescriptor property : decoratorProperties) {
            if (!property.getDisplayName((Object)property).equals(this.initialPropertyName)) continue;
            return property;
        }
        if (!decoratorProperties.isEmpty()) {
            return decoratorProperties.get(0);
        }
        return null;
    }

    void initializeCombo(Combo combo, String[] names, int selectionIndex) {
        combo.setItems(names);
        combo.select(selectionIndex);
    }

    private String[] getDecoratorNames(List<Decorator> decorators) {
        ArrayList<String> retValue = new ArrayList<String>();
        if (decorators != null) {
            Iterator<Decorator> iterator = decorators.iterator();
            while (iterator.hasNext()) {
                ComposedAdapterFactory itemProviderFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
                Decorator decorator = iterator.next();
                IItemLabelProvider lp = (IItemLabelProvider)itemProviderFactory.adapt((Notifier)decorator, IItemLabelProvider.class);
                String title = lp.getText((Object)decorator);
                title = title == null ? "null" : title;
                retValue.add(title);
            }
        }
        return retValue.toArray(new String[0]);
    }

    private int getDecoratorIndex(Decorator selectedDecorator, List<Decorator> decorators) {
        if (selectedDecorator != null && decorators != null && !decorators.isEmpty()) {
            return decorators.indexOf(selectedDecorator);
        }
        return 0;
    }

    String[] getPropertyNames(List<ItemPropertyDescriptor> properties) {
        ArrayList<String> retValue = new ArrayList<String>();
        if (properties != null) {
            for (ItemPropertyDescriptor property : properties) {
                retValue.add(property.getDisplayName((Object)property));
            }
        }
        return retValue.toArray(new String[0]);
    }

    int getPropertyIndex(ItemPropertyDescriptor selectedDecoratorProperty, List<ItemPropertyDescriptor> decoratorProperties) {
        if (selectedDecoratorProperty != null) {
            return decoratorProperties.indexOf(selectedDecoratorProperty);
        }
        return 0;
    }

    public boolean setDisplayedProperty(String preferredProperty) {
        int index = this.propertiesCombo.indexOf(preferredProperty);
        if (index >= 0) {
            this.propertiesCombo.select(index);
            this.initialPropertyName = preferredProperty;
            this.properties = this.getPropertiesToDisplay(this.selectedDecorator, this.selectedId);
            for (ItemPropertyDescriptor property : this.properties) {
                if (!property.getDisplayName((Object)property).equals(this.initialPropertyName)) continue;
                this.selectedProperty = property;
                break;
            }
            this.firePropertySelectionEvent(new PropertySelectionEvent(this.selectedDecorator, this.selectedProperty, this.propertiesCombo, this.selectedId));
            return true;
        }
        return false;
    }

    public void addPropertySelectionListener(PropertySelectionListener listener) {
        this.propertySelectionListeners.add(listener);
    }

    public void removePropertySelectionListener(PropertySelectionListener listener) {
        this.propertySelectionListeners.remove(listener);
    }

    private void firePropertySelectionEvent(PropertySelectionEvent pse) {
        for (PropertySelectionListener listener : this.propertySelectionListeners) {
            listener.propertySelected(pse);
        }
    }

    public String getDisplayLabel() {
        return this.displayLabel.getText();
    }

    public void setDisplayLabel(String displayLabel) {
        this.displayLabel.setText(displayLabel);
    }

    public static interface DecoratorFilter {
        public boolean accept(Decorator var1);
    }

    public static class PropertySelectionEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;
        private final transient ItemPropertyDescriptor property;
        private final transient Decorator decorator;
        private final transient String id;

        public PropertySelectionEvent(Decorator decorator, ItemPropertyDescriptor property, Object source, String id) {
            super(source);
            this.decorator = decorator;
            this.property = property;
            this.id = id;
        }

        public final Decorator getDecorator() {
            return this.decorator;
        }

        public final ItemPropertyDescriptor getProperty() {
            return this.property;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(this.decorator == null ? "null," : this.decorator.getDublinCore().getTitle());
            sb.append(this.property == null ? "null" : this.property.getDisplayName((Object)this.property));
            return sb.toString();
        }
    }

    public static interface PropertySelectionListener {
        public void propertySelected(PropertySelectionEvent var1);
    }

    public static interface PropertySieve {
        public List<ItemPropertyDescriptor> sieve(DynamicLabel var1);
    }
}

