/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ltk.core.refactoring.IValidationCheckResultQuery;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.ui.refactoring.Messages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.ui.refactoring.RefactoringUI;
import org.eclipse.swt.widgets.Shell;

public class ValidationCheckResultQuery
implements IValidationCheckResultQuery {
    private Shell fParent;
    private String fTitle;

    public ValidationCheckResultQuery(Shell parent, String title) {
        this.fParent = parent;
        this.fTitle = title;
    }

    public boolean proceed(RefactoringStatus status) {
        final Dialog dialog = RefactoringUI.createRefactoringStatusDialog(status, this.fParent, this.fTitle, false);
        final int[] result = new int[1];
        Runnable r = new Runnable(){

            public void run() {
                result[0] = dialog.open();
            }
        };
        this.fParent.getDisplay().syncExec(r);
        return result[0] == 0;
    }

    public void stopped(final RefactoringStatus status) {
        Runnable r = new Runnable(){

            public void run() {
                String message = status.getMessageMatchingSeverity(4);
                MessageDialog.openWarning((Shell)ValidationCheckResultQuery.this.fParent, (String)ValidationCheckResultQuery.this.fTitle, (String)ValidationCheckResultQuery.this.getFullMessage(message));
            }
        };
        this.fParent.getDisplay().syncExec(r);
    }

    private String getFullMessage(String errorMessage) {
        return Messages.format(RefactoringUIMessages.ValidationCheckResultQuery_error_message, errorMessage);
    }
}

