/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.core.scenario.ScenarioFactory;
import org.eclipse.stem.core.solver.Solver;
import org.eclipse.stem.core.solver.SolverPropertyComposite;
import org.eclipse.stem.ui.wizards.DublinCorePage;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.stem.ui.wizards.NewIdentifiablePage;
import org.eclipse.stem.ui.wizards.NewIdentifiableWizard;
import org.eclipse.stem.ui.wizards.STEMWizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewScenarioWizard
extends NewIdentifiableWizard {
    @Override
    protected String getWizardTitle() {
        return Messages.getString("NScenarioWiz.wizard_title");
    }

    @Override
    protected NewIdentifiablePage createNewIdentifiablePage() {
        this.setHelpContextId("org.eclipse.stem.doc.newscenario_contextid");
        return new NewScenarioPage();
    }

    @Override
    protected DublinCorePage createDublinCorePage() {
        return new DublinCorePage(){

            @Override
            protected void initializeDCAttributes() {
                super.initializeDCAttributes();
                this.format.setText("http:///org/eclipse/stem/core/scenario.ecore");
                this.format.setEnabled(false);
                this.type.setText(STEMURI.SCENARIO_TYPE_URI.toString());
                this.type.setEnabled(false);
                this.titleTextField.setText(Messages.getString("dc_title_scen"));
                this.source.setText(Messages.getString("dc_source_scen"));
                this.descriptionTextField.setText(Messages.getString("dc_desc_scen"));
            }
        };
    }

    @Override
    protected Identifiable createIdentifiable() {
        Scenario retValue = ScenarioFactory.eINSTANCE.createScenario();
        retValue.setDublinCore(this.newDublinCorePage.createDublinCore());
        return retValue;
    }

    @Override
    protected String getSerializationFolderName() {
        return "scenarios";
    }

    @Override
    protected String getSerializationFileNameExtension() {
        return "scenario";
    }

    protected static class NewScenarioPage
    extends NewIdentifiablePage {
        SolverPropertyComposite solverPC;

        protected NewScenarioPage() {
            super(Messages.getString("NScenarioWiz.page_title"));
            this.setTitle(Messages.getString("NScenarioWiz.page_title"));
            this.setDescription(Messages.getString("NScenarioWiz.page_description"));
        }

        @Override
        protected Composite createSpecificComposite(Composite parent) {
            Composite composite = new Composite(parent, 0);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.stem.doc.newscenario_contextid");
            return composite;
        }

        void displaySolver(Solver solver) {
            this.solverPC.displaySolver(solver);
        }

        @Override
        protected boolean validatePage() {
            boolean retValue = super.validatePage();
            return retValue;
        }
    }

    public static class NewScenarioWizardCommandHandler
    extends AbstractHandler
    implements IHandler {
        public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
            NewScenarioWizard wizard = new NewScenarioWizard();
            wizard.init(window.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
            STEMWizardDialog wizardDialog = new STEMWizardDialog(window.getShell(), (IWizard)wizard);
            wizardDialog.open();
            return null;
        }
    }
}

