/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.geographic.map;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import org.eclipse.stem.ui.Activator;
import org.eclipse.swt.graphics.Point;

public class StemPolygonTransform {
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double scale = 1.0;

    private Point2D getInversedPoint(java.awt.Point toInverse) {
        AffineTransform transform = new AffineTransform();
        transform.setToTranslation(this.offsetX, this.offsetY);
        transform.scale(this.scale, this.scale);
        Point2D toReturn = new Point2D.Double(0.0, 0.0);
        try {
            toReturn = transform.inverseTransform(toInverse, toReturn);
        }
        catch (NoninvertibleTransformException e) {
            Activator.logError("Problem inverting point " + toInverse, e);
            return new java.awt.Point();
        }
        return toReturn;
    }

    public Point getInversedPoint(int x, int y) {
        Point2D transformed = this.getInversedPoint(new java.awt.Point(x, y));
        return new Point((int)transformed.getX(), (int)transformed.getY());
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(double offsetX) {
        this.offsetX = offsetX;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(double offsetY) {
        this.offsetY = offsetY;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }
}

