/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.measles.presentation;

import java.util.MissingResourceException;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.stem.diseasemodels.measles.Measles;
import org.eclipse.stem.diseasemodels.measles.MeaslesPackage;
import org.eclipse.stem.diseasemodels.measles.presentation.MeaslesWizardMessages;
import org.eclipse.stem.diseasemodels.multipopulation.presentation.MultiPopulationDiseaseModelPropertyEditor;
import org.eclipse.stem.diseasemodels.multipopulation.presentation.MultiPopulationPropertyStringProviderAdapterFactory;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class MeaslesPropertyEditor
extends MultiPopulationDiseaseModelPropertyEditor {
    public MeaslesPropertyEditor(Composite parent, int style, DiseaseModel model, ModifyListener projectValidator, IProject project) {
        super(parent, style, model, projectValidator, project);
    }

    public void populate(DiseaseModel object) {
        super.populate(object);
        Measles model = (Measles)object;
        try {
            Double vaccineEfficacyValue = Double.parseDouble(((Text)this.map.get(MeaslesPackage.Literals.MEASLES__VACCINE_EFFICACY)).getText());
            model.setVaccineEfficacy(vaccineEfficacyValue);
        }
        catch (NumberFormatException vaccineEfficacyValue) {
            // empty catch block
        }
        try {
            Double inoculationScalingValue = Double.parseDouble(((Text)this.map.get(MeaslesPackage.Literals.MEASLES__INOCULATION_SCALING)).getText());
            model.setInoculationScaling(inoculationScalingValue);
        }
        catch (NumberFormatException inoculationScalingValue) {
            // empty catch block
        }
        try {
            Double phaseShiftValue = Double.parseDouble(((Text)this.map.get(MeaslesPackage.Literals.MEASLES__PHASE_SHIFT)).getText());
            model.setPhaseShift(phaseShiftValue);
        }
        catch (NumberFormatException phaseShiftValue) {
            // empty catch block
        }
        try {
            Double seasonalModulationValue = Double.parseDouble(((Text)this.map.get(MeaslesPackage.Literals.MEASLES__SEASONAL_MODULATION)).getText());
            model.setSeasonalModulation(seasonalModulationValue);
        }
        catch (NumberFormatException seasonalModulationValue) {
            // empty catch block
        }
        try {
            Long seasonalModulationPeriodValue = Long.parseLong(((Text)this.map.get(MeaslesPackage.Literals.MEASLES__SEASONAL_MODULATION_PERIOD)).getText());
            model.setSeasonalModulationPeriod(seasonalModulationPeriodValue);
        }
        catch (NumberFormatException seasonalModulationPeriodValue) {
            // empty catch block
        }
        try {
            Double inoculatedImmunityRateValue = Double.parseDouble(((Text)this.map.get(MeaslesPackage.Literals.MEASLES__INOCULATED_IMMUNITY_RATE)).getText());
            model.setInoculatedImmunityRate(inoculatedImmunityRateValue);
        }
        catch (NumberFormatException inoculatedImmunityRateValue) {
            // empty catch block
        }
        try {
            Double newbornImmunityLossRateValue = Double.parseDouble(((Text)this.map.get(MeaslesPackage.Literals.MEASLES__NEWBORN_IMMUNITY_LOSS_RATE)).getText());
            model.setNewbornImmunityLossRate(newbornImmunityLossRateValue);
        }
        catch (NumberFormatException newbornImmunityLossRateValue) {
            // empty catch block
        }
        try {
            Double transmissionRateScalingValue = Double.parseDouble(((Text)this.map.get(MeaslesPackage.Literals.MEASLES__TRANSMISSION_RATE_SCALING)).getText());
            model.setTransmissionRateScaling(transmissionRateScalingValue);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public boolean validate() {
        boolean valid = super.validate();
        valid = valid && this.validateFeatureConstraint((EStructuralFeature)MeaslesPackage.Literals.MEASLES__VACCINE_EFFICACY);
        valid = valid && this.validateFeatureConstraint((EStructuralFeature)MeaslesPackage.Literals.MEASLES__INOCULATION_SCALING);
        valid = valid && this.validateFeatureConstraint((EStructuralFeature)MeaslesPackage.Literals.MEASLES__PHASE_SHIFT);
        valid = valid && this.validateFeatureConstraint((EStructuralFeature)MeaslesPackage.Literals.MEASLES__SEASONAL_MODULATION);
        valid = valid && this.validateFeatureConstraint((EStructuralFeature)MeaslesPackage.Literals.MEASLES__SEASONAL_MODULATION_PERIOD);
        valid = valid && this.validateFeatureConstraint((EStructuralFeature)MeaslesPackage.Literals.MEASLES__INOCULATED_IMMUNITY_RATE);
        valid = valid && this.validateFeatureConstraint((EStructuralFeature)MeaslesPackage.Literals.MEASLES__NEWBORN_IMMUNITY_LOSS_RATE);
        valid = valid && this.validateFeatureConstraint((EStructuralFeature)MeaslesPackage.Literals.MEASLES__TRANSMISSION_RATE_SCALING);
        return valid;
    }

    public static class MeaslesPropertyStringProviderAdapter
    extends MultiPopulationPropertyStringProviderAdapterFactory.MultiPopulationPropertyStringProviderAdapter {
        public String getPropertyName(IItemPropertyDescriptor descriptor) {
            try {
                return MeaslesWizardMessages.getString(((EStructuralFeature)descriptor.getFeature(null)).getName(), "Measles");
            }
            catch (MissingResourceException e) {
                return super.getPropertyName(descriptor);
            }
        }

        public String getPropertyToolTip(IItemPropertyDescriptor descriptor) {
            try {
                EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
                return MeaslesWizardMessages.getString(String.valueOf(feature.getName()) + "TT", "Measles");
            }
            catch (MissingResourceException e) {
                return super.getPropertyToolTip(descriptor);
            }
        }

        public String getPropertyUnits(IItemPropertyDescriptor descriptor) {
            try {
                EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
                return MeaslesWizardMessages.getString(String.valueOf(feature.getName()) + "UNIT", "Measles");
            }
            catch (MissingResourceException e) {
                return super.getPropertyUnits(descriptor);
            }
        }

        public String getPropertyMissing(IItemPropertyDescriptor descriptor) {
            try {
                EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
                return MeaslesWizardMessages.getString(String.valueOf(feature.getName()) + "MISSING", "Measles");
            }
            catch (MissingResourceException e) {
                return super.getPropertyMissing(descriptor);
            }
        }

        public String getPropertyInvalid(IItemPropertyDescriptor descriptor) {
            try {
                EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
                return MeaslesWizardMessages.getString(String.valueOf(feature.getName()) + "INVALID", "Measles");
            }
            catch (MissingResourceException e) {
                return super.getPropertyInvalid(descriptor);
            }
        }
    }
}

