/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.internal.AttributeMarkerGrouping;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.IField;
import org.eclipse.ui.views.markers.internal.MarkerGroupingEntry;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerNode;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;
import org.eclipse.ui.views.markers.internal.TypeMarkerGroup;

public class MarkerGroup {
    private static MarkerGroupingEntry undefinedEntry = new MarkerGroupingEntry(MarkerMessages.FieldCategory_Uncategorized);
    protected IField field;
    protected MarkerField markerField;
    private Map<String, Set<EntryMapping>> typesToMappings = new LinkedHashMap<String, Set<EntryMapping>>();
    private IConfigurationElement configurationElement;
    private String id;

    public static MarkerGroup createMarkerGroup(IConfigurationElement element) {
        if (element.getAttribute("id").equals("org.eclipse.ui.ide.type")) {
            return new TypeMarkerGroup(element.getAttribute("label"));
        }
        return new MarkerGroup(element);
    }

    protected MarkerGroup(IConfigurationElement element) {
        this.configurationElement = element;
        if (element != null) {
            this.id = element.getAttribute("id");
        }
        this.createFields();
        this.processEntries();
    }

    private void processEntries() {
        if (this.configurationElement == null) {
            return;
        }
        IConfigurationElement[] markerEntryElements = this.configurationElement.getChildren("markerGroupingEntry");
        IConfigurationElement[] attributeGroupingElements = this.configurationElement.getChildren("markerAttributeGrouping");
        HashMap<String, MarkerGroupingEntry> idsToEntries = new HashMap<String, MarkerGroupingEntry>();
        IConfigurationElement[] iConfigurationElementArray = markerEntryElements;
        int n = markerEntryElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement markerEntryElement = iConfigurationElementArray[n2];
            MarkerGroupingEntry entry = new MarkerGroupingEntry(markerEntryElement);
            entry.setGroup(this);
            idsToEntries.put(entry.getId(), entry);
            ++n2;
        }
        iConfigurationElementArray = attributeGroupingElements;
        n = attributeGroupingElements.length;
        n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] mappings;
            IConfigurationElement attributeGroupingElement = iConfigurationElementArray[n2];
            AttributeMarkerGrouping attributeGrouping = new AttributeMarkerGrouping(attributeGroupingElement);
            String defaultEntryId = attributeGrouping.getDefaultGroupingEntry();
            if (defaultEntryId != null) {
                MarkerGroupingEntry entry = (MarkerGroupingEntry)idsToEntries.get(defaultEntryId);
                if (entry != null) {
                    entry.setAsDefault(attributeGrouping.getMarkerType());
                } else {
                    IDEWorkbenchPlugin.log(NLS.bind((String)"Reference to invalid markerGroupingEntry {0}", (Object)defaultEntryId));
                }
            }
            IConfigurationElement[] iConfigurationElementArray2 = mappings = attributeGrouping.getElement().getChildren("markerAttributeMapping");
            int n3 = mappings.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement mapping = iConfigurationElementArray2[n4];
                String entryId = mapping.getAttribute("markerGroupingEntry");
                MarkerGroupingEntry entry = (MarkerGroupingEntry)idsToEntries.get(entryId);
                if (entry != null) {
                    entry.getMarkerGroup().mapAttribute(attributeGrouping, entry, mapping.getAttribute("value"));
                } else {
                    IDEWorkbenchPlugin.log(NLS.bind((String)"Reference to invaild markerGroupingEntry {0}", (Object)defaultEntryId));
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected void createFields() {
        this.field = new FieldGroup(this);
        this.markerField = new GroupMarkerField();
    }

    private void addEntry(String markerType, EntryMapping entry) {
        MarkerType[] markerTypeArray = this.getMarkerTypes(markerType);
        int n = markerTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerType type = markerTypeArray[n2];
            Set<EntryMapping> entries = this.typesToMappings.get(markerType);
            if (entries == null) {
                entries = new LinkedHashSet<EntryMapping>();
            }
            entries.add(entry);
            this.typesToMappings.put(type.getId(), entries);
            ++n2;
        }
    }

    private MarkerGroupingEntry findGroupValue(ConcreteMarker concreteMarker) {
        String type = concreteMarker.getType();
        IMarker marker = concreteMarker.getMarker();
        return this.findGroupValue(type, marker);
    }

    public MarkerGroupingEntry findGroupValue(String type, IMarker marker) {
        Collection collection = this.typesToMappings.get(type);
        if (collection != null) {
            EntryMapping defaultMapping = null;
            for (EntryMapping mapping : collection) {
                if (mapping.hasAttributes()) {
                    MarkerGroupingEntry entry = mapping.testAttribute(marker);
                    if (entry == null) continue;
                    return entry;
                }
                defaultMapping = mapping;
            }
            if (defaultMapping != null) {
                return defaultMapping.groupingEntry;
            }
        }
        return undefinedEntry;
    }

    public IField getField() {
        return this.field;
    }

    public String getId() {
        return this.id;
    }

    private MarkerGroupingEntry getMapping(ConcreteMarker marker) {
        if (marker.getGroup() == null) {
            marker.setGroup(this.findGroupValue(marker));
        }
        return (MarkerGroupingEntry)marker.getGroup();
    }

    public MarkerField getMarkerField() {
        return this.markerField;
    }

    private MarkerType[] getMarkerTypes(String markerType) {
        MarkerTypesModel model = MarkerTypesModel.getInstance();
        LinkedHashSet<MarkerType> types = new LinkedHashSet<MarkerType>();
        MarkerType type = model.getType(markerType);
        if (type != null) {
            types.add(type);
            MarkerType[] markerTypeArray = type.getAllSubTypes();
            int n = markerTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                MarkerType sub = markerTypeArray[n2];
                types.add(sub);
                ++n2;
            }
        }
        if (types.isEmpty()) {
            return new MarkerType[0];
        }
        MarkerType[] typesArray = new MarkerType[types.size()];
        types.toArray(typesArray);
        return typesArray;
    }

    public String getTitle() {
        return this.configurationElement.getAttribute("label");
    }

    public void mapAttribute(AttributeMarkerGrouping attributeGrouping, MarkerGroupingEntry entry, String attributeValue) {
        this.addEntry(attributeGrouping.getMarkerType(), new AttributeMapping(entry, attributeGrouping.getAttribute(), attributeValue, attributeGrouping));
        attributeGrouping.addGroup(this);
    }

    public void remove(MarkerGroupingEntry entry) {
        Iterator<Set<EntryMapping>> entries = this.typesToMappings.values().iterator();
        ArrayList<EntryMapping> removeCollection = new ArrayList<EntryMapping>();
        while (entries.hasNext()) {
            Set<EntryMapping> mappings = entries.next();
            for (EntryMapping next : mappings) {
                if (!next.groupingEntry.equals(entry)) continue;
                removeCollection.add(next);
            }
            mappings.removeAll(removeCollection);
            removeCollection.clear();
        }
    }

    public void setAsDefault(String markerType, MarkerGroupingEntry entry) {
        this.addEntry(markerType, new EntryMapping(entry));
    }

    public void unmap(AttributeMarkerGrouping attributeMarkerGrouping) {
        String type = attributeMarkerGrouping.getMarkerType();
        ArrayList<EntryMapping> removed = new ArrayList<EntryMapping>();
        Collection entries = this.typesToMappings.get(type);
        for (EntryMapping mapping : entries) {
            if (!(mapping instanceof AttributeMapping) || ((AttributeMapping)mapping).grouping != attributeMarkerGrouping) continue;
            removed.add(mapping);
        }
        entries.removeAll(removed);
        if (entries.isEmpty()) {
            this.typesToMappings.remove(type);
        }
    }

    public Comparator<MarkerGroupingEntry> getEntriesComparator() {
        return (o1, o2) -> -(o1.getPriority() - o2.getPriority());
    }

    class AttributeMapping
    extends EntryMapping {
        String attribute;
        String attributeValue;
        AttributeMarkerGrouping grouping;

        AttributeMapping(MarkerGroupingEntry entry, String attributeName, String value, AttributeMarkerGrouping grouping) {
            super(entry);
            this.attribute = attributeName;
            this.attributeValue = value;
            this.grouping = grouping;
        }

        @Override
        public boolean hasAttributes() {
            return true;
        }

        @Override
        public MarkerGroupingEntry testAttribute(IMarker marker) {
            Object value;
            if (!marker.exists()) {
                return null;
            }
            try {
                value = marker.getAttribute(this.attribute);
            }
            catch (CoreException e) {
                Policy.handle(e);
                return null;
            }
            if (value != null && this.attributeValue.equals(value.toString())) {
                return this.groupingEntry;
            }
            return null;
        }
    }

    class EntryMapping {
        MarkerGroupingEntry groupingEntry;

        EntryMapping(MarkerGroupingEntry entry) {
            this.groupingEntry = entry;
        }

        public boolean hasAttributes() {
            return false;
        }

        public MarkerGroupingEntry testAttribute(IMarker marker) {
            return null;
        }
    }

    class FieldGroup
    implements IField {
        MarkerGroup markerGroup;
        private boolean showing;

        FieldGroup(MarkerGroup group) {
            this.markerGroup = group;
        }

        @Override
        public int compare(Object obj1, Object obj2) {
            MarkerGroupingEntry entry1 = MarkerGroup.this.getMapping(((MarkerNode)obj1).getConcreteRepresentative());
            MarkerGroupingEntry entry2 = MarkerGroup.this.getMapping(((MarkerNode)obj2).getConcreteRepresentative());
            return entry2.getPriority() - entry1.getPriority();
        }

        @Override
        public Image getColumnHeaderImage() {
            return null;
        }

        @Override
        public String getColumnHeaderText() {
            return this.markerGroup.getTitle();
        }

        @Override
        public int getDefaultDirection() {
            return 1;
        }

        @Override
        public String getDescription() {
            return this.markerGroup.getTitle();
        }

        @Override
        public Image getDescriptionImage() {
            return null;
        }

        @Override
        public Image getImage(Object obj) {
            return null;
        }

        @Override
        public int getPreferredWidth() {
            return 75;
        }

        @Override
        public String getValue(Object obj) {
            MarkerNode node = (MarkerNode)obj;
            if (node.isConcrete()) {
                MarkerGroupingEntry groupingEntry = this.markerGroup.getMapping((ConcreteMarker)node);
                return groupingEntry.getLabel();
            }
            return node.getDescription();
        }

        @Override
        public boolean isShowing() {
            return this.showing;
        }

        @Override
        public void setShowing(boolean showing) {
            this.showing = showing;
        }
    }

    class GroupMarkerField
    extends MarkerField {
        GroupMarkerField() {
        }

        @Override
        public String getValue(MarkerItem item) {
            return MarkerSupportInternalUtilities.getGroupValue(MarkerGroup.this, item);
        }

        @Override
        public int compare(MarkerItem item1, MarkerItem item2) {
            if (item1.getMarker() == null) {
                if (item2.getMarker() == null) {
                    return 0;
                }
                return 1;
            }
            if (item2.getMarker() == null) {
                return -1;
            }
            try {
                MarkerGroupingEntry groupValue2 = MarkerGroup.this.findGroupValue(item2.getMarker().getType(), item2.getMarker());
                MarkerGroupingEntry groupValue1 = MarkerGroup.this.findGroupValue(item1.getMarker().getType(), item1.getMarker());
                return groupValue2.getPriority() - groupValue1.getPriority();
            }
            catch (CoreException exception) {
                Policy.handle(exception);
                return 0;
            }
        }

        @Override
        public String getName() {
            return MarkerGroup.this.getTitle();
        }
    }
}

