/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.hierarchy;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import javax.inject.Provider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.findReferences.TargetURICollector;
import org.eclipse.xtext.findReferences.TargetURIs;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyBuilder;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyNodeLocationProvider;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors(value={AccessorType.PUBLIC_SETTER, AccessorType.PROTECTED_GETTER})
public abstract class AbstractHierarchyBuilder
implements IHierarchyBuilder {
    private IReferenceFinder.IResourceAccess resourceAccess;
    private IResourceDescriptions indexData;
    @Inject
    private IReferenceFinder referenceFinder;
    @Inject
    private TargetURICollector targetURICollector;
    @Inject
    private Provider<TargetURIs> targetURIProvider;
    @Inject
    private IHierarchyNodeLocationProvider hierarchyNodeLocationProvider;
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry;

    protected <R> R readOnly(URI objectURI, IUnitOfWork<R, EObject> work) {
        IUnitOfWork _function = resourceSet -> {
            EObject targetObject = resourceSet.getEObject(objectURI, true);
            return work.exec((Object)targetObject);
        };
        return (R)this.getResourceAccess().readOnly(objectURI, _function);
    }

    protected IEObjectDescription getDescription(URI objectURI) {
        IResourceDescription resourceDescription = this.getIndexData().getResourceDescription(objectURI.trimFragment());
        if (resourceDescription == null) {
            return null;
        }
        Functions.Function1 _function = it -> {
            URI _eObjectURI = it.getEObjectURI();
            return Objects.equal((Object)_eObjectURI, (Object)objectURI);
        };
        return (IEObjectDescription)IterableExtensions.findFirst((Iterable)resourceDescription.getExportedObjects(), (Functions.Function1)_function);
    }

    protected IEObjectDescription getDescription(EObject object) {
        if (object == null) {
            return null;
        }
        return (IEObjectDescription)IterableExtensions.head((Iterable)this.getIndexData().getExportedObjectsByObject(object));
    }

    protected boolean isAssignable(EClass superType, EClassifier type) {
        if (type instanceof EClass) {
            return EcoreUtil2.isAssignableFrom((EClass)superType, (EClass)((EClass)type));
        }
        return false;
    }

    @Pure
    protected IReferenceFinder.IResourceAccess getResourceAccess() {
        return this.resourceAccess;
    }

    public void setResourceAccess(IReferenceFinder.IResourceAccess resourceAccess) {
        this.resourceAccess = resourceAccess;
    }

    @Pure
    protected IResourceDescriptions getIndexData() {
        return this.indexData;
    }

    public void setIndexData(IResourceDescriptions indexData) {
        this.indexData = indexData;
    }

    @Pure
    protected IReferenceFinder getReferenceFinder() {
        return this.referenceFinder;
    }

    public void setReferenceFinder(IReferenceFinder referenceFinder) {
        this.referenceFinder = referenceFinder;
    }

    @Pure
    protected TargetURICollector getTargetURICollector() {
        return this.targetURICollector;
    }

    public void setTargetURICollector(TargetURICollector targetURICollector) {
        this.targetURICollector = targetURICollector;
    }

    @Pure
    protected Provider<TargetURIs> getTargetURIProvider() {
        return this.targetURIProvider;
    }

    public void setTargetURIProvider(Provider<TargetURIs> targetURIProvider) {
        this.targetURIProvider = targetURIProvider;
    }

    @Pure
    protected IHierarchyNodeLocationProvider getHierarchyNodeLocationProvider() {
        return this.hierarchyNodeLocationProvider;
    }

    public void setHierarchyNodeLocationProvider(IHierarchyNodeLocationProvider hierarchyNodeLocationProvider) {
        this.hierarchyNodeLocationProvider = hierarchyNodeLocationProvider;
    }

    @Pure
    protected IResourceServiceProvider.Registry getResourceServiceProviderRegistry() {
        return this.resourceServiceProviderRegistry;
    }

    public void setResourceServiceProviderRegistry(IResourceServiceProvider.Registry resourceServiceProviderRegistry) {
        this.resourceServiceProviderRegistry = resourceServiceProviderRegistry;
    }
}

