/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.pde.internal.ui.shared.target.StyledBundleLabelProvider;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class ArgumentsFromContainerSelectionDialog
extends TrayDialog {
    private CheckboxTreeViewer fTree;
    private Button fSelectAllButton;
    private Button fDeselectAllButton;
    private Map<ITargetLocation, Object[]> fAllArguments;
    private String[] fArguments;
    private ITargetDefinition fTarget;

    public ArgumentsFromContainerSelectionDialog(Shell shell, ITargetDefinition target) {
        super(shell);
        this.fTarget = target;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ArgumentsFromContainerSelectionDialog_0);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        ITargetLocation[] containers = this.fTarget.getTargetLocations();
        boolean foundArguments = false;
        if (containers != null) {
            this.fAllArguments = new HashMap<ITargetLocation, Object[]>(containers.length);
            ITargetLocation[] iTargetLocationArray = containers;
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation container = iTargetLocationArray[n2];
                String[] args = container.getVMArguments();
                if (args != null) {
                    if (args.length > 0) {
                        this.fAllArguments.put(container, args);
                        foundArguments = true;
                    } else {
                        this.fAllArguments.put(container, new Object[]{new Status(4, PDEPlugin.getPluginId(), Messages.ArgumentsFromContainerSelectionDialog_1)});
                    }
                }
                ++n2;
            }
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.pde.doc.user.import_arguments_dialog");
        Composite comp = SWTFactory.createComposite(parent, 1, 1, 1808, 10, 10);
        ((GridLayout)comp.getLayout()).verticalSpacing = 10;
        Label infoLabel = SWTFactory.createLabel(comp, Messages.ArgumentsFromContainerSelectionDialog_2, 1);
        Composite treeComp = SWTFactory.createComposite(comp, 2, 1, 1808, 0, 0);
        this.fTree = new CheckboxTreeViewer(treeComp, 2816);
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 300;
        this.fTree.getControl().setLayoutData((Object)gd);
        this.fTree.setLabelProvider((IBaseLabelProvider)new StyledBundleLabelProvider(true, false));
        this.fTree.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object element) {
                Object args;
                if (element instanceof ITargetLocation && (args = ArgumentsFromContainerSelectionDialog.this.fAllArguments.get(element)) != null) {
                    return (Object[])args;
                }
                return new Object[0];
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length > 0;
            }

            public Object[] getElements(Object element) {
                if (element instanceof Map) {
                    return ((Map)element).keySet().toArray();
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                return null;
            }
        });
        this.fTree.addCheckStateListener(event -> {
            this.updateCheckState(event.getElement());
            this.updateOKButton();
        });
        this.fTree.addDoubleClickListener(event -> {
            if (!event.getSelection().isEmpty()) {
                Object selected;
                this.fTree.setChecked(selected, !this.fTree.getChecked(selected = ((IStructuredSelection)event.getSelection()).getFirstElement()));
                this.updateCheckState(selected);
                this.updateOKButton();
            }
        });
        this.fTree.setAutoExpandLevel(-1);
        Composite buttonComp = SWTFactory.createComposite(treeComp, 1, 1, 1040, 0, 0);
        this.fSelectAllButton = SWTFactory.createPushButton(buttonComp, Messages.ArgumentsFromContainerSelectionDialog_3, null);
        this.fSelectAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.fTree.setAllChecked(true);
            this.updateOKButton();
        }));
        this.fDeselectAllButton = SWTFactory.createPushButton(buttonComp, Messages.ArgumentsFromContainerSelectionDialog_4, null);
        this.fDeselectAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.fTree.setAllChecked(false);
            this.updateOKButton();
        }));
        if (foundArguments) {
            this.fTree.setInput(this.fAllArguments);
        } else {
            this.fTree.getControl().setEnabled(false);
            this.fSelectAllButton.setEnabled(false);
            this.fDeselectAllButton.setEnabled(false);
            infoLabel.setText(Messages.ArgumentsFromContainerSelectionDialog_5);
        }
        return comp;
    }

    protected boolean isResizable() {
        return true;
    }

    private void updateCheckState(Object element) {
        if (element instanceof ITargetLocation) {
            this.fTree.setSubtreeChecked(element, this.fTree.getChecked(element));
        } else {
            TreeItem[] containers;
            TreeItem[] treeItemArray = containers = this.fTree.getTree().getItems();
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem container = treeItemArray[n2];
                TreeItem[] arguments = container.getItems();
                int checked = 0;
                TreeItem[] treeItemArray2 = arguments;
                int n3 = arguments.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreeItem argument = treeItemArray2[n4];
                    if (argument.getChecked()) {
                        ++checked;
                    }
                    ++n4;
                }
                if (checked == 0) {
                    container.setChecked(false);
                    container.setGrayed(false);
                } else if (arguments.length > checked) {
                    container.setChecked(true);
                    container.setGrayed(true);
                } else {
                    container.setChecked(true);
                    container.setGrayed(false);
                }
                ++n2;
            }
        }
    }

    private void updateOKButton() {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            Object[] checked;
            boolean ok = false;
            Object[] objectArray = checked = this.fTree.getCheckedElements();
            int n = checked.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof String) {
                    ok = true;
                    break;
                }
                ++n2;
            }
            okButton.setEnabled(ok);
        }
    }

    public String[] getSelectedArguments() {
        return this.fArguments;
    }

    protected void okPressed() {
        Object[] checked;
        ArrayList<String> arguments = new ArrayList<String>();
        Object[] objectArray = checked = this.fTree.getCheckedElements();
        int n = checked.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof String) {
                String arg = ((String)element).trim();
                if (arg.indexOf(32) > 0) {
                    arg = "\"" + arg + "\"";
                }
                arguments.add(arg);
            }
            ++n2;
        }
        this.fArguments = arguments.toArray(new String[arguments.size()]);
        super.okPressed();
    }
}

