/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.vector.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Exchange;
import org.eclipse.stem.core.graph.ExchangePool;
import org.eclipse.stem.core.graph.ExchangeType;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.LabelValue;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.Infector;
import org.eclipse.stem.diseasemodels.standard.SEIRLabel;
import org.eclipse.stem.diseasemodels.standard.SEIRLabelValue;
import org.eclipse.stem.diseasemodels.standard.SIInfector;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardFactory;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.vector.Activator;
import org.eclipse.stem.diseasemodels.vector.MacdonaldRossDiseaseModel;
import org.eclipse.stem.diseasemodels.vector.VectorPackage;
import org.eclipse.stem.diseasemodels.vector.impl.VectorDiseaseModelImpl;

public class MacdonaldRossDiseaseModelImpl
extends VectorDiseaseModelImpl
implements MacdonaldRossDiseaseModel {
    static final double MISSING_DATA = 99999.0;
    protected static final double BITING_RATE_EDEFAULT = 0.5;
    protected double bitingRate = 0.5;
    protected static final double INFECTIOUS_BITING_PROPORTION_HUMAN_EDEFAULT = 0.5;
    protected double infectiousBitingProportionHuman = 0.5;
    protected static final double INFECTIOUS_BITING_PROPORTION_VECTOR_EDEFAULT = 1.0;
    protected double infectiousBitingProportionVector = 1.0;
    protected static final double RECOVERY_RATE_EDEFAULT = 0.00333;
    protected double recoveryRate = 0.00333;
    protected static final double INCUBATION_RATE_EDEFAULT = 0.0625;
    protected double incubationRate = 0.0625;
    protected static final double VECTOR_INCUBATION_RATE_EDEFAULT = 0.1;
    protected double vectorIncubationRate = 0.1;
    protected static final double IMMUNITY_LOSS_RATE_EDEFAULT = 0.02;
    protected double immunityLossRate = 0.02;

    public Infector createInfector() {
        SIInfector retValue = StandardFactory.eINSTANCE.createSIInfector();
        retValue.setDiseaseName(this.getDiseaseName());
        retValue.setPopulationIdentifier(this.getPopulationIdentifier());
        return retValue;
    }

    public DiseaseModelLabelValue createDiseaseModelLabelValue(String populationIdentifier) {
        return StandardFactory.eINSTANCE.createSEIRLabelValue();
    }

    public DiseaseModelLabel createDiseaseModelLabel(String populationIdentifier) {
        return StandardFactory.eINSTANCE.createSEIRLabel();
    }

    @Override
    protected EClass eStaticClass() {
        return VectorPackage.Literals.MACDONALD_ROSS_DISEASE_MODEL;
    }

    @Override
    public double getBitingRate() {
        return this.bitingRate;
    }

    @Override
    public void setBitingRate(double newBitingRate) {
        this.bitingRate = newBitingRate;
    }

    @Override
    public double getInfectiousBitingProportionHuman() {
        return this.infectiousBitingProportionHuman;
    }

    @Override
    public void setInfectiousBitingProportionHuman(double newInfectiousBitingProportionHuman) {
        this.infectiousBitingProportionHuman = newInfectiousBitingProportionHuman;
    }

    @Override
    public double getInfectiousBitingProportionVector() {
        return this.infectiousBitingProportionVector;
    }

    @Override
    public void setInfectiousBitingProportionVector(double newInfectiousBitingProportionVector) {
        this.infectiousBitingProportionVector = newInfectiousBitingProportionVector;
    }

    @Override
    public double getRecoveryRate() {
        return this.recoveryRate;
    }

    @Override
    public void setRecoveryRate(double newRecoveryRate) {
        this.recoveryRate = newRecoveryRate;
    }

    @Override
    public double getIncubationRate() {
        return this.incubationRate;
    }

    @Override
    public void setIncubationRate(double newIncubationRate) {
        this.incubationRate = newIncubationRate;
    }

    @Override
    public double getVectorIncubationRate() {
        return this.vectorIncubationRate;
    }

    @Override
    public void setVectorIncubationRate(double newVectorIncubationRate) {
        this.vectorIncubationRate = newVectorIncubationRate;
    }

    @Override
    public double getImmunityLossRate() {
        return this.immunityLossRate;
    }

    @Override
    public void setImmunityLossRate(double newImmunityLossRate) {
        this.immunityLossRate = newImmunityLossRate;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 20: {
                return this.getBitingRate();
            }
            case 21: {
                return this.getInfectiousBitingProportionHuman();
            }
            case 22: {
                return this.getInfectiousBitingProportionVector();
            }
            case 23: {
                return this.getRecoveryRate();
            }
            case 24: {
                return this.getIncubationRate();
            }
            case 25: {
                return this.getVectorIncubationRate();
            }
            case 26: {
                return this.getImmunityLossRate();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 20: {
                this.setBitingRate((Double)newValue);
                return;
            }
            case 21: {
                this.setInfectiousBitingProportionHuman((Double)newValue);
                return;
            }
            case 22: {
                this.setInfectiousBitingProportionVector((Double)newValue);
                return;
            }
            case 23: {
                this.setRecoveryRate((Double)newValue);
                return;
            }
            case 24: {
                this.setIncubationRate((Double)newValue);
                return;
            }
            case 25: {
                this.setVectorIncubationRate((Double)newValue);
                return;
            }
            case 26: {
                this.setImmunityLossRate((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 20: {
                this.setBitingRate(0.5);
                return;
            }
            case 21: {
                this.setInfectiousBitingProportionHuman(0.5);
                return;
            }
            case 22: {
                this.setInfectiousBitingProportionVector(1.0);
                return;
            }
            case 23: {
                this.setRecoveryRate(0.00333);
                return;
            }
            case 24: {
                this.setIncubationRate(0.0625);
                return;
            }
            case 25: {
                this.setVectorIncubationRate(0.1);
                return;
            }
            case 26: {
                this.setImmunityLossRate(0.02);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 20: {
                return this.bitingRate != 0.5;
            }
            case 21: {
                return this.infectiousBitingProportionHuman != 0.5;
            }
            case 22: {
                return this.infectiousBitingProportionVector != 1.0;
            }
            case 23: {
                return this.recoveryRate != 0.00333;
            }
            case 24: {
                return this.incubationRate != 0.0625;
            }
            case 25: {
                return this.vectorIncubationRate != 0.1;
            }
            case 26: {
                return this.immunityLossRate != 0.02;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (bitingRate: ");
        result.append(this.bitingRate);
        result.append(", infectiousBitingProportionHuman: ");
        result.append(this.infectiousBitingProportionHuman);
        result.append(", infectiousBitingProportionVector: ");
        result.append(this.infectiousBitingProportionVector);
        result.append(", recoveryRate: ");
        result.append(this.recoveryRate);
        result.append(", incubationRate: ");
        result.append(this.incubationRate);
        result.append(", vectorIncubationRate: ");
        result.append(this.vectorIncubationRate);
        result.append(", immunityLossRate: ");
        result.append(this.immunityLossRate);
        result.append(')');
        return result.toString();
    }

    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        double adjustedRecoveryRate = this.getRecoveryRate() * ((double)timeDelta / (double)this.getTimePeriod());
        double adjustedBitingRate = this.getBitingRate() * ((double)timeDelta / (double)this.getTimePeriod());
        double adjustedIncubationRate = this.getIncubationRate() * ((double)timeDelta / (double)this.getTimePeriod());
        double adjustedImmunityLossRate = this.getImmunityLossRate() * ((double)timeDelta / (double)this.getTimePeriod());
        double adjustedVectorIncubationRate = this.getVectorIncubationRate() * ((double)timeDelta / (double)this.getTimePeriod());
        int i = 0;
        while (i < labels.size()) {
            DynamicLabel label = (DynamicLabel)labels.get(i);
            IntegrationLabel ilabel = (IntegrationLabel)label;
            StandardDiseaseModelLabel diseaseLabel = (StandardDiseaseModelLabel)ilabel;
            StandardDiseaseModelLabelValue currentState = (StandardDiseaseModelLabelValue)ilabel.getProbeValue();
            StandardDiseaseModelLabelValue deltaValue = (StandardDiseaseModelLabelValue)ilabel.getDeltaValue();
            deltaValue.reset();
            String popIdentifier = diseaseLabel.getPopulationModelLabel().getPopulationIdentifier();
            diseaseLabel.getNode();
            if (popIdentifier.equals(this.getPopulationIdentifier())) {
                SEIRLabelValue seirVal = (SEIRLabelValue)currentState;
                double totalHumanPop = seirVal.getPopulationCount();
                SEIRLabel vecPop = this.findDiseaseLabel(diseaseLabel.getNode(), this.getVectorPopulationIdentifier());
                if (vecPop == null) {
                    Activator.logError("Unable to find disease label for " + this.getVectorPopulationIdentifier() + " on node " + diseaseLabel.getNode(), new Exception());
                    return;
                }
                SEIRLabelValue vectorValue = (SEIRLabelValue)vecPop.getProbeValue();
                double totalVectorPop = vectorValue.getPopulationCount();
                double absIChange = 0.0;
                double absEChange = 0.0;
                double absSChange = 0.0;
                double absRChange = 0.0;
                double numberOfSusceptibleToExposed = 0.0;
                double numberOfExposedToInfectious = 0.0;
                double numberOfInfectedToRecovered = 0.0;
                double numberOfRecoveredToSusceptible = 0.0;
                double incidence = 0.0;
                if (totalHumanPop > 0.0) {
                    double dydt = 0.0;
                    if (totalVectorPop > 0.0) {
                        dydt = adjustedBitingRate * this.getInfectiousBitingProportionHuman() * totalVectorPop / totalHumanPop * (vectorValue.getI() / totalVectorPop) * seirVal.getS() / totalHumanPop;
                    }
                    double d = dydt = Double.isNaN(dydt) ? 0.0 : dydt;
                    if (dydt > 1.0) {
                        dydt = 1.0;
                    }
                    if (dydt < -1.0) {
                        dydt = -1.0;
                    }
                    double fracSChange = -dydt + adjustedImmunityLossRate * seirVal.getR() / totalHumanPop;
                    double fracEChange = dydt - adjustedIncubationRate * seirVal.getE() / totalHumanPop;
                    double fracIChange = adjustedIncubationRate * seirVal.getE() / totalHumanPop - adjustedRecoveryRate * seirVal.getI() / totalHumanPop;
                    double fracRChange = adjustedRecoveryRate * seirVal.getI() / totalHumanPop - adjustedImmunityLossRate * seirVal.getR() / totalHumanPop;
                    absIChange = fracIChange * totalHumanPop;
                    absSChange = fracSChange * totalHumanPop;
                    absEChange = fracEChange * totalHumanPop;
                    absRChange = fracRChange * totalHumanPop;
                    numberOfSusceptibleToExposed = incidence = dydt * totalHumanPop;
                    numberOfExposedToInfectious = adjustedIncubationRate * seirVal.getE();
                    numberOfInfectedToRecovered = adjustedRecoveryRate * seirVal.getI();
                    numberOfRecoveredToSusceptible = adjustedImmunityLossRate * seirVal.getR();
                }
                Exchange seExchange = (Exchange)ExchangePool.POOL.get();
                seExchange.setSource(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
                seExchange.setTarget(StandardPackage.eINSTANCE.getSEIRLabelValue_E());
                seExchange.setCount(numberOfSusceptibleToExposed);
                seExchange.getForIncidence().add((Object)StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_Incidence());
                seExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)seExchange);
                Exchange eiExchange = (Exchange)ExchangePool.POOL.get();
                eiExchange.setSource(StandardPackage.eINSTANCE.getSEIRLabelValue_E());
                eiExchange.setTarget(StandardPackage.eINSTANCE.getSILabelValue_I());
                eiExchange.setCount(numberOfExposedToInfectious);
                eiExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)eiExchange);
                Exchange irExchange = (Exchange)ExchangePool.POOL.get();
                irExchange.setSource(StandardPackage.eINSTANCE.getSILabelValue_I());
                irExchange.setTarget(StandardPackage.eINSTANCE.getSIRLabelValue_R());
                irExchange.setCount(numberOfInfectedToRecovered);
                irExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)irExchange);
                Exchange rsExchange = (Exchange)ExchangePool.POOL.get();
                rsExchange.setSource(StandardPackage.eINSTANCE.getSIRLabelValue_R());
                rsExchange.setTarget(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
                rsExchange.setCount(numberOfRecoveredToSusceptible);
                rsExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)rsExchange);
                SEIRLabelValue retV = (SEIRLabelValue)deltaValue;
                retV.setI(absIChange);
                retV.setS(absSChange);
                retV.setE(absEChange);
                retV.setR(absRChange);
                retV.setIncidence(incidence);
            } else if (popIdentifier.equals(this.getVectorPopulationIdentifier())) {
                SEIRLabelValue vectorVal = (SEIRLabelValue)currentState;
                double totalVectorPop = vectorVal.getPopulationCount();
                double absIChange = 0.0;
                double absEChange = 0.0;
                double absSChange = 0.0;
                double numberOfSusceptibleToExposed = 0.0;
                double numberOfExposedToInfectious = 0.0;
                if (totalVectorPop > 0.0) {
                    SEIRLabel humanPop = this.findDiseaseLabel(diseaseLabel.getNode(), this.getPopulationIdentifier());
                    if (humanPop == null) {
                        Activator.logError("Unable to find disease label for " + this.getPopulationIdentifier() + " on node " + diseaseLabel.getNode(), new Exception());
                        return;
                    }
                    SEIRLabelValue seirVal = (SEIRLabelValue)humanPop.getTempValue();
                    adjustedVectorIncubationRate = this.getVectorIncubationRate() * ((double)timeDelta / (double)this.getTimePeriod());
                    double effectiveInfectiousHuman = this.getNormalizedEffectiveInfectious(humanPop.getNode(), (StandardDiseaseModelLabel)humanPop, seirVal.getI(), StandardPackage.Literals.SI_LABEL_VALUE__I, StandardPackage.Literals.STANDARD_DISEASE_MODEL__CHARACTERISTIC_MIXING_DISTANCE, StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION);
                    double fracSChange = -adjustedBitingRate * this.getInfectiousBitingProportionVector() * effectiveInfectiousHuman * (vectorVal.getS() / totalVectorPop);
                    double fracEChange = -fracSChange - adjustedVectorIncubationRate * vectorVal.getE() / totalVectorPop;
                    double fracIChange = adjustedVectorIncubationRate * vectorVal.getE() / totalVectorPop;
                    absIChange = fracIChange * totalVectorPop;
                    absEChange = fracEChange * totalVectorPop;
                    absSChange = fracSChange * totalVectorPop;
                    numberOfSusceptibleToExposed = -absSChange;
                    numberOfExposedToInfectious = adjustedIncubationRate * vectorVal.getE();
                }
                Exchange seExchange = (Exchange)ExchangePool.POOL.get();
                seExchange.setSource(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
                seExchange.setTarget(StandardPackage.eINSTANCE.getSEIRLabelValue_E());
                seExchange.setCount(numberOfSusceptibleToExposed);
                seExchange.getForIncidence().add((Object)StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_Incidence());
                seExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)seExchange);
                Exchange eiExchange = (Exchange)ExchangePool.POOL.get();
                eiExchange.setSource(StandardPackage.eINSTANCE.getSEIRLabelValue_E());
                eiExchange.setTarget(StandardPackage.eINSTANCE.getSILabelValue_I());
                eiExchange.setCount(numberOfExposedToInfectious);
                eiExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)eiExchange);
                SEIRLabelValue retV = (SEIRLabelValue)deltaValue;
                retV.setI(absIChange);
                retV.setS(absSChange);
                retV.setE(absEChange);
                retV.setR(0.0);
                retV.setIncidence(-absSChange);
            } else {
                Activator.logError("Cannot determine what to do with " + popIdentifier + " on node " + diseaseLabel.getNode(), new Exception());
            }
            this.computeAdditionalDeltasAndExchanges(ilabel, time, t, timeDelta);
            ++i;
        }
    }

    public void doModelSpecificAdjustments(LabelValue label) {
    }

    public void applyExternalDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        super.applyExternalDeltas(time, t, timeDelta, labels);
    }

    public void doStochasticProcess(IntegrationLabel label, long timeDelta) {
        super.doStochasticProcess(label, timeDelta);
    }

    SEIRLabel findDiseaseLabel(Node n, String identifier) {
        for (NodeLabel nl : n.getLabels()) {
            if (!(nl instanceof SEIRLabel) || !((DiseaseModelLabel)nl).getPopulationModelLabel().getPopulationIdentifier().equals(identifier)) continue;
            return (SEIRLabel)nl;
        }
        return null;
    }
}

