/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.graphsynchronizer;

import java.util.ArrayList;
import org.eclipse.stem.graphsynchronizer.Activator;
import org.eclipse.stem.graphsynchronizer.impl.SimulationGraphSynchronizer;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListenerSync;
import org.eclipse.stem.jobs.simulation.ISimulationManagerListenerSync;
import org.eclipse.stem.jobs.simulation.SimulationManagerEvent;

public class SimulationManagerDelegate
implements ISimulationManagerListenerSync {
    private ArrayList<SimulationGraphSynchronizer> synchronizers = new ArrayList();

    public void simulationsChangedSync(SimulationManagerEvent event) {
        Activator.logInformation("Simulation Changed " + event);
        ISimulation[] simsAdded = event.getSimulationsAdded();
        ISimulation[] simsRemoved = event.getSimulationsRemoved();
        if (simsAdded != null && simsAdded.length > 0) {
            int i = 0;
            while (i < simsAdded.length) {
                SimulationGraphSynchronizer newSync = new SimulationGraphSynchronizer(simsAdded[i]);
                this.synchronizers.add(newSync);
                simsAdded[i].addSimulationListenerSync((ISimulationListenerSync)newSync, true);
                ++i;
            }
        }
        ArrayList<SimulationGraphSynchronizer> remove = new ArrayList<SimulationGraphSynchronizer>();
        if (simsRemoved != null && simsRemoved.length > 0) {
            int i = 0;
            while (i < simsRemoved.length) {
                int j = 0;
                while (j < this.synchronizers.size()) {
                    if (this.synchronizers.get(j).getSimulation().equals(simsRemoved[i])) {
                        remove.add(this.synchronizers.get(j));
                        simsRemoved[i].removeSimulationListenerSync((ISimulationListenerSync)this.synchronizers.get(j));
                    }
                    ++j;
                }
                ++i;
            }
            for (SimulationGraphSynchronizer sgs : remove) {
                this.synchronizers.remove(sgs);
            }
        }
    }
}

