/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor;

import com.google.common.collect.Lists;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.xtext.ui.editor.IXtextEditorCallback;
import org.eclipse.xtext.ui.editor.XtextEditor;

public class CompoundXtextEditorCallback
implements IXtextEditorCallback {
    private List<IXtextEditorCallback> editorCallbacks = Lists.newArrayList();
    private Logger log = Logger.getLogger(CompoundXtextEditorCallback.class);

    protected void handle(Exception e) {
        this.log.error((Object)e.getMessage(), (Throwable)e);
    }

    @Inject
    public CompoundXtextEditorCallback(Injector injector) {
        ArrayList bindingsByType = injector == null ? Lists.newArrayList() : injector.findBindingsByType(TypeLiteral.get(IXtextEditorCallback.class));
        for (Binding binding : bindingsByType) {
            try {
                this.editorCallbacks.add((IXtextEditorCallback)binding.getProvider().get());
            }
            catch (Exception e) {
                this.handle(e);
            }
        }
    }

    @Override
    public void afterCreatePartControl(XtextEditor xtextEditor) {
        for (IXtextEditorCallback xtextEditorCallback : this.editorCallbacks) {
            try {
                xtextEditorCallback.afterCreatePartControl(xtextEditor);
            }
            catch (Exception e) {
                this.handle(e);
            }
        }
    }

    @Override
    public void afterSave(XtextEditor xtextEditor) {
        for (IXtextEditorCallback xtextEditorCallback : this.editorCallbacks) {
            try {
                xtextEditorCallback.afterSave(xtextEditor);
            }
            catch (Exception e) {
                this.handle(e);
            }
        }
    }

    @Override
    public void beforeDispose(XtextEditor xtextEditor) {
        for (IXtextEditorCallback xtextEditorCallback : this.editorCallbacks) {
            try {
                xtextEditorCallback.beforeDispose(xtextEditor);
            }
            catch (Exception e) {
                this.handle(e);
            }
        }
    }

    @Override
    public boolean onValidateEditorInputState(XtextEditor xtextEditor) {
        for (IXtextEditorCallback xtextEditorCallback : this.editorCallbacks) {
            try {
                if (xtextEditorCallback.onValidateEditorInputState(xtextEditor)) continue;
                return false;
            }
            catch (Exception e) {
                this.handle(e);
            }
        }
        return true;
    }

    @Override
    public void beforeSetInput(XtextEditor xtextEditor) {
        int i = this.editorCallbacks.size() - 1;
        while (i >= 0) {
            try {
                this.editorCallbacks.get(i).beforeSetInput(xtextEditor);
            }
            catch (Exception e) {
                this.handle(e);
            }
            --i;
        }
    }

    @Override
    public void afterSetInput(XtextEditor xtextEditor) {
        for (IXtextEditorCallback xtextEditorCallback : this.editorCallbacks) {
            try {
                xtextEditorCallback.afterSetInput(xtextEditor);
            }
            catch (Exception e) {
                this.handle(e);
            }
        }
    }
}

