/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.jobs;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.sphinx.platform.internal.Activator;
import org.eclipse.sphinx.platform.operations.ILabeledWorkspaceRunnable;
import org.eclipse.sphinx.platform.util.StatusUtil;

public class WorkspaceOperationJob
extends Job {
    protected ILabeledWorkspaceRunnable operation;

    public WorkspaceOperationJob(ILabeledWorkspaceRunnable operation) {
        super(operation.getLabel());
        Assert.isNotNull((Object)operation);
        this.operation = operation;
        this.setPriority(40);
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.operation.run(monitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        catch (CoreException ex) {
            return ex.getStatus();
        }
        catch (Exception ex) {
            return StatusUtil.createErrorStatus(Activator.getDefault(), (Object)ex);
        }
        return Status.OK_STATUS;
    }
}

