/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.check;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.check.Check;
import org.eclipse.sphinx.emf.check.CompositeValidator;
import org.eclipse.sphinx.emf.check.ICheckValidator;
import org.eclipse.sphinx.emf.check.catalog.Catalog;
import org.eclipse.sphinx.emf.check.internal.Activator;
import org.eclipse.sphinx.emf.check.internal.CheckValidatorDescriptor;
import org.eclipse.sphinx.emf.check.internal.EPackageMappings;
import org.eclipse.sphinx.emf.check.util.CheckUtil;
import org.eclipse.sphinx.emf.util.EObjectUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.sphinx.platform.util.StatusUtil;

public class CheckValidatorRegistry {
    private static final String EXTP_CHECK_VALIDATORS = "org.eclipse.sphinx.emf.check.checkvalidators";
    private static final String NODE_VALIDATOR = "validator";
    private static final String NODE_EPACKAGE_MAPPING = "ePackageMapping";
    private static final String ATTR_EOBJECT_WRAPPER_PACKAGE_NAME = "eObjectWrapperPackageName";
    private static final String ATTR_EPACKAGE_NS_URI = "ePackageNsURI";
    public static final CheckValidatorRegistry INSTANCE = new CheckValidatorRegistry(Platform.getExtensionRegistry(), EValidator.Registry.INSTANCE, PlatformLogUtil.getLog((Plugin)Activator.getPlugin()));
    protected Map<ICheckValidator, URI> checkValidatorToCheckCatalogURIMap = null;
    protected Map<URI, Set<ICheckValidator>> checkCatalogURIToCheckValidatorsMap = null;
    protected Map<URI, Catalog> uriToCheckCatalogMap = new HashMap<URI, Catalog>();
    protected IExtensionRegistry extensionRegistry;
    protected EValidator.Registry eValidatorRegistry;
    private ILog logger;

    protected CheckValidatorRegistry(IExtensionRegistry extensionRegistry, EValidator.Registry eValidatorRegistry, ILog logger) {
        Assert.isNotNull((Object)extensionRegistry);
        Assert.isNotNull((Object)eValidatorRegistry);
        Assert.isNotNull((Object)logger);
        this.extensionRegistry = extensionRegistry;
        this.eValidatorRegistry = eValidatorRegistry;
        this.logger = logger;
    }

    private EValidator.Registry getEValidatorRegistry() {
        this.initialize();
        return this.eValidatorRegistry;
    }

    private Map<ICheckValidator, URI> getCheckValidatorToCheckCatalogURIMap() {
        this.initialize();
        return this.checkValidatorToCheckCatalogURIMap != null ? this.checkValidatorToCheckCatalogURIMap : Collections.emptyMap();
    }

    private Map<URI, Set<ICheckValidator>> getCheckCatalogURIToCheckValidatorsMap() {
        this.initialize();
        return this.checkCatalogURIToCheckValidatorsMap != null ? this.checkCatalogURIToCheckValidatorsMap : Collections.emptyMap();
    }

    private void initialize() {
        if (this.extensionRegistry == null) {
            return;
        }
        if (this.checkValidatorToCheckCatalogURIMap == null || this.checkCatalogURIToCheckValidatorsMap == null) {
            this.checkValidatorToCheckCatalogURIMap = new HashMap<ICheckValidator, URI>();
            this.checkCatalogURIToCheckValidatorsMap = new HashMap<URI, Set<ICheckValidator>>();
            HashMap<String, CheckValidatorDescriptor> checkValidatorClassNameToCheckValidatorDescriptorMap = new HashMap<String, CheckValidatorDescriptor>();
            EPackageMappings ePackageMappings = new EPackageMappings();
            IConfigurationElement[] iConfigurationElementArray = this.extensionRegistry.getConfigurationElementsFor(EXTP_CHECK_VALIDATORS);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement checkValidatorConfigurationElement = iConfigurationElementArray[n2];
                try {
                    if (NODE_VALIDATOR.equals(checkValidatorConfigurationElement.getName())) {
                        CheckValidatorDescriptor checkValidatorDescriptor = new CheckValidatorDescriptor(checkValidatorConfigurationElement);
                        String checkValidatorClassName = checkValidatorDescriptor.getClassName();
                        if (checkValidatorClassNameToCheckValidatorDescriptorMap.containsKey(checkValidatorClassName)) {
                            this.logWarning("Duplicate validator contribution found for: " + checkValidatorClassName, new Object[0]);
                        } else {
                            checkValidatorClassNameToCheckValidatorDescriptorMap.put(checkValidatorClassName, checkValidatorDescriptor);
                        }
                    } else if (NODE_EPACKAGE_MAPPING.equals(checkValidatorConfigurationElement.getName())) {
                        String javaPackageName = checkValidatorConfigurationElement.getAttribute(ATTR_EOBJECT_WRAPPER_PACKAGE_NAME);
                        String ePackageNsURI = checkValidatorConfigurationElement.getAttribute(ATTR_EPACKAGE_NS_URI);
                        Iterator<EPackage> ePackageObject = EPackage.Registry.INSTANCE.get((Object)ePackageNsURI);
                        if (ePackageObject == null) {
                            this.logError("Unable to find EPackage for ", ePackageNsURI);
                        }
                        ePackageMappings.put(javaPackageName, ePackageObject);
                    }
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
                ++n2;
            }
            for (CheckValidatorDescriptor checkValidatorDescriptor : checkValidatorClassNameToCheckValidatorDescriptorMap.values()) {
                try {
                    ICheckValidator validator = (ICheckValidator)checkValidatorDescriptor.newInstance();
                    Set<Class<?>> classesUnderCheck = this.findClassesUnderCheck(validator.getClass());
                    Set<EPackage> affectedEPackages = this.findAffectedEPackages(classesUnderCheck, ePackageMappings);
                    for (EPackage affectedEPackage : affectedEPackages) {
                        this.addValidator(affectedEPackage, validator);
                    }
                    URI catalogURI = checkValidatorDescriptor.getCatalogURI();
                    this.checkValidatorToCheckCatalogURIMap.put(validator, catalogURI);
                    if (catalogURI == null) continue;
                    Set<ICheckValidator> checkValidators = this.checkCatalogURIToCheckValidatorsMap.get(catalogURI);
                    if (checkValidators == null) {
                        checkValidators = new HashSet<ICheckValidator>();
                        this.checkCatalogURIToCheckValidatorsMap.put(catalogURI, checkValidators);
                    }
                    checkValidators.add(validator);
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
            }
            checkValidatorClassNameToCheckValidatorDescriptorMap.clear();
            ePackageMappings.clear();
        }
    }

    private Set<Class<?>> findClassesUnderCheck(Class<? extends ICheckValidator> validatorClass) {
        Assert.isNotNull(validatorClass);
        HashSet classesUnderCheck = new HashSet();
        Collection<Method> methods = CheckUtil.getDeclaredCheckMethods(validatorClass);
        for (Method method : methods) {
            Annotation[] annotations;
            Annotation[] annotationArray = annotations = method.getAnnotations();
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?>[] parameterTypes;
                Annotation annotation = annotationArray[n2];
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (annotationType.equals(Check.class) && (parameterTypes = method.getParameterTypes()).length > 0) {
                    classesUnderCheck.add(parameterTypes[0]);
                }
                ++n2;
            }
        }
        return classesUnderCheck;
    }

    private Set<EPackage> findAffectedEPackages(Set<Class<?>> classesUnderCheck, EPackageMappings ePackageMappings) {
        Assert.isNotNull(classesUnderCheck);
        HashSet<EPackage> affectedEPackages = new HashSet<EPackage>();
        for (Class<?> classUnderCheck : classesUnderCheck) {
            EPackage ePackage = this.findAffectedEPackage(classUnderCheck, ePackageMappings);
            if (ePackage == null) {
                this.logError("Unable to find EPackage for ", classUnderCheck.getName());
                continue;
            }
            affectedEPackages.add(ePackage);
        }
        return affectedEPackages;
    }

    private EPackage findAffectedEPackage(Class<?> classUnderCheck, EPackageMappings ePackageMappings) {
        Assert.isNotNull((Object)ePackageMappings);
        EPackage ePackage = ePackageMappings.getEPackageFor(classUnderCheck);
        if (ePackage != null) {
            return ePackage;
        }
        ePackage = EObjectUtil.findEPackage(classUnderCheck);
        if (ePackage != null) {
            ePackageMappings.put(classUnderCheck.getName(), ePackage);
        }
        return ePackage;
    }

    public void addValidator(EPackage ePackage, EValidator validator) {
        EValidator existingValidator = this.eValidatorRegistry.getEValidator(ePackage);
        if (existingValidator == null) {
            this.eValidatorRegistry.put((Object)ePackage, (Object)validator);
        } else if (existingValidator instanceof CompositeValidator) {
            ((CompositeValidator)existingValidator).addChild(validator);
        } else {
            CompositeValidator compositeValidator = new CompositeValidator();
            compositeValidator.addChild(existingValidator);
            compositeValidator.addChild(validator);
            this.eValidatorRegistry.put((Object)ePackage, (Object)compositeValidator);
        }
    }

    public EValidator getValidator(EPackage ePackage) {
        EValidator eValidator = this.getEValidatorRegistry().getEValidator(ePackage);
        if (eValidator instanceof ICheckValidator || eValidator instanceof CompositeValidator) {
            return eValidator;
        }
        return null;
    }

    public URI getCheckCatalogURI(ICheckValidator checkValidator) {
        return this.getCheckValidatorToCheckCatalogURIMap().get(checkValidator);
    }

    public Catalog getCheckCatalog(ICheckValidator checkValidator) {
        URI checkCatalogURI = this.getCheckCatalogURI(checkValidator);
        if (checkCatalogURI != null) {
            return this.loadCheckCatalog(checkCatalogURI);
        }
        return null;
    }

    private Catalog loadCheckCatalog(URI checkCatalogURI) {
        Catalog catalog = this.uriToCheckCatalogMap.get(checkCatalogURI);
        if (catalog == null) {
            EObject eObject = EcoreResourceUtil.loadEObject(null, (URI)checkCatalogURI.appendFragment("/"));
            if (!(eObject instanceof Catalog)) {
                throw new IllegalStateException("Unable to find the check catalog for URI '" + checkCatalogURI + "'");
            }
            catalog = (Catalog)eObject;
            this.uriToCheckCatalogMap.put(checkCatalogURI, catalog);
        }
        return catalog;
    }

    public Collection<Catalog> getCheckCatalogs() {
        Set<URI> allCalalogURIs = this.getCheckCatalogURIToCheckValidatorsMap().keySet();
        for (URI uri : allCalalogURIs) {
            if (this.uriToCheckCatalogMap.get(uri) != null) continue;
            this.loadCheckCatalog(uri);
        }
        return this.uriToCheckCatalogMap.values();
    }

    public Collection<ICheckValidator> getCheckValidators() {
        return this.getCheckValidatorToCheckCatalogURIMap().keySet();
    }

    private void logWarning(String msgId, Object ... objects) {
        this.logWarning(new RuntimeException(NLS.bind((String)msgId, (Object[])objects)));
    }

    private void logWarning(Throwable throwable) {
        this.logger.log(StatusUtil.createWarningStatus((Plugin)Activator.getDefault(), (Object)throwable));
    }

    private void logError(String msgId, Object ... objects) {
        this.logError(new RuntimeException(NLS.bind((String)msgId, (Object[])objects)));
    }

    private void logError(Throwable throwable) {
        this.logger.log(StatusUtil.createErrorStatus((Plugin)Activator.getDefault(), (Object)throwable));
    }
}

