/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.gmf.runtime.ui.internal.editor;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.emf.workspace.ResourceUndoContext;
import org.eclipse.sphinx.gmf.runtime.ui.internal.editor.IModelEditorInputChangeAnalyzer;
import org.eclipse.sphinx.gmf.runtime.ui.internal.editor.IModelEditorInputChangeHandler;
import org.eclipse.ui.IEditorInput;

public class ModelEditorInputSynchronizer
implements IDisposable {
    private ResourceSetListener resourceLoadedListener;
    private ResourceSetListener resourceMovedListener;
    private ResourceSetListener resourceRemovedListener;
    private IOperationHistoryListener objectChangedListener;
    private ResourceSetListener objectRemovedListener;
    protected IEditorInput editorInput;
    protected TransactionalEditingDomain editingDomain;
    protected IModelEditorInputChangeAnalyzer editorInputChangeAnalyzer;
    protected IModelEditorInputChangeHandler editorInputChangeHandler;

    public ModelEditorInputSynchronizer(IEditorInput editorInput, TransactionalEditingDomain editingDomain, IModelEditorInputChangeAnalyzer editorInputChangeAnalyzer, IModelEditorInputChangeHandler editorInputChangeHandler) {
        Assert.isNotNull((Object)editorInput);
        Assert.isNotNull((Object)editingDomain);
        Assert.isNotNull((Object)editorInputChangeAnalyzer);
        Assert.isNotNull((Object)editorInputChangeHandler);
        this.editorInput = editorInput;
        this.editingDomain = editingDomain;
        this.editorInputChangeAnalyzer = editorInputChangeAnalyzer;
        this.editorInputChangeHandler = editorInputChangeHandler;
        this.installModelChangeListeners();
    }

    protected void installModelChangeListeners() {
        this.resourceLoadedListener = this.createResourceLoadedListener();
        Assert.isNotNull((Object)this.resourceLoadedListener);
        this.editingDomain.addResourceSetListener(this.resourceLoadedListener);
        this.resourceMovedListener = this.createResourceMovedListener();
        Assert.isNotNull((Object)this.resourceMovedListener);
        this.editingDomain.addResourceSetListener(this.resourceMovedListener);
        this.resourceRemovedListener = this.createResourceRemovedListener();
        Assert.isNotNull((Object)this.resourceRemovedListener);
        this.editingDomain.addResourceSetListener(this.resourceRemovedListener);
        this.objectChangedListener = this.createObjectChangedListener();
        Assert.isNotNull((Object)this.objectChangedListener);
        this.getOperationHistory().addOperationHistoryListener(this.objectChangedListener);
        this.objectRemovedListener = this.createObjectRemovedListener();
        Assert.isNotNull((Object)this.objectRemovedListener);
        this.editingDomain.addResourceSetListener(this.objectRemovedListener);
    }

    protected void uninstallModelChangeListeners() {
        this.editingDomain.removeResourceSetListener(this.resourceLoadedListener);
        this.editingDomain.removeResourceSetListener(this.resourceMovedListener);
        this.editingDomain.removeResourceSetListener(this.resourceRemovedListener);
        this.getOperationHistory().removeOperationHistoryListener(this.objectChangedListener);
        this.editingDomain.removeResourceSetListener(this.objectRemovedListener);
    }

    protected ResourceSetListener createResourceLoadedListener() {
        return new ResourceSetListenerImpl(NotificationFilter.createFeatureFilter((EClassifier)EcorePackage.eINSTANCE.getEResource(), (int)4)){

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                List notifications = event.getNotifications();
                for (Object object : notifications) {
                    Resource loadedResource;
                    Notification notification;
                    if (!(object instanceof Notification) || !(notification = (Notification)object).getNewBooleanValue() || !(loadedResource = (Resource)notification.getNotifier()).isLoaded() || !ModelEditorInputSynchronizer.this.editorInputChangeAnalyzer.containEditorInputResourceURI(ModelEditorInputSynchronizer.this.editorInput, Collections.singleton(loadedResource.getURI()))) continue;
                    ModelEditorInputSynchronizer.this.editorInputChangeHandler.handleEditorInputResourceLoaded(ModelEditorInputSynchronizer.this.editorInput);
                    break;
                }
            }

            public boolean isPostcommitOnly() {
                return true;
            }
        };
    }

    protected ResourceSetListener createResourceMovedListener() {
        return new ResourceSetListenerImpl(NotificationFilter.createFeatureFilter((EClassifier)EcorePackage.eINSTANCE.getEResource(), (int)1)){

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                List notifications = event.getNotifications();
                for (Object object : notifications) {
                    URI oldResourceURI;
                    Notification notification;
                    if (!(object instanceof Notification) || !((notification = (Notification)object).getOldValue() instanceof URI) || (oldResourceURI = (URI)notification.getOldValue()) == null || !ModelEditorInputSynchronizer.this.editorInputChangeAnalyzer.containEditorInputResourceURI(ModelEditorInputSynchronizer.this.editorInput, Collections.singleton(oldResourceURI))) continue;
                    ModelEditorInputSynchronizer.this.editorInputChangeHandler.handleEditorInputResourceMoved(ModelEditorInputSynchronizer.this.editorInput, oldResourceURI, (URI)notification.getNewValue());
                    break;
                }
            }

            public boolean isPostcommitOnly() {
                return true;
            }
        };
    }

    protected ResourceSetListener createResourceRemovedListener() {
        return new ResourceSetListenerImpl(NotificationFilter.createFeatureFilter((EClassifier)EcorePackage.eINSTANCE.getEResourceSet(), (int)0).and(NotificationFilter.createEventTypeFilter((int)4).or(NotificationFilter.createEventTypeFilter((int)6)))){

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                HashSet<Resource> removedResources = new HashSet<Resource>();
                List notifications = event.getNotifications();
                for (Object object : notifications) {
                    Resource oldResource;
                    if (!(object instanceof Notification)) continue;
                    Notification notification = (Notification)object;
                    Object oldValue = notification.getOldValue();
                    if (oldValue instanceof Resource && (oldResource = (Resource)oldValue).getResourceSet() == null) {
                        removedResources.add(oldResource);
                    }
                    if (!(oldValue instanceof List)) continue;
                    List oldResources = (List)oldValue;
                    for (Resource oldResource2 : oldResources) {
                        if (oldResource2.getResourceSet() != null) continue;
                        removedResources.add(oldResource2);
                    }
                }
                HashSet<URI> removedResourceURIs = new HashSet<URI>(removedResources.size());
                for (Resource removedResource : removedResources) {
                    removedResourceURIs.add(removedResource.getURI());
                }
                if (ModelEditorInputSynchronizer.this.editorInputChangeAnalyzer.containEditorInputResourceURI(ModelEditorInputSynchronizer.this.editorInput, removedResourceURIs)) {
                    ModelEditorInputSynchronizer.this.editorInputChangeHandler.handleEditorInputResourceRemoved(ModelEditorInputSynchronizer.this.editorInput);
                }
            }

            public boolean isPostcommitOnly() {
                return true;
            }
        };
    }

    protected ResourceSetListener createObjectRemovedListener() {
        return new ResourceSetListenerImpl(NotificationFilter.createEventTypeFilter((int)4).or(NotificationFilter.createEventTypeFilter((int)6))){

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                HashSet<EObject> removedObjects = new HashSet<EObject>();
                List notifications = event.getNotifications();
                for (Object object : notifications) {
                    EObject oldObject;
                    if (!(object instanceof Notification)) continue;
                    Notification notification = (Notification)object;
                    Object oldValue = notification.getOldValue();
                    if (oldValue instanceof EObject && (oldObject = (EObject)oldValue).eResource() == null) {
                        removedObjects.add(oldObject);
                    }
                    if (!(oldValue instanceof List)) continue;
                    for (Object oldValueItem : (List)oldValue) {
                        EObject oldObject2;
                        if (!(oldValueItem instanceof EObject) || (oldObject2 = (EObject)oldValueItem).eResource() != null) continue;
                        removedObjects.add(oldObject2);
                    }
                }
                if (ModelEditorInputSynchronizer.this.editorInputChangeAnalyzer.containEditorInputObject(ModelEditorInputSynchronizer.this.editorInput, removedObjects)) {
                    ModelEditorInputSynchronizer.this.editorInputChangeHandler.handleEditorInputObjectRemoved(ModelEditorInputSynchronizer.this.editorInput);
                }
            }

            public boolean isPostcommitOnly() {
                return true;
            }
        };
    }

    protected IOperationHistoryListener createObjectChangedListener() {
        return new IOperationHistoryListener(){

            public void historyNotification(OperationHistoryEvent event) {
                if (event.getEventType() == 4 || event.getEventType() == 10 || event.getEventType() == 9) {
                    Set affectedResources = ResourceUndoContext.getAffectedResources((IUndoableOperation)event.getOperation());
                    HashSet<URI> affectedResourceURIs = new HashSet<URI>(affectedResources.size());
                    for (Resource affectedResource : affectedResources) {
                        affectedResourceURIs.add(affectedResource.getURI());
                    }
                    if (ModelEditorInputSynchronizer.this.editorInputChangeAnalyzer.containEditorInputResourceURI(ModelEditorInputSynchronizer.this.editorInput, affectedResourceURIs)) {
                        ModelEditorInputSynchronizer.this.editorInputChangeHandler.handleEditorInputObjectChanged(ModelEditorInputSynchronizer.this.editorInput);
                    }
                }
            }
        };
    }

    protected IOperationHistory getOperationHistory() {
        CommandStack commandStack = this.editingDomain.getCommandStack();
        if (commandStack instanceof IWorkspaceCommandStack) {
            return ((IWorkspaceCommandStack)commandStack).getOperationHistory();
        }
        return OperationHistoryFactory.getOperationHistory();
    }

    public void dispose() {
        this.uninstallModelChangeListeners();
    }
}

