/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.mwe.dynamic.util;

import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.mwe.dynamic.internal.Activator;
import org.eclipse.sphinx.emf.mwe.dynamic.internal.messages.Messages;
import org.eclipse.sphinx.emf.util.EObjectUtil;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.emf.util.URIExtensions;
import org.eclipse.sphinx.jdt.util.JavaExtensions;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public class WorkflowRunnerHelper {
    public String toWorkflowString(IType workflowType) {
        Assert.isNotNull((Object)workflowType);
        if (workflowType.isBinary()) {
            return workflowType.getFullyQualifiedName();
        }
        return ((SourceType)workflowType).getPath().toString();
    }

    public Object toWorkflowObject(String workflowString) throws ClassNotFoundException, FileNotFoundException {
        if (workflowString == null) {
            return null;
        }
        if ((workflowString = workflowString.trim()).isEmpty()) {
            return null;
        }
        Matcher matcher = JavaExtensions.CLASS_NAME_PATTERN.matcher(workflowString);
        if (matcher.find()) {
            try {
                return Class.forName(workflowString);
            }
            catch (ClassNotFoundException ex) {
                throw new ClassNotFoundException(NLS.bind((String)Messages.error_workflowClassNotFound, (Object)workflowString));
            }
        }
        Path workflowPath = new Path(workflowString);
        IFile workflowFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)workflowPath);
        if (!workflowFile.exists()) {
            IPath workflowLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().append((IPath)workflowPath);
            throw new FileNotFoundException(NLS.bind((String)Messages.error_workflowFileDoesNotExist, (Object)workflowLocation.toOSString()));
        }
        return workflowFile;
    }

    public String toModelURIString(URI modelURI) {
        Assert.isNotNull((Object)modelURI);
        return modelURI.toString();
    }

    public URI toModelURIObject(String modelURIString) throws FileNotFoundException {
        if (modelURIString == null) {
            return null;
        }
        if ((modelURIString = modelURIString.trim()).isEmpty()) {
            return null;
        }
        URI modelURI = URI.createURI((String)modelURIString);
        Path modelFilePath = new Path(modelURI.trimFragment().toString());
        URI absoluteModelFileURI = EcorePlatformUtil.createURI((IPath)modelFilePath.makeAbsolute());
        if (!EcoreResourceUtil.exists((URI)absoluteModelFileURI)) {
            throw new FileNotFoundException(NLS.bind((String)Messages.error_modelResourceDoesNotExist, (Object)absoluteModelFileURI.toPlatformString(true)));
        }
        return absoluteModelFileURI.appendFragment(modelURI.fragment());
    }

    public Map<String, Object> toArgumentObjects(Map<String, Object> arguments, Map<String, Class<?>> parameters) {
        if (arguments == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> convertedArguments = new HashMap<String, Object>();
        for (String name : arguments.keySet()) {
            Object value = arguments.get(name);
            if (value == null) {
                convertedArguments.put(name, null);
                continue;
            }
            if (parameters.containsKey(name)) {
                Class<?> type = parameters.get(name);
                if (value.getClass() != type) {
                    try {
                        if (value instanceof String) {
                            Object convertedValue = EObjectUtil.createFromString(type, (String)((String)value));
                            convertedArguments.put(name, convertedValue);
                            continue;
                        }
                        throw new RuntimeException("Unable to convert workflow argument '" + name + "' to '" + type.getName() + "'");
                    }
                    catch (Exception ex) {
                        PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)ex);
                    }
                    continue;
                }
                convertedArguments.put(name, value);
                continue;
            }
            if (value instanceof String) {
                Object convertedValue = this.toArgumentValueObject(name, (String)value);
                convertedArguments.put(name, convertedValue);
                continue;
            }
            convertedArguments.put(name, value);
        }
        return convertedArguments;
    }

    public Object toArgumentValueObject(String name, String valueString) {
        Assert.isNotNull((Object)valueString);
        valueString = valueString.trim();
        if (Boolean.TRUE.toString().equalsIgnoreCase(valueString)) {
            return Boolean.TRUE;
        }
        if (Boolean.FALSE.toString().equalsIgnoreCase(valueString)) {
            return Boolean.FALSE;
        }
        URI valueURI = URI.createURI((String)valueString);
        if (name != null && name.contains(URI.class.getSimpleName())) {
            return valueURI;
        }
        if (URIExtensions.isActual((URI)valueURI)) {
            return valueURI;
        }
        return valueString;
    }
}

