/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.util;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.DelegatingEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public abstract class AbstractFilteringEList<E>
extends DelegatingEList<E> {
    private static final long serialVersionUID = 1L;
    private EObject targetOwner;
    private EStructuralFeature targetFeature;

    public AbstractFilteringEList(EObject targetOwner, EStructuralFeature targetFeature) {
        Assert.isNotNull((Object)targetOwner);
        Assert.isLegal((boolean)(targetFeature instanceof EReference));
        this.targetOwner = targetOwner;
        this.targetFeature = targetFeature;
    }

    protected List<E> delegateList() {
        return (List)this.targetOwner.eGet(this.targetFeature);
    }

    protected List<E> getFilteredEList() {
        BasicEList filteredEList = new BasicEList();
        for (E item : this.delegateList()) {
            if (!this.accept(item)) continue;
            filteredEList.add(item);
        }
        return filteredEList;
    }

    protected int delegateSize() {
        return this.getFilteredEList().size();
    }

    protected E delegateGet(int index) {
        return this.getFilteredEList().get(index);
    }

    protected E delegateSet(int index, E object) {
        return this.getFilteredEList().set(index, object);
    }

    protected void delegateAdd(int index, E object) {
        this.getFilteredEList().add(index, object);
        this.delegateList().add(index, object);
    }

    protected E delegateRemove(int index) {
        E object = this.delegateGet(index);
        this.delegateList().remove(object);
        return this.delegateList().remove(index);
    }

    protected Object[] delegateToArray() {
        return this.getFilteredEList().toArray();
    }

    protected <T> T[] delegateToArray(T[] array) {
        return this.getFilteredEList().toArray(array);
    }

    protected abstract boolean accept(E var1);
}

