/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.testutils.integration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;

public class ResourceProblemListener
extends ResourceSetListenerImpl {
    protected List<Resource> errorResources = new ArrayList<Resource>();

    public ResourceProblemListener() {
        super(NotificationFilter.createFeatureFilter((EClassifier)EcorePackage.eINSTANCE.getEResource(), (int)4).or(NotificationFilter.createFeatureFilter((EClassifier)EcorePackage.eINSTANCE.getEResourceSet(), (int)0)));
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        HashSet<Resource> loadedResources = new HashSet<Resource>();
        for (Notification notification : event.getNotifications()) {
            Object notifier = notification.getNotifier();
            if (notifier instanceof Resource) {
                Resource resource = (Resource)notifier;
                Boolean newValue = (Boolean)notification.getNewValue();
                if (!newValue.booleanValue()) continue;
                loadedResources.add(resource);
                continue;
            }
            if (!(notifier instanceof ResourceSet)) continue;
            Object newValue = notification.getNewValue();
            if (notification.getEventType() != 3 && notification.getEventType() != 5) continue;
            ArrayList<Resource> newResources = new ArrayList<Resource>();
            if (newValue instanceof List) {
                List newResourcesValue = (List)newValue;
                newResources.addAll(newResourcesValue);
            } else if (newValue instanceof Resource) {
                newResources.add((Resource)newValue);
            }
            loadedResources.addAll(newResources);
        }
        this.handleLoadedResources(loadedResources);
    }

    public boolean isPostcommitOnly() {
        return true;
    }

    protected void handleLoadedResources(Collection<Resource> resources) {
        for (Resource resource : resources) {
            if (resource.getErrors().isEmpty()) continue;
            this.errorResources.add(resource);
        }
    }

    public List<Resource> getErrorResources() {
        return this.errorResources;
    }

    public void clearHistory() {
        this.errorResources.clear();
    }
}

