/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.ui.internal;

import java.net.URL;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.ui.EclipseUIPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.sphinx.platform.IExtendedPlatformConstants;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.BundleContext;

public final class Activator
extends EMFPlugin {
    public static final Activator INSTANCE = new Activator();
    private static Implementation plugin;
    private ResourceManager resourceManager;

    public Activator() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.resourceManager;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static Implementation getDefault() {
        return plugin;
    }

    public static class Implementation
    extends EclipseUIPlugin {
        private IWorkbenchListener workbenchListener = new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                Job.getJobManager().cancel(IExtendedPlatformConstants.FAMILY_LONG_RUNNING);
                return true;
            }

            public void postShutdown(IWorkbench workbench) {
            }
        };

        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            PlatformUI.getWorkbench().addWorkbenchListener(this.workbenchListener);
        }

        public void stop(BundleContext context) throws Exception {
            PlatformUI.getWorkbench().removeWorkbenchListener(this.workbenchListener);
            super.stop(context);
        }

        public ImageDescriptor getImageDescriptor(String key) {
            Object imageURL = this.getImage(key);
            if (imageURL instanceof URL) {
                return this.getImageDescriptor((URL)imageURL);
            }
            return null;
        }

        public ImageDescriptor getImageDescriptor(URL url) {
            if (Display.getCurrent() != null) {
                return ExtendedImageRegistry.INSTANCE.getImageDescriptor((Object)url);
            }
            return ImageDescriptor.createFromURL((URL)url);
        }
    }
}

