/**
 * Copyright (c) 2014,2017 Contributors to the Eclipse Foundation
 * 
 * See the NOTICE file(s) distributed with this work for additional
 * information regarding copyright ownership.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.smarthome.model.validation;

import org.eclipse.smarthome.model.items.ItemsPackage;
import org.eclipse.smarthome.model.items.ModelItem;
import org.eclipse.smarthome.model.validation.AbstractItemsValidator;
import org.eclipse.xtext.validation.Check;

/**
 * Custom validation rules.
 * 
 * see http://www.eclipse.org/Xtext/documentation.html#validation
 */
@SuppressWarnings("all")
public class ItemsValidator extends AbstractItemsValidator {
  @Check
  public void checkItemName(final ModelItem item) {
    if (((item == null) || (item.getName() == null))) {
      return;
    }
    boolean _contains = item.getName().contains("-");
    if (_contains) {
      this.error("Item name must not contain dashes.", ItemsPackage.Literals.MODEL_ITEM__NAME);
    }
  }
}
