/**
 * Copyright (c) 2014,2018 Contributors to the Eclipse Foundation
 * 
 * See the NOTICE file(s) distributed with this work for additional
 * information regarding copyright ownership.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.smarthome.model.thing;

import com.google.inject.Binder;
import com.google.inject.name.Names;
import org.eclipse.smarthome.model.thing.AbstractThingRuntimeModule;
import org.eclipse.smarthome.model.thing.serializer.ThingSyntacticSequencerExtension;
import org.eclipse.smarthome.model.thing.valueconverter.ThingValueConverters;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.linking.lazy.LazyURIEncoder;
import org.eclipse.xtext.serializer.sequencer.ISyntacticSequencer;

/**
 * Use this class to register components to be used at runtime / without the Equinox extension registry.
 */
@SuppressWarnings("restriction")
public class ThingRuntimeModule extends AbstractThingRuntimeModule {
  @Override
  public Class<? extends IValueConverterService> bindIValueConverterService() {
    return ThingValueConverters.class;
  }
  
  @Override
  public Class<? extends ISyntacticSequencer> bindISyntacticSequencer() {
    return ThingSyntacticSequencerExtension.class;
  }
  
  @Override
  public void configureUseIndexFragmentsForLazyLinking(final Binder binder) {
    binder.<Boolean>bind(Boolean.TYPE).annotatedWith(Names.named(LazyURIEncoder.USE_INDEXED_FRAGMENTS_BINDING)).toInstance(
      Boolean.FALSE);
  }
}
