/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.http.auth.basic.internal;

import java.util.Base64;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.smarthome.core.auth.Credentials;
import org.eclipse.smarthome.core.auth.UsernamePasswordCredentials;
import org.eclipse.smarthome.io.http.auth.CredentialsExtractor;
import org.osgi.service.component.annotations.Component;

@Component(property={"context=javax.servlet.http.HttpServletRequest"})
public class BasicCredentialsExtractor
implements CredentialsExtractor<HttpServletRequest> {
    public Optional<Credentials> retrieveCredentials(HttpServletRequest request) {
        String usernameAndPassword;
        String authType;
        String authenticationHeader = request.getHeader("Authorization");
        if (authenticationHeader == null) {
            return Optional.empty();
        }
        String[] tokens = authenticationHeader.split(" ");
        if (tokens.length == 2 && "BASIC".equalsIgnoreCase(authType = tokens[0]) && (tokens = (usernameAndPassword = new String(Base64.getDecoder().decode(tokens[1]))).split(":")).length == 2) {
            String username = tokens[0];
            String password = tokens[1];
            return Optional.of(new UsernamePasswordCredentials(username, password));
        }
        return Optional.empty();
    }
}

