/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.script.rulesupport.shared;

import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Stream;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.RuleRegistry;
import org.eclipse.smarthome.automation.module.script.rulesupport.shared.ScriptedRuleProvider;
import org.eclipse.smarthome.core.common.registry.Identifiable;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;

public class RuleSupportRuleRegistryDelegate
implements RuleRegistry {
    private final RuleRegistry ruleRegistry;
    private final HashSet<String> rules = new HashSet();
    private final ScriptedRuleProvider ruleProvider;

    public RuleSupportRuleRegistryDelegate(RuleRegistry ruleRegistry, ScriptedRuleProvider ruleProvider) {
        this.ruleRegistry = ruleRegistry;
        this.ruleProvider = ruleProvider;
    }

    public void addRegistryChangeListener(RegistryChangeListener<Rule> listener) {
        this.ruleRegistry.addRegistryChangeListener(listener);
    }

    public Collection<Rule> getAll() {
        return this.ruleRegistry.getAll();
    }

    public Stream<Rule> stream() {
        return this.ruleRegistry.stream();
    }

    public Rule get(String key) {
        return (Rule)this.ruleRegistry.get((Object)key);
    }

    public void removeRegistryChangeListener(RegistryChangeListener<Rule> listener) {
        this.ruleRegistry.removeRegistryChangeListener(listener);
    }

    public Rule add(Rule element) {
        this.ruleProvider.addRule(element);
        this.rules.add(element.getUID());
        return element;
    }

    public void addPermanent(Rule element) {
        this.ruleRegistry.add(element);
    }

    public Rule update(Rule element) {
        return (Rule)this.ruleRegistry.update((Identifiable)element);
    }

    public Rule remove(String key) {
        if (this.rules.remove(key)) {
            this.ruleProvider.removeRule(key);
        }
        return (Rule)this.ruleRegistry.remove((Object)key);
    }

    public Collection<Rule> getByTag(String tag) {
        return this.ruleRegistry.getByTag(tag);
    }

    public void removeAllAddedByScript() {
        for (String rule : this.rules) {
            try {
                this.ruleProvider.removeRule(rule);
            }
            catch (Exception exception) {}
        }
        this.rules.clear();
    }

    public Collection<Rule> getByTags(String ... tags) {
        return this.ruleRegistry.getByTags(tags);
    }
}

