/*
 * Copyright (c) OSGi Alliance (2012, 2017). All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.osgi.service.http.runtime.dto;

import java.util.Map;

import org.osgi.dto.DTO;

/**
 * Represents a preprocessor
 * {@code org.osgi.service.http.whiteboard.Preprocessor} service currently being
 * used during request processing.
 * 
 * @NotThreadSafe
 * @author $Id: be078563a268e7c4028ea90da10815e2a9f9d690 $
 * @since 1.1
 */
public class PreprocessorDTO extends DTO {

	/**
	 * The preprocessor initialization parameters as provided during
	 * registration of the preprocessor. Additional parameters like the Http
	 * Service Runtime attributes are not included. If the preprocessor has not
	 * initialization parameters, this map is empty.
	 */
	public Map<String, String>	initParams;

	/**
	 * Service property identifying the preprocessor. In the case of a
	 * preprocessor registered in the service registry and picked up by a Http
	 * Whiteboard Implementation, this value is not negative and corresponds to
	 * the service id in the registry. If the preprocessor has not been
	 * registered in the service registry, the value is negative and a unique
	 * negative value is generated by the Http Service Runtime in this case.
	 */
	public long					serviceId;
}
