/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.apm;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.CacheEntry;
import org.eclipse.packagedrone.repo.channel.CacheEntryInformation;
import org.eclipse.packagedrone.repo.channel.ChannelState;
import org.eclipse.packagedrone.repo.channel.ValidationMessage;
import org.eclipse.packagedrone.repo.channel.apm.aspect.AspectContextImpl;
import org.eclipse.packagedrone.repo.channel.apm.aspect.AspectableContext;
import org.eclipse.packagedrone.repo.channel.apm.internal.Activator;
import org.eclipse.packagedrone.repo.channel.apm.store.BlobStore;
import org.eclipse.packagedrone.repo.channel.apm.store.CacheStore;
import org.eclipse.packagedrone.repo.channel.provider.ModifyContext;
import org.eclipse.packagedrone.storage.apm.StorageManager;
import org.eclipse.packagedrone.utils.Exceptions;
import org.eclipse.packagedrone.utils.io.IOConsumer;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class ModifyContextImpl
implements ModifyContext,
AspectableContext {
    private static final String FACET_GENERATOR = "generator";
    private final String channelId;
    private final EventAdmin eventAdmin;
    private final BlobStore store;
    private final CacheStore cacheStore;
    private final SortedMap<String, String> aspectStates;
    private final SortedMap<String, String> modAspectStates;
    private final Map<MetaKey, String> extractedMetadata;
    private final Map<MetaKey, String> modExtractedMetadata;
    private final Map<MetaKey, String> providedMetadata;
    private final Map<MetaKey, String> modProvidedMetadata;
    private final Map<String, ArtifactInformation> artifacts;
    private final Map<String, ArtifactInformation> modArtifacts;
    private final Map<String, ArtifactInformation> generatorArtifacts;
    private final Map<String, ArtifactInformation> modGeneratorArtifacts;
    private final Map<MetaKey, CacheEntryInformation> cacheEntries;
    private final Map<MetaKey, CacheEntryInformation> modCacheEntries;
    private final ChannelState.Builder state;
    private BlobStore.Transaction transaction;
    private CacheStore.Transaction cacheTransaction;
    private final AspectContextImpl aspectContext;
    private SortedMap<MetaKey, String> metaDataCache;

    public ModifyContextImpl(String channelId, EventAdmin eventAdmin, BlobStore store, CacheStore cacheStore) {
        this.channelId = channelId;
        this.eventAdmin = eventAdmin;
        this.store = store;
        this.cacheStore = cacheStore;
        this.state = new ChannelState.Builder();
        this.modAspectStates = new TreeMap<String, String>();
        this.modCacheEntries = new HashMap<MetaKey, CacheEntryInformation>();
        this.modArtifacts = new HashMap<String, ArtifactInformation>();
        this.modGeneratorArtifacts = new HashMap<String, ArtifactInformation>();
        this.modExtractedMetadata = new HashMap<MetaKey, String>();
        this.modProvidedMetadata = new HashMap<MetaKey, String>();
        this.aspectStates = Collections.unmodifiableSortedMap(this.modAspectStates);
        this.cacheEntries = Collections.unmodifiableMap(this.modCacheEntries);
        this.artifacts = Collections.unmodifiableMap(this.modArtifacts);
        this.generatorArtifacts = Collections.unmodifiableMap(this.modGeneratorArtifacts);
        this.extractedMetadata = Collections.unmodifiableMap(this.modExtractedMetadata);
        this.providedMetadata = Collections.unmodifiableMap(this.modProvidedMetadata);
        this.aspectContext = new AspectContextImpl(this, Activator.getProcessor());
    }

    public ModifyContextImpl(String channelId, EventAdmin eventAdmin, BlobStore store, CacheStore cacheStore, ChannelState state, Map<String, String> aspectStates, Map<String, ArtifactInformation> artifacts, Map<MetaKey, CacheEntryInformation> cacheEntries, Map<MetaKey, String> extractedMetaData, Map<MetaKey, String> providedMetaData) {
        this.channelId = channelId;
        this.eventAdmin = eventAdmin;
        this.store = store;
        this.cacheStore = cacheStore;
        this.state = new ChannelState.Builder(state);
        this.modAspectStates = new TreeMap<String, String>(aspectStates);
        this.modCacheEntries = new HashMap<MetaKey, CacheEntryInformation>(cacheEntries);
        this.modArtifacts = new HashMap<String, ArtifactInformation>(artifacts);
        this.modGeneratorArtifacts = this.modArtifacts.values().stream().filter(art -> art.is(FACET_GENERATOR)).collect(Collectors.toMap(ArtifactInformation::getId, a -> a));
        this.modExtractedMetadata = new HashMap<MetaKey, String>(extractedMetaData);
        this.modProvidedMetadata = new HashMap<MetaKey, String>(providedMetaData);
        this.aspectStates = Collections.unmodifiableSortedMap(this.modAspectStates);
        this.cacheEntries = Collections.unmodifiableMap(this.modCacheEntries);
        this.artifacts = Collections.unmodifiableMap(this.modArtifacts);
        this.generatorArtifacts = Collections.unmodifiableMap(this.modGeneratorArtifacts);
        this.extractedMetadata = Collections.unmodifiableMap(this.modExtractedMetadata);
        this.providedMetadata = Collections.unmodifiableMap(this.modProvidedMetadata);
        this.aspectContext = new AspectContextImpl(this, Activator.getProcessor());
    }

    public ModifyContextImpl(ModifyContextImpl other) {
        this.channelId = other.channelId;
        this.eventAdmin = other.eventAdmin;
        this.store = other.store;
        this.cacheStore = other.cacheStore;
        this.state = new ChannelState.Builder(other.state.build());
        this.modAspectStates = new TreeMap<String, String>(other.aspectStates);
        this.modCacheEntries = new HashMap<MetaKey, CacheEntryInformation>(other.cacheEntries);
        this.modArtifacts = new HashMap<String, ArtifactInformation>(other.artifacts);
        this.modGeneratorArtifacts = new HashMap<String, ArtifactInformation>(other.generatorArtifacts);
        this.modExtractedMetadata = new HashMap<MetaKey, String>(other.extractedMetadata);
        this.modProvidedMetadata = new HashMap<MetaKey, String>(other.providedMetadata);
        this.aspectStates = Collections.unmodifiableSortedMap(this.modAspectStates);
        this.cacheEntries = Collections.unmodifiableMap(this.modCacheEntries);
        this.artifacts = Collections.unmodifiableMap(this.modArtifacts);
        this.generatorArtifacts = Collections.unmodifiableMap(this.modGeneratorArtifacts);
        this.extractedMetadata = Collections.unmodifiableMap(this.modExtractedMetadata);
        this.providedMetadata = Collections.unmodifiableMap(this.modProvidedMetadata);
        this.aspectContext = new AspectContextImpl(this, Activator.getProcessor());
    }

    @Override
    public String getChannelId() {
        return this.channelId;
    }

    public ChannelState getState() {
        return this.state.build();
    }

    public SortedMap<MetaKey, String> getMetaData() {
        if (this.metaDataCache == null) {
            TreeMap<MetaKey, String> tmp = new TreeMap<MetaKey, String>();
            if (this.modExtractedMetadata != null) {
                tmp.putAll(this.modExtractedMetadata);
            }
            if (this.modProvidedMetadata != null) {
                tmp.putAll(this.modProvidedMetadata);
            }
            this.metaDataCache = Collections.unmodifiableSortedMap(tmp);
        }
        return this.metaDataCache;
    }

    @Override
    public Map<String, ArtifactInformation> getArtifacts() {
        return this.artifacts;
    }

    @Override
    public Map<String, ArtifactInformation> getGeneratorArtifacts() {
        return this.generatorArtifacts;
    }

    public Map<MetaKey, CacheEntryInformation> getCacheEntries() {
        return this.cacheEntries;
    }

    public SortedMap<String, String> getAspectStates() {
        return this.aspectStates;
    }

    @Override
    public SortedMap<String, String> getModifiableAspectStates() {
        return this.modAspectStates;
    }

    public void applyMetaData(Map<MetaKey, String> changes) {
        this.testLocked();
        for (Map.Entry<MetaKey, String> entry : changes.entrySet()) {
            MetaKey key = entry.getKey();
            String value = entry.getValue();
            if (value == null) {
                this.modProvidedMetadata.remove(key);
                continue;
            }
            this.modProvidedMetadata.put(key, value);
        }
        this.metaDataCache = null;
        this.markModified();
        this.aspectContext.aggregate();
    }

    public void applyMetaData(String artifactId, Map<MetaKey, String> changes) {
        this.testLocked();
        ArtifactInformation artifact = this.modArtifacts.get(artifactId);
        if (artifact == null) {
            throw new IllegalStateException(String.format("Artifact '%s' is unknown", artifactId));
        }
        if (!artifact.getFacets().contains("stored")) {
            throw new IllegalStateException(String.format("Artifact '%s' is not 'stored'", artifactId));
        }
        ArtifactInformation.Manipulator m = artifact.createManipulator();
        for (Map.Entry<MetaKey, String> entry : changes.entrySet()) {
            MetaKey key = entry.getKey();
            String value = entry.getValue();
            if (value == null) {
                m.getProvidedMetaData().remove(key);
                continue;
            }
            m.getProvidedMetaData().put(key, value);
        }
        this.updateArtifact(m);
        this.markModified();
        if (artifact.getFacets().contains(FACET_GENERATOR)) {
            this.aspectContext.regenerate(artifactId);
        }
    }

    private void testLocked() {
        if (this.state.build().isLocked()) {
            throw new IllegalStateException("Channel is locked");
        }
    }

    public void lock() {
        this.state.setLocked(true);
    }

    public void unlock() {
        this.state.setLocked(false);
    }

    private void ensureTransaction() {
        if (this.transaction == null) {
            this.transaction = this.store.start();
        }
    }

    private void ensureCacheTransaction() {
        if (this.cacheTransaction == null) {
            this.cacheTransaction = this.cacheStore.startTransaction();
            this.modCacheEntries.clear();
        }
    }

    public BlobStore.Transaction claimTransaction() {
        BlobStore.Transaction t = this.transaction;
        this.transaction = null;
        return t;
    }

    public CacheStore.Transaction claimCacheTransaction() {
        CacheStore.Transaction t = this.cacheTransaction;
        this.cacheTransaction = null;
        return t;
    }

    public ArtifactInformation createArtifact(InputStream source, String name, Map<MetaKey, String> providedMetaData) {
        return this.createArtifact(null, source, name, providedMetaData);
    }

    public ArtifactInformation createArtifact(String parentId, InputStream source, String name, Map<MetaKey, String> providedMetaData) {
        ArtifactInformation parent;
        this.testLocked();
        this.markModified();
        if (parentId != null && (parent = this.modArtifacts.get(parentId)) != null && !parent.is("stored")) {
            throw new IllegalArgumentException(String.format("Unable to use artifact %s as parent, it is not a stored artifact", parentId));
        }
        return (ArtifactInformation)Exceptions.wrapException(() -> this.aspectContext.createArtifact(parentId, source, name, providedMetaData));
    }

    public ArtifactInformation createGeneratorArtifact(String generatorId, InputStream source, String name, Map<MetaKey, String> providedMetaData) {
        this.testLocked();
        this.markModified();
        return (ArtifactInformation)Exceptions.wrapException(() -> this.aspectContext.createGeneratorArtifact(generatorId, source, name, providedMetaData));
    }

    @Override
    public ArtifactInformation createPlainArtifact(String parentId, InputStream source, String name, Map<MetaKey, String> providedMetaData, Set<String> facets, String virtualizerAspectId) {
        this.ensureTransaction();
        this.markModified();
        String id = UUID.randomUUID().toString();
        try {
            ArtifactInformation parent;
            long size = this.transaction.create(id, source);
            if (parentId != null) {
                parent = this.artifacts.get(parentId);
                if (parent == null) {
                    throw new IllegalArgumentException(String.format("Parent artifact %s does not exists", parentId));
                }
            } else {
                parent = null;
            }
            ArtifactInformation ai = new ArtifactInformation(id, parentId, Collections.emptySet(), name, size, Instant.now(), facets, Collections.emptyList(), providedMetaData, null, virtualizerAspectId);
            this.modArtifacts.put(ai.getId(), ai);
            if (ai.is(FACET_GENERATOR)) {
                this.modGeneratorArtifacts.put(ai.getId(), ai);
            }
            if (parent != null) {
                ArtifactInformation.Manipulator m = parent.createManipulator();
                m.getChildIds().add(ai.getId());
                this.updateArtifact(m);
            }
            this.state.setNumberOfArtifacts((long)this.modArtifacts.size());
            this.state.incrementNumberOfBytes(ai.getSize());
            return ai;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create artifact", e);
        }
    }

    private ArtifactInformation updateArtifact(ArtifactInformation.Manipulator manipulator) {
        this.markModified();
        ArtifactInformation art = manipulator.build();
        this.modArtifacts.put(art.getId(), art);
        return art;
    }

    private boolean internalDeleteArtifact(String id) throws IOException {
        ArtifactInformation parent;
        this.ensureTransaction();
        boolean result = this.transaction.delete(id);
        ArtifactInformation ai = this.modArtifacts.remove(id);
        if (ai == null) {
            return result;
        }
        this.modGeneratorArtifacts.remove(id);
        if (ai.getChildIds() != null) {
            for (String childId : ai.getChildIds()) {
                this.internalDeleteArtifact(childId);
            }
        }
        if (ai.getParentId() != null && (parent = this.modArtifacts.get(ai.getParentId())) != null) {
            ArtifactInformation.Manipulator m = parent.createManipulator();
            m.getChildIds().remove(id);
            this.updateArtifact(m);
        }
        if (ai.is(FACET_GENERATOR)) {
            this.modGeneratorArtifacts.remove(id);
        }
        this.state.setNumberOfArtifacts((long)this.modArtifacts.size());
        this.state.incrementNumberOfBytes(-ai.getSize());
        return result;
    }

    @Override
    public ArtifactInformation deletePlainArtifact(String id) {
        ArtifactInformation artifact;
        block3: {
            this.markModified();
            try {
                artifact = this.modArtifacts.get(id);
                if (artifact != null) break block3;
                return null;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to delete artifact", e);
            }
        }
        ArtifactInformation result = this.internalDeleteArtifact(id) ? artifact : null;
        return result;
    }

    public boolean deleteArtifact(String id) {
        this.testLocked();
        this.markModified();
        this.ensureTransaction();
        ArtifactInformation artifact = this.modArtifacts.get(id);
        if (artifact == null) {
            return false;
        }
        if (!artifact.is("stored")) {
            throw new IllegalStateException(String.format("Unable to delete artifact '%s'. It is not 'stored'.", id));
        }
        boolean result = this.aspectContext.deleteArtifacts(Collections.singleton(id));
        return result;
    }

    @Override
    public boolean stream(String artifactId, IOConsumer<InputStream> consumer) throws IOException {
        if (this.transaction != null) {
            return this.transaction.stream(artifactId, consumer);
        }
        return this.store.stream(artifactId, consumer);
    }

    public boolean streamCacheEntry(MetaKey key, IOConsumer<CacheEntry> consumer) throws IOException {
        CacheEntryInformation entry = this.cacheEntries.get(key);
        if (entry == null) {
            return false;
        }
        if (this.cacheTransaction != null) {
            return this.cacheTransaction.stream(key, (IOConsumer<InputStream>)((IOConsumer)stream -> consumer.accept((Object)new CacheEntry(entry, stream))));
        }
        return this.cacheStore.stream(key, (IOConsumer<InputStream>)((IOConsumer)stream -> consumer.accept((Object)new CacheEntry(entry, stream))));
    }

    public void clear() {
        String[] keys;
        this.testLocked();
        this.markModified();
        this.ensureTransaction();
        this.ensureCacheTransaction();
        String[] stringArray = keys = this.modArtifacts.keySet().toArray(new String[this.modArtifacts.size()]);
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String art = stringArray[n2];
            try {
                this.internalDeleteArtifact(art);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to delete artifact: " + art, e);
            }
            ++n2;
        }
        this.modGeneratorArtifacts.clear();
        this.modCacheEntries.clear();
        Exceptions.wrapException(() -> this.cacheTransaction.clear());
        this.modExtractedMetadata.clear();
        this.metaDataCache = null;
        this.state.setValidationMessages(Collections.emptyList());
        this.state.setNumberOfArtifacts(0L);
        this.state.setNumberOfBytes(0L);
    }

    public void addAspects(Set<String> aspectIds) {
        this.testLocked();
        this.markModified();
        this.aspectContext.addAspects(aspectIds);
    }

    public void removeAspects(Set<String> aspectIds) {
        Objects.requireNonNull(aspectIds, "'aspectIds' must not be null");
        this.testLocked();
        this.markModified();
        this.aspectContext.removeAspects(aspectIds);
        this.postAspectEvents(aspectIds, "remove");
    }

    public void refreshAspects(Set<String> aspectIds) {
        this.testLocked();
        this.markModified();
        if (aspectIds == null || aspectIds.isEmpty()) {
            aspectIds = new HashSet<String>(this.aspectStates.keySet());
        }
        this.aspectContext.refreshAspects(aspectIds);
        this.postAspectEvents(aspectIds, "refresh");
    }

    protected ArtifactInformation modifyArtifact(String artifactId, Consumer<ArtifactInformation.Manipulator> modification) {
        ArtifactInformation art = this.artifacts.get(artifactId);
        if (art == null) {
            throw new IllegalStateException(String.format("Unable to find artifact '%s'", artifactId));
        }
        ArtifactInformation.Manipulator m = art.createManipulator();
        modification.accept(m);
        this.markModified();
        return this.updateArtifact(m);
    }

    @Override
    public ArtifactInformation setExtractedMetaData(String artifactId, Map<MetaKey, String> metaData) {
        return this.modifyArtifact(artifactId, art -> art.setExtractedMetaData(new HashMap(metaData)));
    }

    @Override
    public ArtifactInformation setValidationMessages(String artifactId, List<ValidationMessage> messages) {
        return this.modifyArtifact(artifactId, art -> art.setValidationMessages(messages));
    }

    @Override
    public void setExtractedMetaData(Map<MetaKey, String> metaData) {
        this.modExtractedMetadata.clear();
        this.modExtractedMetadata.putAll(metaData);
        this.metaDataCache = null;
        this.markModified();
    }

    @Override
    public void setValidationMessages(List<ValidationMessage> messages) {
        this.state.setValidationMessages(messages);
        this.markModified();
    }

    @Override
    public Collection<ValidationMessage> getValidationMessages() {
        return Collections.unmodifiableCollection(this.state.build().getValidationMessages());
    }

    public void regenerate(String artifactId) {
        this.testLocked();
        this.aspectContext.regenerate(artifactId);
        this.markModified();
    }

    @Override
    public Map<MetaKey, String> getChannelProvidedMetaData() {
        return this.providedMetadata;
    }

    public Map<MetaKey, String> getProvidedMetaData() {
        return this.getChannelProvidedMetaData();
    }

    public Map<MetaKey, String> getExtractedMetaData() {
        return this.extractedMetadata;
    }

    @Override
    public void createCacheEntry(MetaKey key, String name, String mimeType, IOConsumer<OutputStream> creator) throws IOException {
        this.ensureCacheTransaction();
        long size = this.cacheTransaction.put(key, creator);
        CacheEntryInformation entry = new CacheEntryInformation(key, name, size, mimeType, Instant.now());
        this.modCacheEntries.put(key, entry);
        this.markModified();
    }

    protected void postAspectEvents(Set<String> aspectIds, String operation) {
        String channelId = this.channelId;
        StorageManager.executeAfterPersist(() -> {
            for (String aspectFactoryId : aspectIds) {
                this.postAspectEvent(channelId, aspectFactoryId, operation);
            }
        });
    }

    protected void postAspectEvent(String channelId, String aspectId, String operation) {
        if (this.eventAdmin != null) {
            HashMap<String, String> data = new HashMap<String, String>(2);
            data.put("operation", operation);
            data.put("aspectFactoryId", aspectId);
            this.eventAdmin.postEvent(new Event(String.format("drone/channel/%s/aspect", ModifyContextImpl.makeSafeTopic(channelId)), data));
        }
    }

    private static String makeSafeTopic(String aspectId) {
        return aspectId.replaceAll("[^a-zA-Z0-9_\\-]", "_");
    }

    private void markModified() {
        Instant now = Instant.now();
        this.state.setModificationTimestamp(now);
    }
}

