/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.version.ui.quickfixes;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.oomph.internal.version.Activator;
import org.eclipse.oomph.internal.version.VersionBuilderArguments;
import org.eclipse.oomph.version.Markers;
import org.eclipse.oomph.version.VersionUtil;
import org.eclipse.oomph.version.ui.quickfixes.AbstractResolution;

public class ReleasePathResolution
extends AbstractResolution {
    public ReleasePathResolution(IMarker marker) {
        super(marker, "Add to ignored releases", "icons/correction_configure.gif");
    }

    protected boolean isApplicable(IMarker marker) {
        return "release.path".equals(Markers.getProblemType((IMarker)marker));
    }

    public String getDescription() {
        IMarker marker = this.getMarker();
        IProject project = marker.getResource().getProject();
        VersionBuilderArguments arguments = new VersionBuilderArguments(project);
        return "Configure '" + arguments.getReleasePath() + "' to ignore all release checking associated with it. To re-enable this checking, use the Preferences dialog to manage the release check mode.";
    }

    protected void apply(IMarker marker) throws Exception {
        IProject project = marker.getResource().getProject();
        VersionBuilderArguments arguments = new VersionBuilderArguments(project);
        String releasePath = arguments.getReleasePath();
        Activator.setReleaseCheckMode((String)releasePath, (Activator.ReleaseCheckMode)Activator.ReleaseCheckMode.NONE);
        VersionUtil.cleanReleaseProjects((String)releasePath);
    }
}

