/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: UniformResourceIdentifierImpl.java,v 1.1 2007/03/18 08:10:12 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfbase.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.eodm.rdf.rdfbase.RDFSResource;
import org.eclipse.eodm.rdf.rdfbase.UniformResourceIdentifier;
import org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage;
import org.eclipse.eodm.rdf.rdfweb.LocalName;
import org.eclipse.eodm.rdf.rdfweb.Namespace;
import org.eclipse.eodm.rdf.rdfweb.util.RDFWebPackage;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Uniform Resource Identifier</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.impl.UniformResourceIdentifierImpl#getName <em>Name</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class UniformResourceIdentifierImpl extends URIReferenceImpl implements UniformResourceIdentifier {
	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = "";

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UniformResourceIdentifierImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return RDFBasePackage.eINSTANCE.getUniformResourceIdentifier();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__FRAGMENT_IDENTIFIER:
					if (fragmentIdentifier != null)
						msgs = ((InternalEObject)fragmentIdentifier).eInverseRemove(this, RDFWebPackage.LOCAL_NAME__URI_REF, LocalName.class, msgs);
					return basicSetFragmentIdentifier((LocalName)otherEnd, msgs);
				case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__RESOURCE:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__RESOURCE, msgs);
				case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__REIFIED_STATEMENT:
					return ((InternalEList)getReifiedStatement()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__FRAGMENT_IDENTIFIER:
					return basicSetFragmentIdentifier(null, msgs);
				case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__RESOURCE:
					return eBasicSetContainer(null, RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__RESOURCE, msgs);
				case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__REIFIED_STATEMENT:
					return ((InternalEList)getReifiedStatement()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__RESOURCE:
					return eContainer.eInverseRemove(this, RDFBasePackage.RDFS_RESOURCE__URI_REF, RDFSResource.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return eContainer.eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__FRAGMENT_IDENTIFIER:
				if (resolve) return getFragmentIdentifier();
				return basicGetFragmentIdentifier();
			case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__NAMESPACE:
				if (resolve) return getNamespace();
				return basicGetNamespace();
			case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__RESOURCE:
				return getResource();
			case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__REIFIED_STATEMENT:
				return getReifiedStatement();
			case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__URI:
				if (resolve) return getUri();
				return basicGetUri();
			case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__NAME:
				return getName();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__FRAGMENT_IDENTIFIER:
				setFragmentIdentifier((LocalName)newValue);
				return;
			case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__NAMESPACE:
				setNamespace((Namespace)newValue);
				return;
			case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__RESOURCE:
				setResource((RDFSResource)newValue);
				return;
			case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__REIFIED_STATEMENT:
				getReifiedStatement().clear();
				getReifiedStatement().addAll((Collection)newValue);
				return;
			case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__URI:
				setUri((UniformResourceIdentifier)newValue);
				return;
			case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__NAME:
				setName((String)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__FRAGMENT_IDENTIFIER:
				setFragmentIdentifier((LocalName)null);
				return;
			case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__NAMESPACE:
				setNamespace((Namespace)null);
				return;
			case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__RESOURCE:
				setResource((RDFSResource)null);
				return;
			case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__REIFIED_STATEMENT:
				getReifiedStatement().clear();
				return;
			case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__URI:
				setUri((UniformResourceIdentifier)null);
				return;
			case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__NAME:
				setName(NAME_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__FRAGMENT_IDENTIFIER:
				return fragmentIdentifier != null;
			case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__NAMESPACE:
				return namespace != null;
			case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__RESOURCE:
				return getResource() != null;
			case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__REIFIED_STATEMENT:
				return reifiedStatement != null && !reifiedStatement.isEmpty();
			case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__URI:
				return uri != null;
			case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(')');
		return result.toString();
	}

} //UniformResourceIdentifierImpl
