/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: RDFGraph.java,v 1.1 2007/03/18 08:10:08 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfbase;

import org.eclipse.emf.common.util.EList;
import org.eclipse.eodm.exceptions.AddingTripleException;
import org.eclipse.eodm.exceptions.UnsupportedViewTypeException;
import org.eclipse.eodm.util.Triple;

import java.util.ArrayList;
import java.util.Iterator;
import java.net.URISyntaxException;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>RDFGraph</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following ODM features are supported:
 * <ul>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.RDFGraph#getGraphstatement <em>graphstatement</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.RDFGraph#getGraphName <em>graphName</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getGraph()
 * @model
 * @generated
 */
public interface RDFGraph extends RDFSResource {
	/**
	 * Returns the value of the '<em><b>graphstatement</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfbase.RDFStatement}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Graphstatement</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>graphstatement</em>' reference list.
	 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getGraph_Graphstatement()
	 * @model type="org.eclipse.eodm.rdf.rdfbase.RDFStatement" required="true"
	 * @generated
	 */
	EList getGraphstatement();

	/**
	 * Returns the value of the '<em><b>graphName</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>RDFGraph Name</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>graphName</em>' containment reference.
	 * @see #setGraphName(URIReference)
	 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getGraph_GraphName()
	 * @model containment="true"
	 * @generated
	 */
	URIReference getGraphName();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.rdf.rdfbase.RDFGraph#getGraphName <em>graphName</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>graphName</em>' containment reference.
	 * @see #getGraphName()
	 * @generated
	 */
	void setGraphName(URIReference value);
	/**
	 * Return the given type Resources in current graph
	 * 
	 * @param uri the URI of the class type of the resources required 
	 * @param withSpec if withSpec is set true, the meta resources will be return
	 * eg. the type of RDFSClass resource is a RDFSClass object itself. 
	 * @return the ArrayList of resources of required type
	 */
	ArrayList getTypeResources( String uri, boolean withSpec )throws UnsupportedViewTypeException;
	/**
	 * Return the given type Resources in current graph
	 * 
	 * @param uri the URI of the class type of the resources required 
	 * @return the ArrayList of resources of required type
	 */
	ArrayList getTypeResources(String uri)throws UnsupportedViewTypeException;
	
	/**
	 * Add a triple into the RDFGraph, and the OO based memory model changed correspondly
	 * 
	 * @param triple 
	 * @throws AddingTripleException, UnsupportedViewTypeException, URISyntaxException
	 */
	void addTriple(Triple triple)throws UnsupportedViewTypeException,URISyntaxException, AddingTripleException;
	
	/**
	 * Return the ArrayList of {@link org.eclipse.eodm.util.Triple <em>Triple</em>}
	 * Export all triples contained in current graph
	 * @return
	 */
	ArrayList exportTriples();
	/**
     * Delete a triple into the RDFGraph, and the OO based memory model changed correspondly
	 * @param triple the triple to be deleted
	 */
	void deleteTriple(Triple triple);
	
	/**
	 * Return the Iterator of resources in current graph.
	 * @return 
	 */
	Iterator getTriples();
	/**
	 * Return the resource of the given URI
	 * 
	 * @param uri the uri of the resource 
	 * @return the resource of the given URI
	 */
	RDFSResource getRDFSResource(String uri);
	
	/**
	 * @return all the resources in the graph
	 */
	Iterator getAllResources();
	
	/**
	 * @param whether to return resources defined in RDF/OWL spec
	 * @return all the resources in the graph
	 */	
	Iterator getAllResources(boolean withSpec);
	

} // RDFGraph
