/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.xtend.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.internal.xtend.expression.ast.DeclaredParameter;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.internal.xtend.xtend.XtendFile;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Around
extends SyntaxElement {
    public static final String CONTEXT_PARAM_NAME = "ctx";
    private Identifier pointcut;
    private List<DeclaredParameter> params;
    private boolean wildparams;
    private Expression expression;
    private XtendFile parent = null;
    private Pattern p;

    public Around(Identifier pointcut, List<DeclaredParameter> params, boolean wildparams, Expression expr) {
        this.pointcut = pointcut;
        this.params = params;
        this.wildparams = wildparams;
        this.expression = expr;
    }

    public Identifier getPointCut() {
        return this.pointcut;
    }

    public boolean isWildparams() {
        return this.wildparams;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public List<DeclaredParameter> getParams() {
        return this.params;
    }

    public void setParent(XtendFile parent) {
        this.parent = parent;
    }

    public XtendFile getParent() {
        return this.parent;
    }

    public List<Type> getParamTypes(ExecutionContext ctx) {
        ctx = ctx.cloneWithResource(this.getParent());
        ArrayList<Type> result = new ArrayList<Type>();
        for (DeclaredParameter p : this.getParams()) {
            result.add(ctx.getTypeForName(p.getType().getValue()));
        }
        return result;
    }

    public boolean nameMatches(String fqn) {
        if (this.p == null) {
            this.p = Pattern.compile(this.pointcut.getValue().replaceAll("\\*", ".*"));
        }
        Matcher m = this.p.matcher(fqn);
        return m.matches();
    }

    public void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        ctx = ctx.cloneWithoutVariables();
        ctx = ctx.cloneWithResource(this.getParent());
        for (DeclaredParameter p : this.getParams()) {
            String name = p.getName().getValue();
            if (name.equals(CONTEXT_PARAM_NAME)) {
                issues.add(new AnalysationIssue(AnalysationIssue.SYNTAX_ERROR, "The variable name 'ctx' is not allowed here!", p.getName()));
            }
            Type t = ctx.getTypeForName(p.getType().getValue());
            ctx = ctx.cloneWithVariable(new Variable(name, t));
        }
        ctx = ctx.cloneWithVariable(new Variable(CONTEXT_PARAM_NAME, ctx.getTypeForName("xtend::AdviceContext")));
        this.expression.analyze(ctx, issues);
    }

    public String toString() {
        return " around " + this.pointcut + "(" + this.paramsToString() + (this.isWildparams() ? " * " : "") + ") from " + this.getParent().getFullyQualifiedName();
    }

    private String paramsToString() {
        StringBuffer b = new StringBuffer("");
        Iterator<DeclaredParameter> iter = this.getParams().iterator();
        while (iter.hasNext()) {
            DeclaredParameter p = iter.next();
            b.append(p.getType() + " " + p.getName());
            if (!iter.hasNext()) continue;
            b.append(",");
        }
        return b.toString();
    }
}

