/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.util;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class ShiftedImageDescriptor
extends CompositeImageDescriptor {
    private Point size = null;
    private short shiftX = 0;
    private short shiftY = 0;
    private ImageData imageData = null;

    public ShiftedImageDescriptor(short shiftX, short shiftY, ImageDescriptor imageDescriptor) {
        assert (shiftX >= 0);
        assert (shiftY >= 0);
        assert (imageDescriptor.getImageData().width >= 0);
        assert (imageDescriptor.getImageData().height >= 0);
        assert (imageDescriptor != null);
        this.shiftX = shiftX;
        this.shiftY = shiftY;
        this.imageData = imageDescriptor.getImageData();
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage(this.imageData, this.shiftX, this.shiftY);
    }

    protected Point getSize() {
        if (this.size == null) {
            this.size = new Point(this.imageData.width + this.shiftX, this.imageData.height + this.shiftY);
        }
        return this.size;
    }
}

