/*
 * Decompiled with CFR 0.152.
 */
package hbtutorial;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.teneo.hibernate.HbDataStore;
import org.eclipse.emf.teneo.hibernate.HbHelper;
import org.eclipse.example.library.Book;
import org.eclipse.example.library.BookCategory;
import org.eclipse.example.library.Library;
import org.eclipse.example.library.LibraryFactory;
import org.eclipse.example.library.LibraryPackage;
import org.eclipse.example.library.Writer;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;

public class Tutorial1 {
    public static void main(String[] args) {
        HbDataStore dataStore = HbHelper.INSTANCE.createRegisterDataStore("LibraryDataStore");
        Properties hibernateProperties = new Properties();
        hibernateProperties.setProperty("hibernate.connection.driver_class", "com.mysql.jdbc.Driver");
        hibernateProperties.setProperty("hibernate.connection.username", "root");
        hibernateProperties.setProperty("hibernate.connection.url", "jdbc:mysql://127.0.0.1:3306/library");
        hibernateProperties.setProperty("hibernate.connection.password", "root");
        hibernateProperties.setProperty("hibernate.dialect", "org.hibernate.dialect.MySQLInnoDBDialect");
        dataStore.setProperties(hibernateProperties);
        dataStore.setEPackages(new EPackage[]{LibraryPackage.eINSTANCE});
        dataStore.initialize();
        SessionFactory sessionFactory = dataStore.getSessionFactory();
        Session session = sessionFactory.openSession();
        session.beginTransaction();
        Library library = LibraryFactory.eINSTANCE.createLibrary();
        library.setName("My Library");
        session.save((Object)library);
        Writer writer = LibraryFactory.eINSTANCE.createWriter();
        writer.setName("JRR Tolkien");
        Book book = LibraryFactory.eINSTANCE.createBook();
        book.setAuthor(writer);
        book.setPages(305);
        book.setTitle("The Hobbit");
        book.setCategory(BookCategory.SCIENCE_FICTION);
        library.getWriters().add((Object)writer);
        library.getBooks().add((Object)book);
        session.getTransaction().commit();
        session.close();
        session = sessionFactory.openSession();
        session.beginTransaction();
        Query query = session.createQuery("FROM Library");
        List libraries = query.list();
        Library library2 = (Library)libraries.get(0);
        Writer writer2 = (Writer)library2.getWriters().get(0);
        System.out.println(writer2.getName());
        Book book2 = (Book)library2.getBooks().get(0);
        System.out.println(book2.getTitle());
        assert (book2.eContainer() == library2);
        assert (writer2.getBooks().get(0) == book2);
        Writer georgeOrwell = LibraryFactory.eINSTANCE.createWriter();
        georgeOrwell.setName("G. Orwell");
        Book georgesBook = LibraryFactory.eINSTANCE.createBook();
        georgesBook.setPages(250);
        georgesBook.setTitle("1984");
        georgesBook.setCategory(BookCategory.SCIENCE_FICTION);
        georgesBook.setAuthor(georgeOrwell);
        library2.getBooks().add((Object)georgesBook);
        library2.getWriters().add((Object)georgeOrwell);
        session.getTransaction().commit();
        session.close();
        session = sessionFactory.openSession();
        session.beginTransaction();
        query = session.createQuery("FROM Book");
        List books = query.list();
        for (Book book3 : books) {
            System.out.println(book3.getTitle());
        }
        query = session.createQuery("SELECT book FROM Book book, Writer writ WHERE  book.title='1984' AND book.author=writ AND writ.name='G. Orwell'");
        books = query.list();
        System.out.println("There are " + books.size() + " in the Library.");
        System.out.println(books.get(0).getClass().getName());
        book = (Book)books.get(0);
        System.out.println(book.getTitle());
        System.out.println(book.getAuthor().getName());
        query = session.createQuery("SELECT count(allbooks) FROM Library lib LEFT JOIN lib.books AS allbooks  WHERE lib.name='My Library'");
        int count = ((Number)query.uniqueResult()).intValue();
        System.out.println("There are " + count + " books in the library");
        session.getTransaction().commit();
        try {
            String uriStr = "hibernate://?dsname=LibraryDataStore";
            URI uri = URI.createURI((String)uriStr);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource res = resourceSet.createResource(uri);
            res.load(Collections.EMPTY_MAP);
            for (Library libTest : res.getContents()) {
                System.out.println(libTest.getName());
            }
            Library libNew = LibraryFactory.eINSTANCE.createLibrary();
            libNew.setName("My Second Library");
            Writer writerNew = LibraryFactory.eINSTANCE.createWriter();
            writerNew.setName("I. Asimov");
            Book bookNew = LibraryFactory.eINSTANCE.createBook();
            bookNew.setAuthor(writerNew);
            bookNew.setPages(305);
            bookNew.setTitle("Foundation and Empire");
            bookNew.setCategory(BookCategory.SCIENCE_FICTION);
            libNew.getWriters().add((Object)writerNew);
            libNew.getBooks().add((Object)bookNew);
            res.getContents().add((Object)libNew);
            res.save(null);
        }
        catch (IOException e) {
            throw new Error("IOException", e);
        }
    }
}

